/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.dialog;

import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.dialog.Dialog;
import org.zoolu.sip.dialog.SubscriberDialogListener;
import org.zoolu.sip.header.AcceptHeader;
import org.zoolu.sip.header.ExpiresHeader;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.MessageFactory;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.transaction.TransactionClient;
import org.zoolu.sip.transaction.TransactionClientListener;
import org.zoolu.sip.transaction.TransactionServer;

public class SubscriberDialog
extends Dialog
implements TransactionClientListener {
    protected static final String ACTIVE = "active";
    protected static final String PENDING = "pending";
    protected static final String TERMINATED = "terminated";
    TransactionClient subscribe_transaction;
    SubscriberDialogListener listener;
    String event;
    String id;
    protected static final int D_INIT = 0;
    protected static final int D_SUBSCRIBING = 1;
    protected static final int D_ACCEPTED = 2;
    protected static final int D_PENDING = 3;
    protected static final int D_ACTIVE = 4;
    protected static final int D_TERMINATED = 9;

    protected String getStatus() {
        switch (this.status) {
            case 0: {
                return "D_INIT";
            }
            case 1: {
                return "D_SUBSCRIBING";
            }
            case 2: {
                return "D_ACCEPTED";
            }
            case 3: {
                return "D_PENDING";
            }
            case 4: {
                return "D_ACTIVE";
            }
            case 9: {
                return "D_TERMINATED";
            }
        }
        return null;
    }

    public boolean isEarly() {
        return this.status < 2;
    }

    public boolean isConfirmed() {
        return this.status >= 2 && this.status < 9;
    }

    public boolean isTerminated() {
        return this.status == 9;
    }

    public boolean isSubscriptionPending() {
        return this.status >= 2 && this.status < 4;
    }

    public boolean isSubscriptionActive() {
        return this.status == 4;
    }

    public boolean isSubscriptionTerminated() {
        return this.status == 9;
    }

    public String getEvent() {
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public SubscriberDialog(SipProvider sip_provider, String event, String id, SubscriberDialogListener listener) {
        super(sip_provider);
        this.listener = listener;
        this.subscribe_transaction = null;
        this.event = event;
        this.id = null;
        this.changeStatus(0);
    }

    public void subscribe(String target, String subscriber, String contact, int expires) {
        this.log.debug((Object)("inside subscribe(target=" + target + ",subscriber=" + subscriber + ",contact=" + contact + ",id=" + this.id + ",expires=" + expires + ")"));
        SipURL request_uri = new SipURL(target);
        NameAddress to_url = new NameAddress(target);
        NameAddress from_url = new NameAddress(subscriber);
        NameAddress contact_url = contact != null ? new NameAddress(contact) : from_url;
        String content_type = null;
        String body = null;
        Message req = MessageFactory.createSubscribeRequest(this.sip_provider, request_uri, to_url, from_url, contact_url, this.event, this.id, content_type, body);
        req.setHeader(new AcceptHeader("application/pidf+xml"));
        req.setExpiresHeader(new ExpiresHeader(expires));
        this.subscribe(req);
    }

    public void subscribe(Message req) {
        this.log.debug((Object)"inside subscribe(req)");
        if (this.statusIs(9)) {
            this.log.debug((Object)"subscription already terminated: request aborted");
            return;
        }
        if (this.statusIs(0)) {
            this.changeStatus(1);
        }
        this.update(0, req);
        this.subscribe_transaction = new TransactionClient(this.sip_provider, req, this);
        this.subscribe_transaction.request();
    }

    public void reSubscribe(String target, String subscriber, String contact, int expires) {
        this.subscribe(target, subscriber, contact, expires);
    }

    public void onTransProvisionalResponse(TransactionClient tc, Message resp) {
        this.log.debug((Object)"onTransProvisionalResponse()");
    }

    public void onTransSuccessResponse(TransactionClient tc, Message resp) {
        this.log.debug((Object)"onTransSuccessResponse()");
        if (!this.statusIs(4)) {
            this.changeStatus(2);
            this.update(0, resp);
            StatusLine status_line = resp.getStatusLine();
            if (this.listener != null) {
                this.listener.onDlgSubscriptionSuccess(this, status_line.getCode(), status_line.getReason(), resp);
            }
        } else if (this.statusIs(4)) {
            StatusLine status_line = resp.getStatusLine();
            if (this.listener != null) {
                this.listener.onDlgSubscriptionSuccess(this, status_line.getCode(), status_line.getReason(), resp);
            }
        }
    }

    public void onTransFailureResponse(TransactionClient tc, Message resp) {
        this.log.debug((Object)"onTransFailureResponse()");
        this.changeStatus(9);
        StatusLine status_line = resp.getStatusLine();
        if (this.listener != null) {
            this.listener.onDlgSubscriptionFailure(this, status_line.getCode(), status_line.getReason(), resp);
        }
    }

    public void onTransTimeout(TransactionClient tc) {
        this.log.debug((Object)"onTransTimeout()");
        this.changeStatus(9);
        if (this.listener != null) {
            this.listener.onDlgSubscribeTimeout(this);
        }
    }

    public void onReceivedMessage(SipProvider sip_provider, Message msg) {
        this.log.debug((Object)"onReceivedMessage()");
        if (this.statusIs(9)) {
            this.log.debug((Object)"subscription already terminated: message discarded");
            return;
        }
        if (msg.isRequest() && msg.isNotify()) {
            TransactionServer ts = new TransactionServer(sip_provider, msg, null);
            ts.respondWith(MessageFactory.createResponse(msg, 200, SipResponses.reasonOf(200), null));
            NameAddress to = msg.getToHeader().getNameAddress();
            NameAddress from = msg.getFromHeader().getNameAddress();
            NameAddress contact = null;
            if (msg.hasContactHeader()) {
                contact = msg.getContactHeader().getNameAddress();
            }
            String state = null;
            if (msg.hasSubscriptionStateHeader()) {
                state = msg.getSubscriptionStateHeader().getState();
            }
            String content_type = null;
            if (msg.hasContentTypeHeader()) {
                content_type = msg.getContentTypeHeader().getContentType();
            }
            String body = null;
            if (msg.hasBody()) {
                body = msg.getBody();
            }
            if (this.listener != null) {
                this.listener.onDlgNotify(this, to, from, contact, state, content_type, body, msg);
            }
            if (state != null) {
                if (state.equalsIgnoreCase(ACTIVE) && !this.statusIs(9)) {
                    this.changeStatus(4);
                } else if (state.equalsIgnoreCase(PENDING) && this.statusIs(2)) {
                    this.changeStatus(3);
                } else if (state.equalsIgnoreCase(TERMINATED) && !this.statusIs(9)) {
                    this.changeStatus(9);
                    if (this.listener != null) {
                        this.listener.onDlgSubscriptionTerminated(this);
                    }
                }
            }
        } else {
            this.log.info((Object)"message is not a NOTIFY: message discarded");
        }
    }
}

