/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import java.util.Vector;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.provider.SipParser;

public abstract class AuthenticationHeader
extends Header {
    public static String LWS_SEPARATOR = " ";
    public static String[] QUOTED_PARAMETERS = new String[]{"auts", "cnonce", "nextnonce", "nonce", "opaque", "realm", "response", "rspauth", "uri", "username"};

    private static boolean isQuotedParameter(String param_name) {
        int i = 0;
        while (i < QUOTED_PARAMETERS.length) {
            if (param_name.equalsIgnoreCase(QUOTED_PARAMETERS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public AuthenticationHeader(String hname, String hvalue) {
        super(hname, hvalue);
    }

    public AuthenticationHeader(Header hd) {
        super(hd);
    }

    public AuthenticationHeader(String hname, String auth_scheme, Vector auth_params) {
        super(hname, auth_scheme);
        if (auth_params.size() > 0) {
            this.value = String.valueOf(this.value) + " " + (String)auth_params.elementAt(0);
        }
        int i = 1;
        while (i < auth_params.size()) {
            this.value = String.valueOf(this.value) + "," + LWS_SEPARATOR + (String)auth_params.elementAt(i);
            ++i;
        }
    }

    public void addParameter(String param_name, String param_value) {
        if (param_value.indexOf(34) < 0 && AuthenticationHeader.isQuotedParameter(param_name)) {
            this.addQuotedParameter(param_name, param_value);
        } else {
            this.addUnquotedParameter(param_name, param_value);
        }
    }

    public void addUnquotedParameter(String param_name, String param_value) {
        this.value = this.value.indexOf(61) < 0 ? String.valueOf(this.value) + " " : String.valueOf(this.value) + "," + LWS_SEPARATOR;
        this.value = String.valueOf(this.value) + param_name + "=" + param_value;
    }

    public void addQuotedParameter(String param_name, String param_value) {
        this.value = this.value.indexOf(61) < 0 ? String.valueOf(this.value) + " " : String.valueOf(this.value) + "," + LWS_SEPARATOR;
        this.value = param_value.indexOf(34) >= 0 ? String.valueOf(this.value) + param_name + "=" + param_value : String.valueOf(this.value) + param_name + "=\"" + param_value + "\"";
    }

    public boolean hasParameter(String param_name) {
        char[] name_separators = new char[]{'=', ' ', '\t', '\r', '\n'};
        SipParser par = new SipParser(this.value);
        par.skipString();
        par.skipWSPCRLF();
        while (par.hasMore()) {
            String name = par.getWord(name_separators);
            if (name.equals(param_name)) {
                return true;
            }
            par.goToCommaHeaderSeparator().skipChar().skipWSPCRLF();
        }
        return false;
    }

    public String getParameter(String param_name) {
        char[] name_separators = new char[]{'=', ' ', '\t'};
        SipParser par = new SipParser(this.value);
        par.skipString();
        par.skipWSPCRLF();
        while (par.hasMore()) {
            String name = par.getWord(name_separators);
            if (name.equals(param_name)) {
                par.goTo('=').skipChar().skipWSP();
                int comma = par.indexOfCommaHeaderSeparator();
                if (comma >= 0) {
                    par = new SipParser(par.getString(comma - par.getPos()));
                }
                return par.getStringUnquoted();
            }
            par.goToCommaHeaderSeparator().skipChar().skipWSPCRLF();
        }
        return null;
    }

    public Vector getParameters() {
        char[] name_separators = new char[]{'=', ' ', '\t'};
        SipParser par = new SipParser(this.value);
        par.skipString();
        par.skipWSPCRLF();
        Vector<String> names = new Vector<String>();
        while (par.hasMore()) {
            String name = par.getWord(name_separators);
            names.addElement(name);
            par.goToCommaHeaderSeparator().skipChar().skipWSPCRLF();
        }
        return names;
    }

    public String getAuthScheme() {
        SipParser par = new SipParser(this.value);
        return par.getString();
    }

    public boolean hasRealmParam() {
        return this.hasParameter("realm");
    }

    public String getRealmParam() {
        return this.getParameter("realm");
    }

    public void addRealmParam(String unquoted_realm) {
        this.addQuotedParameter("realm", unquoted_realm);
    }

    public boolean hasNonceParam() {
        return this.hasParameter("nonce");
    }

    public String getNonceParam() {
        return this.getParameter("nonce");
    }

    public void addNonceParam(String unquoted_nonce) {
        this.addQuotedParameter("nonce", unquoted_nonce);
    }

    public boolean hasOpaqueParam() {
        return this.hasParameter("opaque");
    }

    public String getOpaqueParam() {
        return this.getParameter("opaque");
    }

    public void addOpaqueParam(String unquoted_opaque) {
        this.addQuotedParameter("opaque", unquoted_opaque);
    }

    public boolean hasUsernameParam() {
        return this.hasParameter("username");
    }

    public String getUsernameParam() {
        return this.getParameter("username");
    }

    public void addUsernameParam(String unquoted_username) {
        this.addQuotedParameter("username", unquoted_username);
    }

    public boolean hasUriParam() {
        return this.hasParameter("uri");
    }

    public String getUriParam() {
        return this.getParameter("uri");
    }

    public void addUriParam(String unquoted_uri) {
        this.addQuotedParameter("uri", unquoted_uri);
    }

    public boolean hasResponseParam() {
        return this.hasParameter("response");
    }

    public String getResponseParam() {
        return this.getParameter("response");
    }

    public void addResponseParam(String unquoted_response) {
        this.addQuotedParameter("response", unquoted_response);
    }

    public boolean hasCnonceParam() {
        return this.hasParameter("cnonce");
    }

    public String getCnonceParam() {
        return this.getParameter("cnonce");
    }

    public void addCnonceParam(String unquoted_cnonce) {
        this.addQuotedParameter("cnonce", unquoted_cnonce);
    }

    public boolean hasRspauthParam() {
        return this.hasParameter("rspauth");
    }

    public String getRspauthParam() {
        return this.getParameter("rspauth");
    }

    public void addRspauthParam(String unquoted_rspauth) {
        this.addQuotedParameter("rspauth", unquoted_rspauth);
    }

    public boolean hasAutsParam() {
        return this.hasParameter("auts");
    }

    public String getAutsParam() {
        return this.getParameter("auts");
    }

    public void addAutsParam(String unquoted_auts) {
        this.addQuotedParameter("auts", unquoted_auts);
    }

    public boolean hasNextnonceParam() {
        return this.hasParameter("nextnonce");
    }

    public String getNextnonceParam() {
        return this.getParameter("nextnonce");
    }

    public void addNextnonceParam(String unquoted_nextnonce) {
        this.addQuotedParameter("nextnonce", unquoted_nextnonce);
    }

    public boolean hasQopOptionsParam() {
        return this.hasParameter("qop");
    }

    public String getQopOptionsParam() {
        return this.getParameter("qop");
    }

    public void addQopOptionsParam(String unquoted_qop_options) {
        this.addQuotedParameter("qop", unquoted_qop_options);
    }

    public boolean hasQopParam() {
        return this.hasParameter("qop");
    }

    public String getQopParam() {
        return this.getParameter("qop");
    }

    public void addQopParam(String qop) {
        this.addUnquotedParameter("qop", qop);
    }

    public boolean hasNcParam() {
        return this.hasParameter("nc");
    }

    public String getNcParam() {
        return this.getParameter("nc");
    }

    public void addNcParam(String nc) {
        this.addUnquotedParameter("nc", nc);
    }

    public boolean hasAlgorithmParam() {
        return this.hasParameter("algorithm");
    }

    public String getAlgorithParam() {
        return this.getParameter("algorithm");
    }

    public void addAlgorithParam(String algorithm) {
        this.addUnquotedParameter("algorithm", algorithm);
    }
}

