/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import java.util.Date;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.header.EndPointHeader;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.provider.SipParser;
import org.zoolu.tools.DateFormat;
import org.zoolu.tools.Parser;

public class ContactHeader
extends EndPointHeader {
    public ContactHeader() {
        super(new Header("Contact", null));
        this.value = "*";
    }

    public ContactHeader(NameAddress nameaddr) {
        super("Contact", nameaddr);
    }

    public ContactHeader(SipURL url) {
        super("Contact", url);
    }

    public ContactHeader(Header hd) {
        super(hd);
    }

    public ContactHeader setExpires(Date expire) {
        this.setParameter("expires", "\"" + DateFormat.formatEEEddMMM(expire) + "\"");
        return this;
    }

    public ContactHeader setExpires(int secs) {
        this.setParameter("expires", Integer.toString(secs));
        return this;
    }

    public boolean isStar() {
        return this.value.indexOf(42) >= 0;
    }

    public boolean hasExpires() {
        return this.hasParameter("expires");
    }

    public boolean isExpired() {
        return this.getExpires() == 0;
    }

    public int getExpires() {
        int secs = -1;
        String exp_param = this.getParameter("expires");
        if (exp_param != null) {
            if (exp_param.indexOf("GMT") >= 0) {
                Date date = new SipParser(new Parser(exp_param).getStringUnquoted()).getDate();
                secs = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
                if (secs < 0) {
                    secs = 0;
                }
            } else {
                secs = new SipParser(exp_param).getInt();
            }
        }
        return secs;
    }

    public Date getExpiresDate() {
        Date date = null;
        String exp_param = this.getParameter("expires");
        if (exp_param != null) {
            if (exp_param.indexOf("GMT") >= 0) {
                date = new SipParser(new Parser(exp_param).getStringUnquoted()).getDate();
            } else {
                long secs = new SipParser(exp_param).getInt();
                if (secs >= 0L) {
                    date = new Date(System.currentTimeMillis() + secs * 1000L);
                }
            }
        }
        return date;
    }

    public ContactHeader removeExpires() {
        this.removeParameter("expires");
        return this;
    }
}

