/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.NameAddressHeader;
import org.zoolu.sip.provider.SipParser;

public abstract class EndPointHeader
extends NameAddressHeader {
    static final String[] ENDPOINT_PARAMS = new String[]{"tag", "expires"};

    public EndPointHeader(String hname, NameAddress nameaddr) {
        super(hname, nameaddr);
    }

    public EndPointHeader(String hname, SipURL url) {
        super(hname, url);
    }

    public EndPointHeader(String hname, NameAddress nameaddr, String tag) {
        super(hname, nameaddr);
        if (tag != null) {
            this.setParameter("tag", tag);
        }
    }

    public EndPointHeader(String hname, SipURL url, String tag) {
        super(hname, url);
        if (tag != null) {
            this.setParameter("tag", tag);
        }
    }

    public EndPointHeader(Header hd) {
        super(hd);
    }

    public String getTag() {
        return this.getParameter("tag");
    }

    public boolean hasTag() {
        return this.hasParameter("tag");
    }

    public NameAddress getNameAddress() {
        NameAddress naddr = new SipParser(this.value).getNameAddress();
        SipURL url = naddr.getAddress();
        int i = 0;
        while (i < ENDPOINT_PARAMS.length) {
            if (url.hasParameter(ENDPOINT_PARAMS[i])) {
                url.removeParameter(ENDPOINT_PARAMS[i]);
                naddr = new NameAddress(naddr.getDisplayName(), url);
            }
            ++i;
        }
        return naddr;
    }
}

