/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import java.util.Date;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.SipDateHeader;
import org.zoolu.sip.provider.SipParser;
import org.zoolu.tools.Parser;

public class ExpiresHeader
extends SipDateHeader {
    public ExpiresHeader(String hvalue) {
        super("Expires", hvalue);
    }

    public ExpiresHeader(Date date) {
        super("Expires", date);
    }

    public ExpiresHeader(int seconds) {
        super("Expires", (String)null);
        this.value = String.valueOf(seconds);
    }

    public ExpiresHeader(Header hd) {
        super(hd);
    }

    public boolean isDate() {
        return this.value.indexOf("GMT") >= 0;
    }

    public int getDeltaSeconds() {
        int secs = -1;
        if (this.isDate()) {
            Date date = new SipParser(new Parser(this.value).getStringUnquoted()).getDate();
            secs = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
            if (secs < 0) {
                secs = 0;
            }
        } else {
            secs = new SipParser(this.value).getInt();
        }
        return secs;
    }

    public Date getDate() {
        Date date = null;
        if (this.isDate()) {
            date = new SipParser(new Parser(this.value).getStringUnquoted()).getDate();
        } else {
            long secs = this.getDeltaSeconds();
            if (secs >= 0L) {
                date = new Date(System.currentTimeMillis() + secs * 1000L);
            }
        }
        return date;
    }
}

