/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import java.util.Vector;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.provider.SipParser;

public class MultipleHeader {
    protected String name;
    protected Vector values;
    protected boolean compact;

    protected MultipleHeader() {
        this.name = null;
        this.values = new Vector();
        this.compact = true;
    }

    public MultipleHeader(String hname) {
        this.name = hname;
        this.values = new Vector();
        this.compact = true;
    }

    public MultipleHeader(String hname, Vector hvalues) {
        this.name = hname;
        this.values = hvalues;
        this.compact = true;
    }

    public MultipleHeader(Vector headers) {
        this.name = ((Header)headers.elementAt(0)).getName();
        this.values = new Vector(headers.size());
        int i = 0;
        while (i < headers.size()) {
            this.addBottom((Header)headers.elementAt(i));
            ++i;
        }
        this.compact = false;
    }

    public MultipleHeader(Header hd) {
        this.name = hd.getName();
        this.values = new Vector();
        SipParser par = new SipParser(hd.getValue());
        int comma = par.indexOfCommaHeaderSeparator();
        while (comma >= 0) {
            this.values.addElement(par.getString(comma - par.getPos()).trim());
            par.skipChar();
            comma = par.indexOfCommaHeaderSeparator();
        }
        this.values.addElement(par.getRemainingString().trim());
        this.compact = true;
    }

    public MultipleHeader(MultipleHeader mhd) {
        this.name = mhd.getName();
        this.values = mhd.getValues();
        this.compact = mhd.isCommaSeparated();
    }

    public static boolean isCommaSeparated(Header hd) {
        SipParser par = new SipParser(hd.getValue());
        return par.indexOfCommaHeaderSeparator() >= 0;
    }

    public void setCommaSeparated(boolean comma_separated) {
        this.compact = comma_separated;
    }

    public boolean isCommaSeparated() {
        return this.compact;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Object clone() {
        return new MultipleHeader(this.getName(), this.getValues());
    }

    public boolean equals(Object obj) {
        MultipleHeader hd = (MultipleHeader)obj;
        return hd.getName().equals(this.getName()) && hd.getValues().equals(this.getValues());
    }

    public String getName() {
        return this.name;
    }

    public Vector getValues() {
        return this.values;
    }

    public void setValues(Vector v) {
        this.values = v;
    }

    public Vector getHeaders() {
        Vector<Header> v = new Vector<Header>(this.values.size());
        int i = 0;
        while (i < this.values.size()) {
            Header h = new Header(this.name, (String)this.values.elementAt(i));
            v.addElement(h);
            ++i;
        }
        return v;
    }

    public void setHeaders(Vector hdv) {
        this.values = new Vector(hdv.size());
        int i = 0;
        while (i < hdv.size()) {
            this.values.addElement(((Header)hdv.elementAt(i)).getValue());
            ++i;
        }
    }

    public String getValue(int i) {
        return (String)this.values.elementAt(i);
    }

    public void addTop(Header hd) {
        this.values.insertElementAt(hd.getValue(), 0);
    }

    public Header getTop() {
        return new Header(this.name, (String)this.values.firstElement());
    }

    public void removeTop() {
        this.values.removeElementAt(0);
    }

    public void addBottom(Header hd) {
        if (!MultipleHeader.isCommaSeparated(hd)) {
            this.values.addElement(hd.getValue());
        } else {
            this.addBottom(new MultipleHeader(hd));
        }
    }

    public void addBottom(MultipleHeader mhd) {
        int i = 0;
        while (i < mhd.size()) {
            this.values.addElement(mhd.getValue(i));
            ++i;
        }
    }

    public Header getBottom() {
        return new Header(this.name, (String)this.values.lastElement());
    }

    public void removeBottom() {
        this.values.removeElementAt(this.values.size() - 1);
    }

    public Header toHeader() {
        String str = "";
        int i = 0;
        while (i < this.values.size() - 1) {
            str = String.valueOf(str) + this.values.elementAt(i) + ", ";
            ++i;
        }
        if (this.values.size() > 0) {
            str = String.valueOf(str) + this.values.elementAt(this.values.size() - 1);
        }
        return new Header(this.name, str);
    }

    public String toString() {
        if (this.compact) {
            String str = String.valueOf(this.name) + ": ";
            int i = 0;
            while (i < this.values.size() - 1) {
                str = String.valueOf(str) + this.values.elementAt(i) + ", ";
                ++i;
            }
            if (this.values.size() > 0) {
                str = String.valueOf(str) + this.values.elementAt(this.values.size() - 1);
            }
            return String.valueOf(str) + "\r\n";
        }
        String str = "";
        int i = 0;
        while (i < this.values.size()) {
            str = String.valueOf(str) + this.name + ": " + this.values.elementAt(i) + "\r\n";
            ++i;
        }
        return str;
    }
}

