/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import java.util.Vector;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.provider.SipParser;
import org.zoolu.tools.Parser;

public abstract class ParametricHeader
extends Header {
    protected ParametricHeader(String hname, String hvalue) {
        super(hname, hvalue);
    }

    protected ParametricHeader(Header hd) {
        super(hd);
    }

    protected int indexOfFirstSemi() {
        int index = new Parser(this.value).goToSkippingQuoted(';').getPos();
        return index >= this.value.length() ? -1 : index;
    }

    public String getParameter(String name) {
        int index = this.indexOfFirstSemi();
        if (index < 0) {
            return null;
        }
        return new SipParser(new Parser(this.getValue(), index).skipChar().skipWSP()).getParameter(name);
    }

    public Vector getParameterNames() {
        int index = this.indexOfFirstSemi();
        if (index < 0) {
            return new Vector();
        }
        return new SipParser(new Parser(this.getValue(), index).skipChar().skipWSP()).getParameters();
    }

    public boolean hasParameter(String name) {
        int index = this.indexOfFirstSemi();
        if (index < 0) {
            return false;
        }
        return new SipParser(new Parser(this.getValue(), index).skipChar().skipWSP()).hasParameter(name);
    }

    public boolean hasParameters() {
        return this.indexOfFirstSemi() >= 0;
    }

    public void removeParameters() {
        if (!this.hasParameters()) {
            return;
        }
        String header = this.getValue();
        int i = header.indexOf(59);
        header = header.substring(0, i);
        this.setValue(header);
    }

    public void removeParameter(String name) {
        int index = this.indexOfFirstSemi();
        if (index < 0) {
            return;
        }
        String header = this.getValue();
        Parser par = new Parser(header, index);
        while (par.hasMore()) {
            int begin_param = par.getPos();
            par.skipChar();
            if (par.getWord(SipParser.param_separators).equals(name)) {
                String top = header.substring(0, begin_param);
                par.goToSkippingQuoted(';');
                String bottom = "";
                if (par.hasMore()) {
                    bottom = header.substring(par.getPos());
                }
                header = top.concat(bottom);
                this.setValue(header);
                return;
            }
            par.goTo(';');
        }
    }

    public void setParameter(String name, String value) {
        if (this.getValue() == null) {
            this.setValue("");
        }
        if (this.hasParameter(name)) {
            this.removeParameter(name);
        }
        String header = this.getValue();
        header = header.concat(";" + name);
        if (value != null) {
            header = header.concat("=" + value);
        }
        this.setValue(header);
    }
}

