/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.ParametricHeader;
import org.zoolu.tools.Parser;

public class SubscriptionStateHeader
extends ParametricHeader {
    public static final String ACTIVE = "active";
    public static final String PENDING = "pending";
    public static final String TERMINATED = "terminated";
    private static final char[] delim = new char[]{',', ';', ' ', '\t', '\n', '\r'};

    public SubscriptionStateHeader(String state) {
        super("Subscription-State", state);
    }

    public SubscriptionStateHeader(Header hd) {
        super(hd);
    }

    public String getState() {
        return new Parser(this.value).getWord(delim);
    }

    public boolean isActive() {
        return this.getState().equals(ACTIVE);
    }

    public boolean isPending() {
        return this.getState().equals(PENDING);
    }

    public boolean isTerminated() {
        return this.getState().equals(TERMINATED);
    }

    public SubscriptionStateHeader setExpires(int secs) {
        this.setParameter("expires", Integer.toString(secs));
        return this;
    }

    public boolean hasExpires() {
        return this.hasParameter("expires");
    }

    public int getExpires() {
        String exp = this.getParameter("expires");
        if (exp != null) {
            return Integer.parseInt(exp);
        }
        return -1;
    }

    public SubscriptionStateHeader setReason(String reason) {
        this.setParameter("reason", reason);
        return this;
    }

    public boolean hasReason() {
        return this.hasParameter("reason");
    }

    public String getReason() {
        return this.getParameter("reason");
    }
}

