/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.header;

import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.ParametricHeader;
import org.zoolu.sip.provider.SipParser;

public class ViaHeader
extends ParametricHeader {
    protected static final String received_param = "received";
    protected static final String rport_param = "rport";
    protected static final String branch_param = "branch";
    protected static final String maddr_param = "maddr";
    protected static final String ttl_param = "ttl";

    public ViaHeader(String hvalue) {
        super("Via", hvalue);
    }

    public ViaHeader(Header hd) {
        super(hd);
    }

    public ViaHeader(String host, int port) {
        super("Via", "SIP/2.0/UDP " + host + ":" + port);
    }

    public ViaHeader(String proto, String host, int port) {
        super("Via", "SIP/2.0/" + proto.toUpperCase() + " " + host + ":" + port);
    }

    public String getProtocol() {
        SipParser par = new SipParser(this.value);
        return par.goTo('/').skipChar().goTo('/').skipChar().skipWSP().getString();
    }

    public String getSentBy() {
        SipParser par = new SipParser(this.value);
        par.goTo('/').skipChar().goTo('/').skipString().skipWSP();
        if (!par.hasMore()) {
            return null;
        }
        String sentby = this.value.substring(par.getPos(), par.indexOfSeparator());
        return sentby;
    }

    public String getHost() {
        String sentby = this.getSentBy();
        SipParser par = new SipParser(sentby);
        par.goTo(':');
        if (par.hasMore()) {
            return sentby.substring(0, par.getPos());
        }
        return sentby;
    }

    public boolean hasPort() {
        String sentby = this.getSentBy();
        return sentby.indexOf(":") > 0;
    }

    public int getPort() {
        SipParser par = new SipParser(this.getSentBy());
        par.goTo(':');
        if (par.hasMore()) {
            return par.skipChar().getInt();
        }
        return -1;
    }

    public SipURL getSipURL() {
        return new SipURL(this.getHost(), this.getPort());
    }

    public boolean hasBranch() {
        return this.hasParameter(branch_param);
    }

    public String getBranch() {
        return this.getParameter(branch_param);
    }

    public void setBranch(String value) {
        this.setParameter(branch_param, value);
    }

    public boolean hasReceived() {
        return this.hasParameter(received_param);
    }

    public String getReceived() {
        return this.getParameter(received_param);
    }

    public void setReceived(String value) {
        this.setParameter(received_param, value);
    }

    public boolean hasRport() {
        return this.hasParameter(rport_param);
    }

    public int getRport() {
        String value = this.getParameter(rport_param);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public void setRport() {
        this.setParameter(rport_param, null);
    }

    public void setRport(int port) {
        if (port < 0) {
            this.setParameter(rport_param, null);
        } else {
            this.setParameter(rport_param, Integer.toString(port));
        }
    }

    public boolean hasMaddr() {
        return this.hasParameter(maddr_param);
    }

    public String getMaddr() {
        return this.getParameter(maddr_param);
    }

    public void setMaddr(String value) {
        this.setParameter(maddr_param, value);
    }

    public boolean hasTtl() {
        return this.hasParameter(ttl_param);
    }

    public int getTtl() {
        String value = this.getParameter(ttl_param);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public void setTtl(int ttl) {
        this.setParameter(ttl_param, Integer.toString(ttl));
    }
}

