/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.message;

import java.util.Vector;
import org.zoolu.net.UdpPacket;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.header.AcceptHeader;
import org.zoolu.sip.header.AlertInfoHeader;
import org.zoolu.sip.header.AllowHeader;
import org.zoolu.sip.header.AuthenticationInfoHeader;
import org.zoolu.sip.header.AuthorizationHeader;
import org.zoolu.sip.header.CSeqHeader;
import org.zoolu.sip.header.CallIdHeader;
import org.zoolu.sip.header.ContactHeader;
import org.zoolu.sip.header.ContentLengthHeader;
import org.zoolu.sip.header.ContentTypeHeader;
import org.zoolu.sip.header.DateHeader;
import org.zoolu.sip.header.ExpiresHeader;
import org.zoolu.sip.header.FromHeader;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.MaxForwardsHeader;
import org.zoolu.sip.header.MultipleHeader;
import org.zoolu.sip.header.ProxyAuthenticateHeader;
import org.zoolu.sip.header.ProxyAuthorizationHeader;
import org.zoolu.sip.header.RecordRouteHeader;
import org.zoolu.sip.header.RequestLine;
import org.zoolu.sip.header.RouteHeader;
import org.zoolu.sip.header.ServerHeader;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.header.SubjectHeader;
import org.zoolu.sip.header.ToHeader;
import org.zoolu.sip.header.UserAgentHeader;
import org.zoolu.sip.header.ViaHeader;
import org.zoolu.sip.header.WwwAuthenticateHeader;
import org.zoolu.sip.message.SipMethods;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.DialogIdentifier;
import org.zoolu.sip.provider.MethodIdentifier;
import org.zoolu.sip.provider.SipParser;
import org.zoolu.sip.provider.TransactionIdentifier;

public abstract class BaseMessage {
    public static final String PROTO_UDP = "udp";
    public static final String PROTO_TCP = "tcp";
    public static final String PROTO_TLS = "tls";
    public static final String PROTO_SCTP = "sctp";
    protected static int MAX_PKT_SIZE = 8000;
    protected String remote_addr;
    protected int remote_port;
    protected String transport_proto;
    protected ConnectionIdentifier connection_id;
    private String message;

    private void init() {
        this.remote_addr = null;
        this.remote_port = 0;
        this.transport_proto = null;
        this.connection_id = null;
    }

    public BaseMessage() {
        this.init();
        this.message = "";
    }

    public BaseMessage(byte[] data, int offset, int len) {
        this.init();
        this.message = new String(data, offset, len);
    }

    public BaseMessage(UdpPacket packet) {
        this.init();
        this.message = new String(packet.getData(), packet.getOffset(), packet.getLength());
    }

    public BaseMessage(String str) {
        this.init();
        this.message = new String(str);
    }

    public BaseMessage(BaseMessage msg) {
        this.message = msg.message;
        this.remote_addr = msg.remote_addr;
        this.remote_port = msg.remote_port;
        this.transport_proto = msg.transport_proto;
        this.connection_id = msg.connection_id;
    }

    public abstract Object clone();

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return this.message;
    }

    public String getRemoteAddress() {
        return this.remote_addr;
    }

    public int getRemotePort() {
        return this.remote_port;
    }

    public String getTransportProtocol() {
        return this.transport_proto;
    }

    public ConnectionIdentifier getConnectionId() {
        return this.connection_id;
    }

    public int getLength() {
        return this.message.length();
    }

    public void setRemoteAddress(String addr) {
        this.remote_addr = addr;
    }

    public void setRemotePort(int port) {
        this.remote_port = port;
    }

    public void setTransport(String proto) {
        this.transport_proto = proto;
    }

    public void setConnectionId(ConnectionIdentifier conn_id) {
        this.connection_id = conn_id;
    }

    public DialogIdentifier getDialogId() {
        String remote_tag;
        String local_tag;
        String call_id = this.getCallIdHeader().getCallId();
        if (this.isRequest()) {
            local_tag = this.getToHeader().getTag();
            remote_tag = this.getFromHeader().getTag();
        } else {
            local_tag = this.getFromHeader().getTag();
            remote_tag = this.getToHeader().getTag();
        }
        return new DialogIdentifier(call_id, local_tag, remote_tag);
    }

    public TransactionIdentifier getTransactionId() {
        String call_id = this.getCallIdHeader().getCallId();
        ViaHeader top_via = this.getViaHeader();
        String branch = null;
        if (top_via.hasBranch()) {
            branch = top_via.getBranch();
        }
        String sent_by = top_via.getSentBy();
        CSeqHeader cseqh = this.getCSeqHeader();
        long seqn = cseqh.getSequenceNumber();
        String method = cseqh.getMethod();
        return new TransactionIdentifier(call_id, seqn, method, sent_by, branch);
    }

    public MethodIdentifier getMethodId() {
        String method = this.getCSeqHeader().getMethod();
        return new MethodIdentifier(method);
    }

    public boolean isRequest() throws NullPointerException {
        String target;
        if (this.message == null || this.isResponse()) {
            return false;
        }
        String firstline = new SipParser(this.message).getLine();
        String version = new SipParser(firstline).skipString().skipString().getString();
        if (version == null || version.length() < 4) {
            return false;
        }
        return (version = version.substring(0, 4)).equalsIgnoreCase(target = "SIP/");
    }

    public boolean isRequest(String method) {
        return this.message.startsWith(method);
    }

    public boolean createsDialog() {
        if (!this.isRequest()) {
            return false;
        }
        String method = this.getRequestLine().getMethod();
        int i = 0;
        while (i < SipMethods.dialog_methods.length) {
            if (method.equalsIgnoreCase(SipMethods.dialog_methods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isInvite() {
        return this.isRequest("INVITE");
    }

    public boolean isRegister() {
        return this.isRequest("REGISTER");
    }

    public boolean isCancel() {
        return this.isRequest("CANCEL");
    }

    public boolean isBye() {
        return this.isRequest("BYE");
    }

    public boolean isAck() {
        return this.isRequest("ACK");
    }

    public boolean isInfo() {
        return this.isRequest("INFO");
    }

    public boolean isOption() {
        return this.isRequest("OPTION");
    }

    protected boolean hasRequestLine() {
        return this.isRequest();
    }

    public RequestLine getRequestLine() {
        if (!this.isRequest()) {
            return null;
        }
        SipParser par = new SipParser(this.message);
        String method = par.getString();
        par.skipWSP();
        par = new SipParser(par.subParser(par.indexOfEOH() - par.getPos()));
        return new RequestLine(method, par.getSipURL());
    }

    public void setRequestLine(RequestLine rl) {
        if (this.hasRequestLine()) {
            this.removeRequestLine();
        }
        String value = rl.toString();
        this.message = String.valueOf(value) + this.message;
    }

    public void removeRequestLine() {
        if (!this.isRequest()) {
            return;
        }
        this.removeFirstLine();
    }

    public boolean isResponse() throws NullPointerException {
        String target;
        if (this.message == null || this.message.length() < 4) {
            return false;
        }
        String version = this.message.substring(0, 4);
        return version.equalsIgnoreCase(target = "SIP/");
    }

    protected boolean hasStatusLine() {
        return this.isResponse();
    }

    public StatusLine getStatusLine() {
        if (!this.isResponse()) {
            return null;
        }
        SipParser par = new SipParser(this.message);
        par.skipString().skipWSP();
        int code = par.getInt();
        int begin = par.getPos();
        int end = par.indexOfEOH();
        String reason = this.message.substring(begin, end).trim();
        return new StatusLine(code, reason);
    }

    public void setStatusLine(StatusLine sl) {
        if (this.hasStatusLine()) {
            this.removeStatusLine();
        }
        this.message = String.valueOf(sl.toString()) + this.message;
    }

    public void removeStatusLine() {
        if (!this.isResponse()) {
            return;
        }
        this.removeFirstLine();
    }

    public String getTransactionMethod() {
        return this.getCSeqHeader().getMethod();
    }

    public String getFirstLine() {
        if (this.isRequest()) {
            return this.getRequestLine().toString();
        }
        if (this.isResponse()) {
            return this.getStatusLine().toString();
        }
        return null;
    }

    protected void removeFirstLine() {
        this.message = this.message.substring(new SipParser(this.message).indexOfNextHeader());
    }

    public boolean hasHeader(String name) {
        Header hd = this.getHeader(name);
        return hd != null;
    }

    public Header getHeader(String hname) {
        SipParser par = new SipParser(this.message);
        return par.getHeader(hname);
    }

    public Vector getHeaders(String hname) {
        Header h;
        Vector<Header> v = new Vector<Header>();
        SipParser par = new SipParser(this.message);
        while ((h = par.getHeader(hname)) != null) {
            v.addElement(h);
        }
        return v;
    }

    public void addHeader(Header header, boolean top) {
        this.addHeaders(header.toString(), top);
    }

    public void addHeaders(Vector headers, boolean top) {
        String str = "";
        int i = 0;
        while (i < headers.size()) {
            str = String.valueOf(str) + ((Header)headers.elementAt(i)).toString();
            ++i;
        }
        this.addHeaders(str, top);
    }

    public void addHeaders(MultipleHeader mheader, boolean top) {
        this.addHeaders(mheader.toString(), top);
    }

    protected void addHeaders(String str, boolean top) {
        int i;
        SipParser par;
        if (top) {
            if (this.hasRequestLine() || this.hasStatusLine()) {
                par = new SipParser(this.message);
                par.goToNextHeader();
                i = par.getPos();
            } else {
                i = 0;
            }
        } else {
            par = new SipParser(this.message);
            i = par.goToEndOfLastHeader().goToNextLine().getPos();
            par = new SipParser(this.message);
            int aux = par.indexOfHeader("Content-Length");
            if (aux < i) {
                i = aux;
            }
            if ((aux = par.indexOfHeader("Content-Type")) < i) {
                i = aux;
            }
        }
        String head = this.message.substring(0, i);
        String tail = this.message.substring(i);
        String new_message = head.concat(str);
        this.message = new_message = new_message.concat(tail);
    }

    protected void addHeaders(String str, int index) {
        if (index > this.message.length()) {
            index = this.message.length();
        }
        this.message = String.valueOf(this.message.substring(0, index)) + str + this.message.substring(index);
    }

    public void addHeaderBefore(Header new_header, String refer_header) {
        this.addHeadersBefore(new_header.toString(), refer_header);
    }

    public void addHeadersBefore(MultipleHeader mheader, String refer_header) {
        this.addHeadersBefore(mheader.toString(), refer_header);
    }

    protected void addHeadersBefore(String str, String refer_header) {
        if (!this.hasHeader(refer_header)) {
            this.addHeaders(str, true);
        } else {
            SipParser par = new SipParser(this.message);
            par.goTo(refer_header);
            int here = par.getPos();
            this.message = String.valueOf(this.message.substring(0, here)) + str + this.message.substring(here);
        }
    }

    public void addHeaderAfter(Header new_header, String refer_header) {
        this.addHeadersAfter(new_header.toString(), refer_header);
    }

    public void addHeadersAfter(MultipleHeader mheader, String refer_header) {
        this.addHeadersAfter(mheader.toString(), refer_header);
    }

    protected void addHeadersAfter(String str, String refer_header) {
        if (!this.hasHeader(refer_header)) {
            this.addHeaders(str, false);
        } else {
            SipParser par = new SipParser(this.message);
            par.goTo(refer_header);
            int here = par.indexOfNextHeader();
            this.message = String.valueOf(this.message.substring(0, here)) + str + this.message.substring(here);
        }
    }

    public void removeHeader(String hname) {
        this.removeHeader(hname, true);
    }

    public void removeHeader(String hname, boolean first) {
        String[] target = new String[]{String.valueOf('\n') + hname, String.valueOf('\r') + hname};
        SipParser par = new SipParser(this.message);
        par.goTo(target);
        if (!par.hasMore()) {
            return;
        }
        if (!first) {
            int next;
            while ((next = par.indexOf(target)) >= 0) {
                par.setPos(next);
            }
        }
        par.skipChar();
        String head = this.message.substring(0, par.getPos());
        par.goToNextHeader();
        String tail = this.message.substring(par.getPos());
        this.message = head.concat(tail);
    }

    public void setHeader(Header hd) {
        String hname = hd.getName();
        if (this.hasHeader(hname)) {
            int index = new SipParser(this.message).indexOfHeader(hname);
            this.removeAllHeaders(hname);
            this.addHeaders(hd.toString(), index);
        } else {
            this.addHeader(hd, false);
        }
    }

    public void removeAllHeaders(String hname) {
        String[] target = new String[]{String.valueOf('\n') + hname, String.valueOf('\r') + hname};
        SipParser par = new SipParser(this.message);
        par.goTo(target);
        while (par.hasMore()) {
            par.skipChar();
            String head = this.message.substring(0, par.getPos());
            String tail = this.message.substring(par.indexOfNextHeader());
            this.message = head.concat(tail);
            par = new SipParser(this.message, par.getPos() - 1);
            par.goTo(target);
        }
    }

    public void setHeaders(MultipleHeader mheader) {
        String hname = mheader.getName();
        if (this.hasHeader(hname)) {
            int index = new SipParser(this.message).indexOfHeader(hname);
            this.removeAllHeaders(hname);
            this.addHeaders(mheader.toString(), index);
        } else {
            this.addHeaders(mheader, false);
        }
    }

    public boolean hasMaxForwardsHeader() {
        return this.hasHeader("Max-Forwards");
    }

    public MaxForwardsHeader getMaxForwardsHeader() {
        Header h = this.getHeader("Max-Forwards");
        if (h == null) {
            return null;
        }
        return new MaxForwardsHeader(h);
    }

    public void setMaxForwardsHeader(MaxForwardsHeader mfh) {
        this.setHeader(mfh);
    }

    public void removeMaxForwardsHeader() {
        this.removeHeader("Max-Forwards");
    }

    public boolean hasFromHeader() {
        return this.hasHeader("From");
    }

    public FromHeader getFromHeader() {
        Header h = this.getHeader("From");
        if (h == null) {
            return null;
        }
        return new FromHeader(h);
    }

    public void setFromHeader(FromHeader fh) {
        this.setHeader(fh);
    }

    public void removeFromHeader() {
        this.removeHeader("From");
    }

    public boolean hasToHeader() {
        return this.hasHeader("To");
    }

    public ToHeader getToHeader() {
        Header h = this.getHeader("To");
        if (h == null) {
            return null;
        }
        return new ToHeader(h);
    }

    public void setToHeader(ToHeader th) {
        this.setHeader(th);
    }

    public void removeToHeader() {
        this.removeHeader("To");
    }

    public boolean hasContactHeader() {
        return this.hasHeader("Contact");
    }

    public ContactHeader getContactHeader() {
        MultipleHeader mh = this.getContacts();
        if (mh == null) {
            return null;
        }
        return new ContactHeader(mh.getTop());
    }

    public void addContactHeader(ContactHeader ch, boolean top) {
        this.addHeader(ch, top);
    }

    public void setContactHeader(ContactHeader ch) {
        if (this.hasContactHeader()) {
            this.removeContacts();
        }
        this.addHeader(ch, false);
    }

    public MultipleHeader getContacts() {
        Vector v = this.getHeaders("Contact");
        if (v.size() > 0) {
            return new MultipleHeader(v);
        }
        return null;
    }

    public void addContacts(MultipleHeader contacts, boolean top) {
        this.addHeaders(contacts, top);
    }

    public void setContacts(MultipleHeader contacts) {
        if (this.hasContactHeader()) {
            this.removeContacts();
        }
        this.addContacts(contacts, false);
    }

    public void removeContacts() {
        this.removeAllHeaders("Contact");
    }

    public boolean hasViaHeader() {
        return this.hasHeader("Via");
    }

    public void addViaHeader(ViaHeader vh) {
        this.addHeader(vh, true);
    }

    public ViaHeader getViaHeader() {
        MultipleHeader mh = this.getVias();
        if (mh == null) {
            return null;
        }
        return new ViaHeader(mh.getTop());
    }

    public void removeViaHeader() {
        MultipleHeader mh = this.getVias();
        mh.removeTop();
        this.setVias(mh);
    }

    public MultipleHeader getVias() {
        Vector v = this.getHeaders("Via");
        if (v.size() > 0) {
            return new MultipleHeader(v);
        }
        return null;
    }

    public void addVias(MultipleHeader vias, boolean top) {
        this.addHeaders(vias, top);
    }

    public void setVias(MultipleHeader vias) {
        if (this.hasViaHeader()) {
            this.removeVias();
        }
        this.addContacts(vias, true);
    }

    public void removeVias() {
        this.removeAllHeaders("Via");
    }

    public boolean hasRouteHeader() {
        return this.hasHeader("Route");
    }

    public void addRouteHeader(RouteHeader h) {
        this.addHeaderAfter(h, "Via");
    }

    public void addRoutes(MultipleHeader routes) {
        this.addHeadersAfter(routes, "Via");
    }

    public RouteHeader getRouteHeader() {
        MultipleHeader mh = this.getRoutes();
        if (mh == null) {
            return null;
        }
        return new RouteHeader(mh.getTop());
    }

    public MultipleHeader getRoutes() {
        Vector v = this.getHeaders("Route");
        if (v.size() > 0) {
            return new MultipleHeader(v);
        }
        return null;
    }

    public void removeRouteHeader() {
        MultipleHeader mh = this.getRoutes();
        mh.removeTop();
        this.setRoutes(mh);
    }

    public void removeRoutes() {
        this.removeAllHeaders("Route");
    }

    public void setRoutes(MultipleHeader routes) {
        if (this.hasRouteHeader()) {
            this.removeRoutes();
        }
        this.addRoutes(routes);
    }

    public boolean hasRecordRouteHeader() {
        return this.hasHeader("Record-Route");
    }

    public void addRecordRouteHeader(RecordRouteHeader rr) {
        this.addHeaderAfter(rr, "CSeq");
    }

    public void addRecordRoutes(MultipleHeader routes) {
        this.addHeadersAfter(routes, "CSeq");
    }

    public RecordRouteHeader getRecordRouteHeader() {
        MultipleHeader mh = this.getRecordRoutes();
        if (mh == null) {
            return null;
        }
        return new RecordRouteHeader(mh.getTop());
    }

    public MultipleHeader getRecordRoutes() {
        Vector v = this.getHeaders("Record-Route");
        if (v.size() > 0) {
            return new MultipleHeader(v);
        }
        return null;
    }

    public void removeRecordRouteHeader() {
        MultipleHeader mh = this.getRecordRoutes();
        mh.removeTop();
        this.setRecordRoutes(mh);
    }

    public void removeRecordRoutes() {
        this.removeAllHeaders("Record-Route");
    }

    public void setRecordRoutes(MultipleHeader routes) {
        if (this.hasRecordRouteHeader()) {
            this.removeRecordRoutes();
        }
        this.addRecordRoutes(routes);
    }

    public boolean hasCSeqHeader() {
        return this.hasHeader("CSeq");
    }

    public CSeqHeader getCSeqHeader() {
        Header h = this.getHeader("CSeq");
        if (h == null) {
            return null;
        }
        return new CSeqHeader(h);
    }

    public void setCSeqHeader(CSeqHeader csh) {
        this.setHeader(csh);
    }

    public void removeCSeqHeader() {
        this.removeHeader("CSeq");
    }

    public boolean hasCallIdHeader() {
        return this.hasHeader("Call-ID");
    }

    public void setCallIdHeader(CallIdHeader cih) {
        this.setHeader(cih);
    }

    public CallIdHeader getCallIdHeader() {
        Header h = this.getHeader("Call-ID");
        if (h == null) {
            return null;
        }
        return new CallIdHeader(h);
    }

    public void removeCallIdHeader() {
        this.removeHeader("Call-ID");
    }

    public boolean hasSubjectHeader() {
        return this.hasHeader("Subject");
    }

    public void setSubjectHeader(SubjectHeader sh) {
        this.setHeader(sh);
    }

    public SubjectHeader getSubjectHeader() {
        Header h = this.getHeader("Subject");
        if (h == null) {
            return null;
        }
        return new SubjectHeader(h);
    }

    public void removeSubjectHeader() {
        this.removeHeader("Subject");
    }

    public boolean hasDateHeader() {
        return this.hasHeader("Date");
    }

    public DateHeader getDateHeader() {
        Header h = this.getHeader("Date");
        if (h == null) {
            return null;
        }
        return new DateHeader(h);
    }

    public void setDateHeader(DateHeader dh) {
        this.setHeader(dh);
    }

    public void removeDateHeader() {
        this.removeHeader("Date");
    }

    public boolean hasUserAgentHeader() {
        return this.hasHeader("User-Agent");
    }

    public void setUserAgentHeader(UserAgentHeader h) {
        this.setHeader(h);
    }

    public UserAgentHeader getUserAgentHeader() {
        Header h = this.getHeader("User-Agent");
        if (h == null) {
            return null;
        }
        return new UserAgentHeader(h);
    }

    public void removeUserAgentHeader() {
        this.removeHeader("User-Agent");
    }

    public boolean hasServerHeader() {
        return this.hasHeader("Server");
    }

    public void setServerHeader(ServerHeader h) {
        this.setHeader(h);
    }

    public ServerHeader getServerHeader() {
        Header h = this.getHeader("Server");
        if (h == null) {
            return null;
        }
        return new ServerHeader(h);
    }

    public void removeServerHeader() {
        this.removeHeader("Server");
    }

    public boolean hasAcceptHeader() {
        return this.hasHeader("Accept");
    }

    public void setAcceptHeader(AcceptHeader h) {
        this.setHeader(h);
    }

    public AcceptHeader getAcceptHeader() {
        Header h = this.getHeader("Accept");
        if (h == null) {
            return null;
        }
        return new AcceptHeader(h);
    }

    public void removeAcceptHeader() {
        this.removeHeader("Accept");
    }

    public boolean hasAlertInfoHeader() {
        return this.hasHeader("Alert-Info");
    }

    public void setAlertInfoHeader(AlertInfoHeader h) {
        this.setHeader(h);
    }

    public AlertInfoHeader getAlertInfoHeader() {
        Header h = this.getHeader("Alert-Info");
        if (h == null) {
            return null;
        }
        return new AlertInfoHeader(h);
    }

    public void removeAlertInfoHeader() {
        this.removeHeader("Alert-Info");
    }

    public boolean hasAllowHeader() {
        return this.hasHeader("Allow");
    }

    public void setAllowHeader(AllowHeader h) {
        this.setHeader(h);
    }

    public AllowHeader getAllowHeader() {
        Header h = this.getHeader("Allow");
        if (h == null) {
            return null;
        }
        return new AllowHeader(h);
    }

    public void removeAllowHeader() {
        this.removeHeader("Allow");
    }

    public boolean hasExpiresHeader() {
        return this.hasHeader("Expires");
    }

    public ExpiresHeader getExpiresHeader() {
        Header h = this.getHeader("Expires");
        if (h == null) {
            return null;
        }
        return new ExpiresHeader(h);
    }

    public void setExpiresHeader(ExpiresHeader eh) {
        this.setHeader(eh);
    }

    public void removeExpiresHeader() {
        this.removeHeader("Expires");
    }

    public boolean hasContentTypeHeader() {
        return this.hasHeader("Content-Type");
    }

    public ContentTypeHeader getContentTypeHeader() {
        Header h = this.getHeader("Content-Type");
        if (h == null) {
            return null;
        }
        return new ContentTypeHeader(h);
    }

    protected void setContentTypeHeader(ContentTypeHeader cth) {
        this.setHeader(cth);
    }

    protected void removeContentTypeHeader() {
        this.removeHeader("Content-Type");
    }

    public boolean hasContentLengthHeader() {
        return this.hasHeader("Content-Length");
    }

    public ContentLengthHeader getContentLengthHeader() {
        Header h = this.getHeader("Content-Length");
        if (h == null) {
            return null;
        }
        return new ContentLengthHeader(h);
    }

    protected void setContentLengthHeader(ContentLengthHeader clh) {
        this.setHeader(clh);
    }

    protected void removeContentLengthHeader() {
        this.removeHeader("Content-Length");
    }

    public boolean hasBody() {
        if (this.hasContentLengthHeader()) {
            return this.getContentLengthHeader().getContentLength() > 0;
        }
        return this.hasContentTypeHeader();
    }

    public String getBodyType() {
        return this.getContentTypeHeader().getContentType();
    }

    public void setBody(String content_type, String body) {
        this.removeBody();
        if (body != null && body.length() > 0) {
            this.setContentTypeHeader(new ContentTypeHeader(content_type));
            this.setContentLengthHeader(new ContentLengthHeader(body.length()));
            this.message = String.valueOf(this.message) + "\r\n" + body;
        } else {
            this.setContentLengthHeader(new ContentLengthHeader(0));
            this.message = String.valueOf(this.message) + "\r\n";
        }
    }

    public void setBody(String body) {
        this.setBody("application/sdp", body);
    }

    public String getBody() {
        int len;
        if (!this.hasBody()) {
            return null;
        }
        int begin = new SipParser(this.message).goToBody().getPos();
        int end = begin + (len = this.hasContentLengthHeader() ? this.getContentLengthHeader().getContentLength() : this.message.length() - begin);
        if (end > this.message.length()) {
            end = this.message.length();
        }
        return this.message.substring(begin, end);
    }

    public void removeBody() {
        int pos = new SipParser(this.message).goToEndOfLastHeader().goToNextLine().getPos();
        this.message = this.message.substring(0, pos);
        this.removeContentLengthHeader();
        this.removeContentTypeHeader();
    }

    public boolean hasAuthenticationInfoHeader() {
        return this.hasHeader("Authentication-Info");
    }

    public void setAuthenticationInfoHeader(AuthenticationInfoHeader h) {
        this.setHeader(h);
    }

    public AuthenticationInfoHeader getAuthenticationInfoHeader() {
        Header h = this.getHeader("Authentication-Info");
        if (h == null) {
            return null;
        }
        return new AuthenticationInfoHeader(h);
    }

    public void removeAuthenticationInfoHeader() {
        this.removeHeader("Authentication-Info");
    }

    public boolean hasAuthorizationHeader() {
        return this.hasHeader("Authorization");
    }

    public void setAuthorizationHeader(AuthorizationHeader h) {
        this.setHeader(h);
    }

    public AuthorizationHeader getAuthorizationHeader() {
        Header h = this.getHeader("Authorization");
        if (h == null) {
            return null;
        }
        return new AuthorizationHeader(h);
    }

    public void removeAuthorizationHeader() {
        this.removeHeader("Authorization");
    }

    public boolean hasWwwAuthenticateHeader() {
        return this.hasHeader("WWW-Authenticate");
    }

    public void setWwwAuthenticateHeader(WwwAuthenticateHeader h) {
        this.setHeader(h);
    }

    public WwwAuthenticateHeader getWwwAuthenticateHeader() {
        Header h = this.getHeader("WWW-Authenticate");
        if (h == null) {
            return null;
        }
        return new WwwAuthenticateHeader(h);
    }

    public void removeWwwAuthenticateHeader() {
        this.removeHeader("WWW-Authenticate");
    }

    public boolean hasProxyAuthenticateHeader() {
        return this.hasHeader("Proxy-Authenticate");
    }

    public void setProxyAuthenticateHeader(ProxyAuthenticateHeader h) {
        this.setHeader(h);
    }

    public ProxyAuthenticateHeader getProxyAuthenticateHeader() {
        Header h = this.getHeader("Proxy-Authenticate");
        if (h == null) {
            return null;
        }
        return new ProxyAuthenticateHeader(h);
    }

    public void removeProxyAuthenticateHeader() {
        this.removeHeader("Proxy-Authenticate");
    }

    public boolean hasProxyAuthorizationHeader() {
        return this.hasHeader("Proxy-Authorization");
    }

    public void setProxyAuthorizationHeader(ProxyAuthorizationHeader h) {
        this.setHeader(h);
    }

    public ProxyAuthorizationHeader getProxyAuthorizationHeader() {
        Header h = this.getHeader("Proxy-Authorization");
        if (h == null) {
            return null;
        }
        return new ProxyAuthorizationHeader(h);
    }

    public void removeProxyAuthorizationHeader() {
        this.removeHeader("Proxy-Authorization");
    }

    public void rfc2543RouteAdapt() {
        if (this.hasRouteHeader()) {
            MultipleHeader mrh = this.getRoutes();
            RouteHeader rh = new RouteHeader(mrh.getTop());
            if (!new RouteHeader(mrh.getTop()).getNameAddress().getAddress().hasLr()) {
                SipURL next_hop = new RouteHeader(mrh.getTop()).getNameAddress().getAddress();
                SipURL recipient = this.getRequestLine().getAddress();
                mrh.removeTop();
                mrh.addBottom(new RouteHeader(new NameAddress(recipient)));
                this.setRoutes(mrh);
                this.setRequestLine(new RequestLine(this.getRequestLine().getMethod(), next_hop));
            }
        }
    }

    public void rfc2543toRfc3261RouteUpdate() {
        RequestLine request_line = this.getRequestLine();
        SipURL next_hop = request_line.getAddress();
        MultipleHeader mrh = this.getRoutes();
        SipURL target = new RouteHeader(mrh.getBottom()).getNameAddress().getAddress();
        mrh.removeBottom();
        next_hop.addLr();
        mrh.addTop(new RouteHeader(new NameAddress(next_hop)));
        this.removeRoutes();
        this.addRoutes(mrh);
        this.setRequestLine(new RequestLine(request_line.getMethod(), target));
    }
}

