/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.message;

import java.util.Vector;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.dialog.Dialog;
import org.zoolu.sip.header.CSeqHeader;
import org.zoolu.sip.header.CallIdHeader;
import org.zoolu.sip.header.ContactHeader;
import org.zoolu.sip.header.ExpiresHeader;
import org.zoolu.sip.header.FromHeader;
import org.zoolu.sip.header.MaxForwardsHeader;
import org.zoolu.sip.header.MultipleHeader;
import org.zoolu.sip.header.RequestLine;
import org.zoolu.sip.header.ServerHeader;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.header.ToHeader;
import org.zoolu.sip.header.UserAgentHeader;
import org.zoolu.sip.header.ViaHeader;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.SipMethods;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;

public abstract class BaseMessageFactory {
    public static Message createRequest(String method, SipURL request_uri, NameAddress to, NameAddress from, NameAddress contact, String proto, String via_addr, int host_port, boolean rport, String call_id, long cseq, String local_tag, String remote_tag, String branch, String body) {
        Message req = new Message();
        req.setRequestLine(new RequestLine(method, request_uri));
        ViaHeader via = new ViaHeader(proto, via_addr, host_port);
        if (rport) {
            via.setRport();
        }
        if (branch == null) {
            branch = SipProvider.pickBranch();
        }
        via.setBranch(branch);
        req.addViaHeader(via);
        req.setMaxForwardsHeader(new MaxForwardsHeader(70));
        if (remote_tag == null) {
            req.setToHeader(new ToHeader(to));
        } else {
            req.setToHeader(new ToHeader(to, remote_tag));
        }
        req.setFromHeader(new FromHeader(from, local_tag));
        req.setCallIdHeader(new CallIdHeader(call_id));
        req.setCSeqHeader(new CSeqHeader(cseq, method));
        if (contact != null) {
            MultipleHeader contacts = new MultipleHeader("Contact");
            contacts.addBottom(new ContactHeader(contact));
            req.setContacts(contacts);
        }
        req.setExpiresHeader(new ExpiresHeader(String.valueOf(SipStack.default_expires)));
        if (SipStack.ua_info != null) {
            req.setUserAgentHeader(new UserAgentHeader(SipStack.ua_info));
        }
        req.setBody(body);
        return req;
    }

    public static Message createRequest(SipProvider sip_provider, String method, SipURL request_uri, NameAddress to, NameAddress from, NameAddress contact, String call_id, long cseq, String local_tag, String remote_tag, String branch, String body) {
        String via_addr = sip_provider.getViaAddress();
        int host_port = sip_provider.getPort();
        boolean rport = sip_provider.isRportSet();
        String proto = request_uri.hasTransport() ? request_uri.getTransport() : sip_provider.getDefaultTransport();
        return BaseMessageFactory.createRequest(method, request_uri, to, from, contact, proto, via_addr, host_port, rport, call_id, cseq, local_tag, remote_tag, branch, body);
    }

    public static Message createRequest(SipProvider sip_provider, String method, SipURL request_uri, NameAddress to, NameAddress from, NameAddress contact, String body) {
        String call_id = sip_provider.pickCallId();
        int cseq = SipProvider.pickInitialCSeq();
        String local_tag = SipProvider.pickTag();
        return BaseMessageFactory.createRequest(sip_provider, method, request_uri, to, from, contact, call_id, cseq, local_tag, null, null, body);
    }

    public static Message createRequest(SipProvider sip_provider, String method, NameAddress to, NameAddress from, String body) {
        String contact_user = from.getAddress().getUserName();
        NameAddress contact = new NameAddress(new SipURL(contact_user, sip_provider.getViaAddress(), sip_provider.getPort()));
        return BaseMessageFactory.createRequest(sip_provider, method, to.getAddress(), to, from, contact, body);
    }

    public static Message createRequest(Dialog dialog, String method, String body) {
        SipURL request_uri;
        NameAddress to = dialog.getRemoteName();
        NameAddress from = dialog.getLocalName();
        NameAddress target = dialog.getRemoteContact();
        if (target == null) {
            target = to;
        }
        if ((request_uri = target.getAddress()) == null) {
            request_uri = dialog.getRemoteName().getAddress();
        }
        SipProvider sip_provider = dialog.getSipProvider();
        String via_addr = sip_provider.getViaAddress();
        int host_port = sip_provider.getPort();
        boolean rport = sip_provider.isRportSet();
        String proto = target.getAddress().hasTransport() ? target.getAddress().getTransport() : sip_provider.getDefaultTransport();
        NameAddress contact = dialog.getLocalContact();
        if (contact == null) {
            contact = from;
        }
        if (!SipMethods.isAck(method) && !SipMethods.isCancel(method)) {
            dialog.incLocalCSeq();
        }
        String call_id = dialog.getCallID();
        long cseq = dialog.getLocalCSeq();
        String local_tag = dialog.getLocalTag();
        String remote_tag = dialog.getRemoteTag();
        Message req = BaseMessageFactory.createRequest(method, request_uri, to, from, contact, proto, via_addr, host_port, rport, call_id, cseq, local_tag, remote_tag, null, body);
        Vector route = dialog.getRoute();
        if (route != null && route.size() > 0) {
            req.addRoutes(new MultipleHeader("Route", route));
        }
        req.rfc2543RouteAdapt();
        return req;
    }

    public static Message createInviteRequest(SipProvider sip_provider, SipURL request_uri, NameAddress to, NameAddress from, NameAddress contact, String body) {
        String call_id = sip_provider.pickCallId();
        int cseq = SipProvider.pickInitialCSeq();
        String local_tag = SipProvider.pickTag();
        if (contact == null) {
            contact = from;
        }
        return BaseMessageFactory.createRequest(sip_provider, "INVITE", request_uri, to, from, contact, call_id, cseq, local_tag, null, null, body);
    }

    public static Message createInviteRequest(Dialog dialog, String body) {
        return BaseMessageFactory.createRequest(dialog, "INVITE", body);
    }

    public static Message create2xxAckRequest(Dialog dialog, String body) {
        return BaseMessageFactory.createRequest(dialog, "ACK", body);
    }

    public static Message createNon2xxAckRequest(SipProvider sip_provider, Message method, Message resp) {
        SipURL request_uri = method.getRequestLine().getAddress();
        FromHeader from = method.getFromHeader();
        ToHeader to = resp.getToHeader();
        String via_addr = sip_provider.getViaAddress();
        int host_port = sip_provider.getPort();
        boolean rport = sip_provider.isRportSet();
        String proto = request_uri.hasTransport() ? request_uri.getTransport() : sip_provider.getDefaultTransport();
        String branch = method.getViaHeader().getBranch();
        NameAddress contact = null;
        Message ack = BaseMessageFactory.createRequest("ACK", request_uri, to.getNameAddress(), from.getNameAddress(), contact, proto, via_addr, host_port, rport, method.getCallIdHeader().getCallId(), method.getCSeqHeader().getSequenceNumber(), from.getParameter("tag"), to.getParameter("tag"), branch, null);
        ack.removeExpiresHeader();
        if (method.hasRouteHeader()) {
            ack.setRoutes(method.getRoutes());
        }
        return ack;
    }

    public static Message createCancelRequest(Message method) {
        ToHeader to = method.getToHeader();
        FromHeader from = method.getFromHeader();
        SipURL request_uri = method.getRequestLine().getAddress();
        NameAddress contact = method.getContactHeader().getNameAddress();
        ViaHeader via = method.getViaHeader();
        String host_addr = via.getHost();
        int host_port = via.getPort();
        boolean rport = via.hasRport();
        String proto = via.getProtocol();
        String branch = method.getViaHeader().getBranch();
        return BaseMessageFactory.createRequest("CANCEL", request_uri, to.getNameAddress(), from.getNameAddress(), contact, proto, host_addr, host_port, rport, method.getCallIdHeader().getCallId(), method.getCSeqHeader().getSequenceNumber(), from.getParameter("tag"), to.getParameter("tag"), branch, "");
    }

    public static Message createByeRequest(Dialog dialog) {
        Message msg = BaseMessageFactory.createRequest(dialog, "BYE", null);
        msg.removeExpiresHeader();
        msg.removeContacts();
        return msg;
    }

    public static Message createRegisterRequest(SipProvider sip_provider, NameAddress to, NameAddress from, NameAddress contact) {
        SipURL to_url = to.getAddress();
        SipURL registrar = new SipURL(to_url.getHost(), to_url.getPort());
        String via_addr = sip_provider.getViaAddress();
        int host_port = sip_provider.getPort();
        boolean rport = sip_provider.isRportSet();
        String proto = to_url.hasTransport() ? to_url.getTransport() : sip_provider.getDefaultTransport();
        String call_id = sip_provider.pickCallId();
        int cseq = SipProvider.pickInitialCSeq();
        String local_tag = SipProvider.pickTag();
        Message req = BaseMessageFactory.createRequest("REGISTER", registrar, to, from, contact, proto, via_addr, host_port, rport, call_id, cseq, local_tag, null, null, null);
        if (contact == null) {
            ContactHeader star = new ContactHeader();
            req.setContactHeader(star);
            req.setExpiresHeader(new ExpiresHeader(String.valueOf(SipStack.default_expires)));
        }
        return req;
    }

    public static Message createResponse(Message req, int code, String reason, String local_tag, NameAddress contact, String content_type, String body) {
        Message resp = new Message();
        resp.setStatusLine(new StatusLine(code, reason));
        resp.setVias(req.getVias());
        if (code >= 180 && code < 300 && req.hasRecordRouteHeader()) {
            resp.setRecordRoutes(req.getRecordRoutes());
        }
        ToHeader toh = req.getToHeader();
        if (local_tag != null) {
            toh.setParameter("tag", local_tag);
        }
        resp.setToHeader(toh);
        resp.setFromHeader(req.getFromHeader());
        resp.setCallIdHeader(req.getCallIdHeader());
        resp.setCSeqHeader(req.getCSeqHeader());
        if (contact != null) {
            resp.setContactHeader(new ContactHeader(contact));
        }
        if (SipStack.server_info != null) {
            resp.setServerHeader(new ServerHeader(SipStack.server_info));
        }
        if (content_type == null) {
            resp.setBody(body);
        } else {
            resp.setBody(content_type, body);
        }
        return resp;
    }

    public static Message createResponse(Message req, int code, String reason, NameAddress contact) {
        String localtag = null;
        if (req.createsDialog() && !req.getToHeader().hasTag() && (SipStack.early_dialog || code >= 200 && code < 300)) {
            localtag = SipProvider.pickTag(req);
        }
        return BaseMessageFactory.createResponse(req, code, reason, localtag, contact, null, null);
    }
}

