/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.message;

import java.util.Vector;
import org.zoolu.net.UdpPacket;
import org.zoolu.sip.header.ContentLengthHeader;
import org.zoolu.sip.header.ContentTypeHeader;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.MultipleHeader;
import org.zoolu.sip.header.RequestLine;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.message.BaseMessage;
import org.zoolu.sip.provider.SipParser;

public abstract class BaseMessageOtp
extends BaseMessage {
    protected RequestLine request_line;
    protected StatusLine status_line;
    protected Vector headers;
    protected String body;

    private void init() {
        this.request_line = null;
        this.status_line = null;
        this.headers = null;
        this.body = null;
    }

    public BaseMessageOtp() {
        this.init();
        this.headers = new Vector();
    }

    public BaseMessageOtp(byte[] data, int offset, int len) {
        this.init();
        this.parseIt(new String(data, offset, len));
    }

    public BaseMessageOtp(UdpPacket packet) {
        this.init();
        this.parseIt(new String(packet.getData(), packet.getOffset(), packet.getLength()));
    }

    public BaseMessageOtp(String str) {
        this.init();
        this.parseIt(str);
    }

    public BaseMessageOtp(BaseMessageOtp msg) {
        this.init();
        this.remote_addr = msg.remote_addr;
        this.remote_port = msg.remote_port;
        this.transport_proto = msg.transport_proto;
        this.connection_id = msg.connection_id;
        this.request_line = msg.request_line;
        this.status_line = msg.status_line;
        this.headers = new Vector();
        int i = 0;
        while (i < msg.headers.size()) {
            this.headers.addElement(msg.headers.elementAt(i));
            ++i;
        }
        this.body = msg.body;
    }

    public void setMessage(String str) {
        this.parseIt(str);
    }

    private void parseIt(String str) {
        SipParser par = new SipParser(str);
        String version = str.substring(0, 4);
        if (version.equalsIgnoreCase("SIP/")) {
            this.status_line = par.getStatusLine();
        } else {
            this.request_line = par.getRequestLine();
        }
        this.headers = new Vector();
        Header h = par.getHeader();
        while (h != null) {
            this.headers.addElement(h);
            h = par.getHeader();
        }
        ContentLengthHeader clh = this.getContentLengthHeader();
        if (clh != null) {
            int len = clh.getContentLength();
            this.body = par.getString(len);
        } else if (this.getContentTypeHeader() != null) {
            this.body = par.getRemainingString();
            if (this.body.length() == 0) {
                this.body = null;
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.request_line != null) {
            str.append(this.request_line.toString());
        } else if (this.status_line != null) {
            str.append(this.status_line.toString());
        }
        int i = 0;
        while (i < this.headers.size()) {
            str.append(((Header)this.headers.elementAt(i)).toString());
            ++i;
        }
        str.append("\r\n");
        if (this.body != null) {
            str.append(this.body);
        }
        return str.toString();
    }

    public int getLength() {
        return this.toString().length();
    }

    public boolean isRequest() {
        return this.request_line != null;
    }

    public boolean isRequest(String method) {
        return this.request_line != null && this.request_line.getMethod().equalsIgnoreCase(method);
    }

    protected boolean hasRequestLine() {
        return this.request_line != null;
    }

    public RequestLine getRequestLine() {
        return this.request_line;
    }

    public void setRequestLine(RequestLine rl) {
        this.request_line = rl;
    }

    public void removeRequestLine() {
        this.request_line = null;
    }

    public boolean isResponse() throws NullPointerException {
        return this.status_line != null;
    }

    protected boolean hasStatusLine() {
        return this.status_line != null;
    }

    public StatusLine getStatusLine() {
        return this.status_line;
    }

    public void setStatusLine(StatusLine sl) {
        this.status_line = sl;
    }

    public void removeStatusLine() {
        this.status_line = null;
    }

    protected void removeFirstLine() {
        this.removeRequestLine();
        this.removeStatusLine();
    }

    protected int indexOfHeader(String hname) {
        int i = 0;
        while (i < this.headers.size()) {
            Header h = (Header)this.headers.elementAt(i);
            if (hname.equalsIgnoreCase(h.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Header getHeader(String hname) {
        int i = this.indexOfHeader(hname);
        if (i < 0) {
            return null;
        }
        return (Header)this.headers.elementAt(i);
    }

    public Vector getHeaders(String hname) {
        Vector<Header> v = new Vector<Header>();
        int i = 0;
        while (i < this.headers.size()) {
            Header h = (Header)this.headers.elementAt(i);
            if (hname.equalsIgnoreCase(h.getName())) {
                v.addElement(h);
            }
            ++i;
        }
        return v;
    }

    public void addHeader(Header header, boolean top) {
        if (top) {
            this.headers.insertElementAt(header, 0);
        } else {
            this.headers.addElement(header);
        }
    }

    public void addHeaders(Vector headers, boolean top) {
        int i = 0;
        while (i < headers.size()) {
            if (top) {
                this.headers.insertElementAt(headers.elementAt(i), i);
            } else {
                this.headers.addElement(headers.elementAt(i));
            }
            ++i;
        }
    }

    public void addHeaders(MultipleHeader mheader, boolean top) {
        if (mheader.isCommaSeparated()) {
            this.addHeader(mheader.toHeader(), top);
        } else {
            this.addHeaders(mheader.getHeaders(), top);
        }
    }

    public void addHeaderBefore(Header new_header, String refer_hname) {
        int i = this.indexOfHeader(refer_hname);
        if (i < 0) {
            i = 0;
        }
        this.headers.insertElementAt(new_header, i);
    }

    public void addHeadersBefore(MultipleHeader mheader, String refer_hname) {
        if (mheader.isCommaSeparated()) {
            this.addHeaderBefore(mheader.toHeader(), refer_hname);
        } else {
            int index = this.indexOfHeader(refer_hname);
            if (index < 0) {
                index = 0;
            }
            Vector hs = mheader.getHeaders();
            int k = 0;
            while (k < hs.size()) {
                this.headers.insertElementAt(hs.elementAt(k), index + k);
                ++k;
            }
        }
    }

    public void addHeaderAfter(Header new_header, String refer_hname) {
        int i = this.indexOfHeader(refer_hname);
        i = i >= 0 ? ++i : this.headers.size();
        this.headers.insertElementAt(new_header, i);
    }

    public void addHeadersAfter(MultipleHeader mheader, String refer_hname) {
        if (mheader.isCommaSeparated()) {
            this.addHeaderAfter(mheader.toHeader(), refer_hname);
        } else {
            int index = this.indexOfHeader(refer_hname);
            index = index >= 0 ? ++index : this.headers.size();
            Vector hs = mheader.getHeaders();
            int k = 0;
            while (k < hs.size()) {
                this.headers.insertElementAt(hs.elementAt(k), index + k);
                ++k;
            }
        }
    }

    public void removeHeader(String hname) {
        this.removeHeader(hname, true);
    }

    public void removeHeader(String hname, boolean first) {
        int index = -1;
        int i = 0;
        while (i < this.headers.size()) {
            Header h = (Header)this.headers.elementAt(i);
            if (hname.equalsIgnoreCase(h.getName())) {
                index = i;
                if (first) {
                    i = this.headers.size();
                }
            }
            ++i;
        }
        if (index >= 0) {
            this.headers.removeElementAt(index);
        }
    }

    public void removeAllHeaders(String hname) {
        int i = 0;
        while (i < this.headers.size()) {
            Header h = (Header)this.headers.elementAt(i);
            if (hname.equalsIgnoreCase(h.getName())) {
                this.headers.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public void setHeader(Header hd) {
        boolean first = true;
        String hname = hd.getName();
        int i = 0;
        while (i < this.headers.size()) {
            Header h = (Header)this.headers.elementAt(i);
            if (hname.equalsIgnoreCase(h.getName())) {
                if (first) {
                    this.headers.setElementAt(h, i);
                    first = false;
                } else {
                    this.headers.removeElementAt(i);
                    --i;
                }
            }
            ++i;
        }
        if (first) {
            this.headers.addElement(hd);
        }
    }

    public void setHeaders(MultipleHeader mheader) {
        if (mheader.isCommaSeparated()) {
            this.setHeader(mheader.toHeader());
        } else {
            boolean first = true;
            String hname = mheader.getName();
            int i = 0;
            while (i < this.headers.size()) {
                Header h = (Header)this.headers.elementAt(i);
                if (hname.equalsIgnoreCase(h.getName())) {
                    if (first) {
                        Vector hs = mheader.getHeaders();
                        int k = 0;
                        while (k < hs.size()) {
                            this.headers.insertElementAt(hs.elementAt(k), i + k);
                            ++k;
                        }
                        first = false;
                        i += hs.size() - 1;
                    } else {
                        this.headers.removeElementAt(i);
                        --i;
                    }
                }
                ++i;
            }
        }
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String getBodyType() {
        return this.getContentTypeHeader().getContentType();
    }

    public void setBody(String content_type, String body) {
        this.removeBody();
        if (body != null && body.length() > 0) {
            this.setContentTypeHeader(new ContentTypeHeader(content_type));
            this.setContentLengthHeader(new ContentLengthHeader(body.length()));
            this.body = body;
        } else {
            this.setContentLengthHeader(new ContentLengthHeader(0));
            this.body = null;
        }
    }

    public String getBody() {
        return this.body;
    }

    public void removeBody() {
        this.removeContentLengthHeader();
        this.removeContentTypeHeader();
        this.body = null;
    }
}

