/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.message;

import org.zoolu.net.UdpPacket;
import org.zoolu.sip.header.AllowEventsHeader;
import org.zoolu.sip.header.EventHeader;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.ReferToHeader;
import org.zoolu.sip.header.ReferredByHeader;
import org.zoolu.sip.header.SubscriptionStateHeader;
import org.zoolu.sip.message.BaseMessage;

public class Message
extends BaseMessage {
    public Message() {
    }

    public Message(String str) {
        super(str);
    }

    public Message(byte[] buff, int offset, int len) {
        super(buff, offset, len);
    }

    public Message(UdpPacket packet) {
        super(packet);
    }

    public Message(Message msg) {
        super(msg);
    }

    public Object clone() {
        return new Message(this);
    }

    public boolean isMessage() throws NullPointerException {
        return this.isRequest("MESSAGE");
    }

    public boolean isRefer() throws NullPointerException {
        return this.isRequest("REFER");
    }

    public boolean isNotify() throws NullPointerException {
        return this.isRequest("NOTIFY");
    }

    public boolean isSubscribe() throws NullPointerException {
        return this.isRequest("SUBSCRIBE");
    }

    public boolean isPublish() throws NullPointerException {
        return this.isRequest("PUBLISH");
    }

    public boolean hasReferToHeader() {
        return this.hasHeader("Refer-To");
    }

    public ReferToHeader getReferToHeader() {
        Header h = this.getHeader("Refer-To");
        if (h == null) {
            return null;
        }
        return new ReferToHeader(h);
    }

    public void setReferToHeader(ReferToHeader h) {
        this.setHeader(h);
    }

    public void removeReferToHeader() {
        this.removeHeader("Refer-To");
    }

    public boolean hasReferredByHeader() {
        return this.hasHeader("Refer-To");
    }

    public ReferredByHeader getReferredByHeader() {
        Header h = this.getHeader("Referred-By");
        if (h == null) {
            return null;
        }
        return new ReferredByHeader(h);
    }

    public void setReferredByHeader(ReferredByHeader h) {
        this.setHeader(h);
    }

    public void removeReferredByHeader() {
        this.removeHeader("Referred-By");
    }

    public boolean hasEventHeader() {
        return this.hasHeader("Event");
    }

    public EventHeader getEventHeader() {
        Header h = this.getHeader("Event");
        if (h == null) {
            return null;
        }
        return new EventHeader(h);
    }

    public void setEventHeader(EventHeader h) {
        this.setHeader(h);
    }

    public void removeEventHeader() {
        this.removeHeader("Event");
    }

    public boolean hasAllowEventsHeader() {
        return this.hasHeader("Allow-Events");
    }

    public AllowEventsHeader getAllowEventsHeader() {
        Header h = this.getHeader("Allow-Events");
        if (h == null) {
            return null;
        }
        return new AllowEventsHeader(h);
    }

    public void setAllowEventsHeader(AllowEventsHeader h) {
        this.setHeader(h);
    }

    public void removeAllowEventsHeader() {
        this.removeHeader("Allow-Events");
    }

    public boolean hasSubscriptionStateHeader() {
        return this.hasHeader("Subscription-State");
    }

    public SubscriptionStateHeader getSubscriptionStateHeader() {
        Header h = this.getHeader("Subscription-State");
        if (h == null) {
            return null;
        }
        return new SubscriptionStateHeader(h);
    }

    public void setSubscriptionStateHeader(SubscriptionStateHeader h) {
        this.setHeader(h);
    }

    public void removeSubscriptionStateHeader() {
        this.removeHeader("Subscription-State");
    }
}

