/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.message;

import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.dialog.Dialog;
import org.zoolu.sip.header.EventHeader;
import org.zoolu.sip.header.ReferToHeader;
import org.zoolu.sip.header.ReferredByHeader;
import org.zoolu.sip.header.SubjectHeader;
import org.zoolu.sip.message.BaseMessageFactory;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.SipProvider;

public class MessageFactory
extends BaseMessageFactory {
    public static Message createMessageRequest(SipProvider sip_provider, NameAddress recipient, NameAddress from, String subject, String type, String body) {
        SipURL request_uri = recipient.getAddress();
        String callid = sip_provider.pickCallId();
        int cseq = SipProvider.pickInitialCSeq();
        String localtag = SipProvider.pickTag();
        Message req = MessageFactory.createRequest(sip_provider, "MESSAGE", request_uri, recipient, from, null, callid, cseq, localtag, null, null, null);
        if (subject != null) {
            req.setSubjectHeader(new SubjectHeader(subject));
        }
        req.setBody(type, body);
        return req;
    }

    public static Message createReferRequest(SipProvider sip_provider, NameAddress recipient, NameAddress from, NameAddress contact, NameAddress refer_to) {
        SipURL request_uri = recipient.getAddress();
        String callid = sip_provider.pickCallId();
        int cseq = SipProvider.pickInitialCSeq();
        String localtag = SipProvider.pickTag();
        Message req = MessageFactory.createRequest(sip_provider, "REFER", request_uri, recipient, from, contact, callid, cseq, localtag, null, null, null);
        req.setReferToHeader(new ReferToHeader(refer_to));
        req.setReferredByHeader(new ReferredByHeader(from));
        return req;
    }

    public static Message createReferRequest(Dialog dialog, NameAddress refer_to, NameAddress referred_by) {
        Message req = MessageFactory.createRequest(dialog, "REFER", null);
        req.setReferToHeader(new ReferToHeader(refer_to));
        if (referred_by != null) {
            req.setReferredByHeader(new ReferredByHeader(referred_by));
        } else {
            req.setReferredByHeader(new ReferredByHeader(dialog.getLocalName()));
        }
        return req;
    }

    public static Message createSubscribeRequest(SipProvider sip_provider, SipURL recipient, NameAddress to, NameAddress from, NameAddress contact, String event, String id, String content_type, String body) {
        Message req = MessageFactory.createRequest(sip_provider, "SUBSCRIBE", recipient, to, from, contact, null);
        req.setEventHeader(new EventHeader(event, id));
        req.setBody(content_type, body);
        return req;
    }

    public static Message createSubscribeRequest(Dialog dialog, String event, String id, String content_type, String body) {
        Message req = MessageFactory.createRequest(dialog, "SUBSCRIBE", null);
        req.setEventHeader(new EventHeader(event, id));
        req.setBody(content_type, body);
        return req;
    }

    public static Message createNotifyRequest(Dialog dialog, String event, String id, String content_type, String body) {
        Message req = MessageFactory.createRequest(dialog, "NOTIFY", null);
        req.removeExpiresHeader();
        req.setEventHeader(new EventHeader(event, id));
        req.setBody(content_type, body);
        return req;
    }

    public static Message createNotifyRequest(Dialog dialog, String event, String id, String sipfragment) {
        Message req = MessageFactory.createRequest(dialog, "NOTIFY", null);
        req.removeExpiresHeader();
        req.setEventHeader(new EventHeader(event, id));
        req.setBody("message/sipfrag;version=2.0", sipfragment);
        return req;
    }

    public static Message createInfoRequest(Dialog dialog, String content_type, String body) {
        Message req = MessageFactory.createRequest(dialog, "INFO", null);
        req.removeExpiresHeader();
        req.setBody(content_type, body);
        return req;
    }
}

