/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import java.util.Date;
import java.util.Vector;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.RequestLine;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.message.Message;
import org.zoolu.tools.DateFormat;
import org.zoolu.tools.Parser;

public class SipParser
extends Parser {
    public static char[] MARK = new char[]{'-', '_', '.', '!', '~', '*', '\'', '|'};
    public static char[] SEPARATOR = new char[]{' ', '\t', '\r', '\n', '(', ')', '<', '>', ',', ';', '\\', '\"', '/', '[', ']', '?', '=', '{', '}'};
    public static char[] uri_separators = new char[]{' ', '>', '\n', '\r'};
    public static char[] param_separators = new char[]{' ', '=', ';', ',', '\n', '\r'};

    public SipParser(String s) {
        super(s);
    }

    public SipParser(String s, int i) {
        super(s, i);
    }

    public SipParser(StringBuffer sb) {
        super(sb);
    }

    public SipParser(StringBuffer sb, int i) {
        super(sb, i);
    }

    public SipParser(Parser p) {
        super(p.getWholeString(), p.getPos());
    }

    public static boolean isMark(char c) {
        return SipParser.isAnyOf(MARK, c);
    }

    public static boolean isUnreserved(char c) {
        return SipParser.isAlphanum(c) || SipParser.isMark(c);
    }

    public static boolean isSeparator(char c) {
        return SipParser.isAnyOf(SEPARATOR, c);
    }

    public int indexOfSeparator() {
        int begin = this.index;
        while (begin < this.str.length() && !SipParser.isSeparator(this.str.charAt(begin))) {
            ++begin;
        }
        return begin;
    }

    public int indexOfEOH() {
        int end;
        SipParser par = new SipParser(this.str, this.index);
        do {
            par.goTo(CRLF);
            if (!par.hasMore()) {
                return this.str.length();
            }
            end = par.getPos();
            par.goToNextLine();
        } while (par.hasMore() && SipParser.isWSP(par.nextChar()));
        return end;
    }

    public int indexOfNextHeader() {
        SipParser par = new SipParser(this.str, this.index);
        par.goToNextHeader();
        return par.getPos();
    }

    public int indexOfHeader(String hname) {
        if (this.str.startsWith(hname, this.index)) {
            return this.index;
        }
        String[] target = new String[]{String.valueOf('\n') + hname, String.valueOf('\r') + hname};
        SipParser par = new SipParser(this.str, this.index);
        par.goToIgnoreCase(target);
        if (par.hasMore()) {
            par.skipChar();
        }
        return par.getPos();
    }

    public SipParser goToNextHeader() {
        this.index = this.indexOfEOH();
        this.goToNextLine();
        return this;
    }

    public SipParser goToEndOfLastHeader() {
        String[] delimiters = new String[]{"\r\n\r\n", "\n\n"};
        this.goTo(delimiters);
        if (!this.hasMore()) {
            this.index = this.str.startsWith("\r\n", this.str.length() - 2) ? this.str.length() - 2 : (this.str.charAt(this.str.length() - 1) == '\n' ? this.str.length() - 1 : this.str.length());
        }
        return this;
    }

    public SipParser goToBody() {
        this.goToEndOfLastHeader();
        this.goTo('\n').skipChar();
        this.goTo('\n').skipChar();
        return this;
    }

    public Header getHeader() {
        if (!this.hasMore()) {
            return null;
        }
        int begin = this.getPos();
        int end = this.indexOfEOH();
        String header_str = this.getString(end - begin);
        this.goToNextLine();
        int colon = header_str.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String hname = header_str.substring(0, colon).trim();
        String hvalue = header_str.substring(++colon).trim();
        return new Header(hname, hvalue);
    }

    public Header getHeader(String hname) {
        SipParser par = new SipParser(this.str, this.indexOfHeader(hname));
        if (!par.hasMore()) {
            return null;
        }
        par.skipN(hname.length());
        int begin = par.indexOf(':') + 1;
        int end = par.indexOfEOH();
        if (begin > end) {
            return null;
        }
        String hvalue = this.str.substring(begin, end).trim();
        this.index = end;
        return new Header(hname, hvalue);
    }

    public RequestLine getRequestLine() {
        String method = this.getString();
        this.skipWSP();
        int begin = this.getPos();
        int end = this.indexOfEOH();
        String request_uri = this.getString(end - begin);
        this.goToNextLine();
        return new RequestLine(method, new SipParser(request_uri).getSipURL());
    }

    public StatusLine getStatusLine() {
        String version = this.getString(4);
        if (!version.equalsIgnoreCase("SIP/")) {
            this.index = this.str.length();
            return null;
        }
        this.skipString().skipWSP();
        int code = this.getInt();
        int begin = this.getPos();
        int end = this.indexOfEOH();
        String reason = this.getString(end - begin).trim();
        this.goToNextLine();
        return new StatusLine(code, reason);
    }

    public SipURL getSipURL() {
        this.goTo("sip:");
        if (!this.hasMore()) {
            return null;
        }
        int begin = this.getPos();
        int end = this.indexOf(uri_separators);
        if (end < 0) {
            end = this.str.length();
        }
        String url = this.getString(end - begin);
        if (this.hasMore()) {
            this.skipChar();
        }
        return new SipURL(url);
    }

    public NameAddress getNameAddress() {
        String text = null;
        SipURL url = null;
        int begin = this.getPos();
        int begin_url = this.indexOf("<sip:");
        if (begin_url < 0) {
            url = this.getSipURL();
            if (url == null) {
                this.setPos(begin);
                url = new SipURL(this.getString());
            }
            return new NameAddress(url);
        }
        text = this.getString(begin_url - begin).trim();
        url = this.getSipURL();
        if (text.length() > 0 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            text = text.substring(1, text.length() - 1);
        }
        if (text.length() == 0) {
            return new NameAddress(url);
        }
        return new NameAddress(text, url);
    }

    public Date getDate() {
        try {
            Date d = DateFormat.parseEEEddMMM(this.str, this.index);
            this.index = this.str.indexOf("GMT", this.index) + 3;
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.index = this.str.length();
            return null;
        }
    }

    public String getParameter(String name) {
        while (this.hasMore()) {
            if (this.getWord(param_separators).equals(name)) {
                this.skipWSP();
                if (this.hasMore() && this.nextChar() == '=') {
                    this.skipChar();
                    return this.getWordSkippingQuoted(param_separators);
                }
                return null;
            }
            this.goToSkippingQuoted(';');
            if (!this.hasMore()) continue;
            this.skipChar();
        }
        return null;
    }

    public Vector getParameters() {
        Vector<String> params = new Vector<String>();
        while (this.hasMore()) {
            String name = this.getWord(param_separators);
            if (name.length() > 0) {
                params.addElement(new String(name));
            }
            this.goToSkippingQuoted(';');
            if (!this.hasMore()) continue;
            this.skipChar();
        }
        return params;
    }

    public boolean hasParameter(String name) {
        while (this.hasMore()) {
            if (this.getWord(param_separators).equals(name)) {
                return true;
            }
            this.goToSkippingQuoted(';');
            if (!this.hasMore()) continue;
            this.skipChar();
        }
        return false;
    }

    public int indexOfCommaHeaderSeparator() {
        boolean inside_quoted_string = false;
        int i = this.index;
        while (i < this.str.length()) {
            char c = this.str.charAt(i);
            if (c == '\"') {
                boolean bl = inside_quoted_string = !inside_quoted_string;
            }
            if (!inside_quoted_string && c == ',') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public SipParser goToCommaHeaderSeparator() {
        int comma = this.indexOfCommaHeaderSeparator();
        this.index = comma < 0 ? this.str.length() : comma;
        return this;
    }

    public Message getSipMessage() {
        this.skipCRLF();
        String text = this.getPos() == 0 ? this.str : this.getRemainingString();
        Message msg = new Message(text);
        if (!msg.hasContentLengthHeader()) {
            return null;
        }
        int body_len = msg.getContentLengthHeader().getContentLength();
        int begin = this.getPos();
        this.goToEndOfLastHeader();
        if (!this.hasMore()) {
            return null;
        }
        this.goTo('\n');
        if (!this.hasMore()) {
            return null;
        }
        this.skipChar().goTo('\n');
        if (!this.hasMore()) {
            return null;
        }
        int body_pos = this.skipChar().getPos();
        int end = body_pos + body_len;
        if (end <= this.str.length()) {
            this.index = end;
            return new Message(this.str.substring(begin, end));
        }
        return null;
    }
}

