/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.zoolu.net.IpAddress;
import org.zoolu.net.SocketAddress;
import org.zoolu.net.TcpServer;
import org.zoolu.net.TcpServerListener;
import org.zoolu.net.TcpSocket;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.header.ViaHeader;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.MessageFactory;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.ConnectedTransport;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.Identifier;
import org.zoolu.sip.provider.OptionHandler;
import org.zoolu.sip.provider.SipProviderExceptionListener;
import org.zoolu.sip.provider.SipProviderListener;
import org.zoolu.sip.provider.SipStack;
import org.zoolu.sip.provider.SpcHashtable;
import org.zoolu.sip.provider.StunClient;
import org.zoolu.sip.provider.TcpTransport;
import org.zoolu.sip.provider.Transport;
import org.zoolu.sip.provider.TransportListener;
import org.zoolu.sip.provider.UdpTransport;
import org.zoolu.sip.transaction.InviteTransactionServer;
import org.zoolu.sip.transaction.TransactionServer;
import org.zoolu.tools.Configurable;
import org.zoolu.tools.Configure;
import org.zoolu.tools.DateFormat;
import org.zoolu.tools.HashSet;
import org.zoolu.tools.Parser;
import org.zoolu.tools.Random;
import org.zoolu.tools.SimpleDigest;

public class SipProvider
implements Configurable,
TransportListener,
TcpServerListener {
    public static final String PROTO_UDP = "udp";
    public static final String PROTO_TCP = "tcp";
    public static final String PROTO_TLS = "tls";
    public static final String PROTO_SCTP = "sctp";
    public static final String AUTO_CONFIGURATION = "AUTO-CONFIGURATION";
    public static final String ALL_INTERFACES = "ALL-INTERFACES";
    public static final Identifier ANY = new Identifier("ANY");
    public static final Identifier PROMISQUE = new Identifier("PROMISQUE");
    public static final Identifier INVITE = new Identifier("INVITE");
    private static final int MIN_MESSAGE_LENGTH = 12;
    String logConfigFile = "log.properties";
    String sipBusyUrl = null;
    String via_addr = null;
    int host_port = 0;
    String host_ifaddr = null;
    String[] transport_protocols = null;
    int nmax_connections = 0;
    SocketAddress outbound_proxy = null;
    boolean log_all_packets = false;
    boolean msgLoggingEnabled = false;
    private boolean sendResponseUsingOutboundProxy = false;
    private boolean useViaReceived = true;
    private boolean useViaRport = true;
    private String stunServer = null;
    private int stunInterval = 0;
    private StunClient stunClient = null;
    private String outbound_addr = null;
    private int outbound_port = -1;
    private OptionHandler optionHandler = null;
    private boolean optionHandlerReqInvKey = true;
    protected Logger event_log = null;
    protected Logger message_log = null;
    protected Logger std_log = null;
    IpAddress host_ipaddr = null;
    String default_transport = null;
    static long breaker = 0L;
    private boolean initComplete = false;
    private Object inviteLock = new Object();
    private String publicIP = null;
    private boolean enableNatTranslate = false;
    private boolean enableNatTranslateVia = false;
    boolean transport_udp = false;
    boolean transport_tcp = false;
    boolean transport_tls = false;
    boolean transport_sctp = false;
    boolean stopProvider = false;
    boolean rport = true;
    boolean force_rport = false;
    SpcHashtable listeners = null;
    HashSet exception_listeners = null;
    UdpTransport udp = null;
    TcpServer tcp_server = null;
    Hashtable connections = null;

    public SipProvider(String via_addr, int port) {
        this.init(via_addr, port, null, null);
        this.initlog();
        this.startTrasport();
        this.stunInit();
    }

    public SipProvider(String via_addr, int port, String[] protocols, String ifaddr) {
        this.init(via_addr, port, protocols, ifaddr);
        this.initlog();
        this.startTrasport();
        this.stunInit();
    }

    public SipProvider(String file) {
        if (!SipStack.isInit()) {
            SipStack.init(file);
        }
        new Configure(this, file);
        this.init(this.via_addr, this.host_port, this.transport_protocols, this.host_ifaddr);
        this.initlog();
        this.startTrasport();
        this.stunInit();
    }

    private void init(String viaddr, int port, String[] protocols, String ifaddr) {
        if (!SipStack.isInit()) {
            SipStack.init();
        }
        this.via_addr = viaddr;
        if (this.via_addr == null || this.via_addr.equalsIgnoreCase(AUTO_CONFIGURATION)) {
            this.via_addr = IpAddress.getLocalHostAddress().toString();
        }
        this.host_port = port;
        if (this.host_port <= 0) {
            this.host_port = SipStack.default_port;
        }
        this.host_ipaddr = null;
        if (ifaddr != null && !ifaddr.equalsIgnoreCase(ALL_INTERFACES)) {
            try {
                this.host_ipaddr = IpAddress.getByName(ifaddr);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.host_ipaddr = null;
            }
        }
        this.transport_protocols = protocols;
        if (this.transport_protocols == null) {
            this.transport_protocols = SipStack.default_transport_protocols;
        }
        this.default_transport = this.transport_protocols[0];
        int i = 0;
        while (i < this.transport_protocols.length) {
            this.transport_protocols[i] = this.transport_protocols[i].toLowerCase();
            if (this.transport_protocols[i].equals(PROTO_UDP)) {
                this.transport_udp = true;
            } else if (this.transport_protocols[i].equals(PROTO_TCP)) {
                this.transport_tcp = true;
            }
            ++i;
        }
        if (this.nmax_connections <= 0) {
            this.nmax_connections = SipStack.default_nmax_connections;
        }
        if (this.outbound_port < 0) {
            this.outbound_port = SipStack.default_port;
        }
        if (this.outbound_addr != null) {
            this.outbound_proxy = this.outbound_addr.equalsIgnoreCase(Configure.NONE) || this.outbound_addr.equalsIgnoreCase("NO-OUTBOUND") ? null : new SocketAddress(this.outbound_addr, this.outbound_port);
        }
        this.rport = SipStack.use_rport;
        this.force_rport = SipStack.force_rport;
        this.exception_listeners = new HashSet();
        Hashtable<Identifier, String> dupeKeys = new Hashtable<Identifier, String>();
        dupeKeys.put(INVITE, "");
        this.listeners = new SpcHashtable(dupeKeys);
        this.connections = new Hashtable();
    }

    private void initlog() {
        PropertyConfigurator.configure((String)this.logConfigFile);
        this.event_log = Logger.getLogger((String)(String.valueOf(this.getClass().getName()) + "_evt"));
        this.message_log = Logger.getLogger((String)(String.valueOf(this.getClass().getName()) + "_msg"));
        this.std_log = Logger.getLogger((String)this.getClass().getName());
        this.event_log.debug((Object)("Date: " + DateFormat.formatHHMMSS(new Date())));
        this.event_log.debug((Object)"SipStack: mjsip stack 1.6 sts");
        this.event_log.debug((Object)("new SipProvider(): " + this.toString()));
        this.msgLoggingEnabled = this.message_log.isDebugEnabled() || this.event_log.isDebugEnabled();
    }

    private void startTrasport() {
        this.stopProvider = false;
        if (this.transport_udp) {
            try {
                this.udp = this.host_ipaddr == null ? new UdpTransport(this.host_port, (TransportListener)this) : new UdpTransport(this.host_port, this.host_ipaddr, this);
                this.event_log.debug((Object)"udp is up");
            }
            catch (Exception e) {
                this.event_log.error((Object)"error", (Throwable)e);
                System.exit(1);
            }
        }
        if (this.transport_tcp) {
            try {
                this.tcp_server = this.host_ipaddr == null ? new TcpServer(this.host_port, this) : new TcpServer(this.host_port, this.host_ipaddr, this);
                this.event_log.debug((Object)"tcp is up");
            }
            catch (Exception e) {
                this.event_log.error((Object)"error", (Throwable)e);
                System.exit(1);
            }
        }
    }

    private void stopTrasport() {
        this.stopProvider = true;
        if (this.stunClient != null && this.stunInterval > 0) {
            this.stunClient.halt();
        }
        if (this.udp != null) {
            this.event_log.debug((Object)"udp is going down");
            this.udp.halt();
            this.udp = null;
        }
        if (this.tcp_server != null) {
            this.event_log.debug((Object)"tcp is going down");
            this.tcp_server.halt();
            this.tcp_server = null;
        }
        if (this.connections != null) {
            this.event_log.debug((Object)"connections are going down");
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                ConnectedTransport c = (ConnectedTransport)e.nextElement();
                c.halt();
            }
            this.connections = null;
        }
    }

    public void halt() {
        this.event_log.debug((Object)"halt: SipProvider is going down");
        this.stopTrasport();
        this.listeners = new SpcHashtable(null);
        this.exception_listeners = new HashSet();
        LogManager.resetConfiguration();
    }

    public void parseLine(String line) {
        Parser par;
        String attribute;
        int index = line.indexOf("=");
        if (index > 0) {
            attribute = line.substring(0, index).trim();
            par = new Parser(line, index + 1);
        } else {
            attribute = line;
            par = new Parser("");
        }
        char[] delim = new char[]{' ', ','};
        if (attribute.equals("via_addr")) {
            this.via_addr = par.getString();
            return;
        }
        if (attribute.equals("host_port")) {
            this.host_port = par.getInt();
            return;
        }
        if (attribute.equals("host_ifaddr")) {
            this.host_ifaddr = par.getString();
            return;
        }
        if (attribute.equals("transport_protocols")) {
            this.transport_protocols = par.getWordArray(delim);
            return;
        }
        if (attribute.equals("nmax_connections")) {
            this.nmax_connections = par.getInt();
            return;
        }
        if (attribute.equals("outbound_proxy")) {
            String soaddr = par.getString();
            this.outbound_proxy = soaddr == null || soaddr.length() == 0 || soaddr.equalsIgnoreCase(Configure.NONE) || soaddr.equalsIgnoreCase("NO-OUTBOUND") ? null : new SocketAddress(soaddr);
            return;
        }
        if (attribute.equals("log_all_packets")) {
            this.log_all_packets = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("host_addr")) {
            System.err.println("WARNING: parameter 'host_addr' is no more supported; use 'via_addr' instead.");
        }
        if (attribute.equals("all_interfaces")) {
            System.err.println("WARNING: parameter 'all_interfaces' is no more supported; use 'host_iaddr' for setting a specific interface or let it undefined.");
        }
        if (attribute.equals("use_outbound")) {
            System.err.println("WARNING: parameter 'use_outbound' is no more supported; use 'outbound_proxy' for setting an outbound proxy or let it undefined.");
        }
        if (attribute.equals("outbound_addr")) {
            System.err.println("WARNING: parameter 'outbound_addr' has been deprecated; use 'outbound_proxy=<host_addr>[:<host_port>]' instead.");
            this.outbound_addr = par.getString();
            return;
        }
        if (attribute.equals("outbound_port")) {
            System.err.println("WARNING: parameter 'outbound_port' has been deprecated; use 'outbound_proxy=<host_addr>[:<host_port>]' instead.");
            this.outbound_port = par.getInt();
            return;
        }
        if (attribute.equals("logConfigFile")) {
            this.logConfigFile = par.getString();
            return;
        }
        if (attribute.equals("sendResponseUsingOutboundProxy")) {
            this.sendResponseUsingOutboundProxy = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("useViaReceived")) {
            this.useViaReceived = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("useViaRport")) {
            this.useViaRport = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("SipInboundAllChannelsBusyAction")) {
            String sipInboundAllChannelsBusyAction = par.getRemainingString();
            this.sipBusyUrl = sipInboundAllChannelsBusyAction.startsWith("transferto:") ? sipInboundAllChannelsBusyAction.replaceAll("transferto:", "") : null;
            return;
        }
        if (attribute.equalsIgnoreCase("publicIP")) {
            this.publicIP = par.getRemainingString().trim();
            if (this.publicIP.length() == 0) {
                this.publicIP = null;
            }
            return;
        }
        if (attribute.equalsIgnoreCase("stunServer")) {
            this.stunServer = par.getRemainingString().trim();
            return;
        }
        if (attribute.equalsIgnoreCase("stunTestInterval")) {
            this.stunInterval = par.getInt();
            return;
        }
        if (attribute.equalsIgnoreCase("enableNatTranslate")) {
            this.enableNatTranslate = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equalsIgnoreCase("enableNatTranslateVia")) {
            this.enableNatTranslateVia = par.getString().toLowerCase().startsWith("y");
            return;
        }
    }

    protected String toLines() {
        return this.toString();
    }

    private String transportProtocolsToString() {
        String list = this.transport_protocols[0];
        int i = 1;
        while (i < this.transport_protocols.length) {
            list = String.valueOf(list) + "/" + this.transport_protocols[i];
            ++i;
        }
        return list;
    }

    public String getViaAddress() {
        return this.via_addr;
    }

    public int getPort() {
        return this.host_port;
    }

    public boolean isAllInterfaces() {
        return this.host_ipaddr == null;
    }

    public IpAddress getInterfaceAddress() {
        return this.host_ipaddr;
    }

    public String[] getTransportProtocols() {
        return this.transport_protocols;
    }

    public String getDefaultTransport() {
        return this.default_transport;
    }

    public void setDefaultTransport(String proto) {
        this.default_transport = proto;
    }

    public void setRport(boolean flag) {
        this.rport = flag;
    }

    public boolean isRportSet() {
        return this.rport;
    }

    public void setForceRport(boolean flag) {
        this.force_rport = flag;
    }

    public boolean isForceRportSet() {
        return this.force_rport;
    }

    public boolean hasOutboundProxy() {
        return this.outbound_proxy != null;
    }

    public SocketAddress getOutboundProxy() {
        return this.outbound_proxy;
    }

    public void setOutboundProxy(SocketAddress soaddr) {
        this.outbound_proxy = soaddr;
    }

    public int getNMaxConnections() {
        return this.nmax_connections;
    }

    public void setNMaxConnections(int n) {
        this.nmax_connections = n;
    }

    public SpcHashtable getListeners() {
        return this.listeners;
    }

    public boolean addSipProviderPromisqueListener(SipProviderListener listener) {
        return this.addSipProviderListener(PROMISQUE, listener);
    }

    public boolean addSipProviderListener(SipProviderListener listener) {
        return this.addSipProviderListener(ANY, listener);
    }

    public boolean addSipProviderListener(Identifier key, SipProviderListener listener) {
        boolean ret;
        this.event_log.debug((Object)("adding SipProviderListener: " + key));
        if (this.listeners.containsKey(key) && !key.toString().equals("INVITE")) {
            this.event_log.warn((Object)("trying to add a SipProviderListener with a id that is already in use. " + key.toString()));
            ret = false;
        } else {
            this.listeners.put(key, listener);
            ret = true;
        }
        if (this.listeners != null && this.event_log.isDebugEnabled()) {
            String list = "";
            Enumeration e = this.listeners.keys();
            while (e.hasMoreElements()) {
                list = String.valueOf(list) + e.nextElement() + ", ";
            }
            this.event_log.debug((Object)(String.valueOf(this.listeners.size()) + " listeners: " + list + "\n" + this.listeners.toString()));
        }
        this.initComplete = true;
        return ret;
    }

    public boolean removeSipProviderListener(Identifier key) {
        boolean ret;
        this.event_log.debug((Object)("removing SipProviderListener: " + key));
        if (!this.listeners.containsKey(key)) {
            this.event_log.warn((Object)"trying to remove a missed SipProviderListener.");
            ret = false;
        } else {
            this.listeners.remove(key);
            ret = true;
        }
        if (this.listeners != null && this.event_log.isDebugEnabled()) {
            String list = "";
            Enumeration e = this.listeners.keys();
            while (e.hasMoreElements()) {
                list = String.valueOf(list) + e.nextElement() + ", ";
            }
            this.event_log.debug((Object)(String.valueOf(this.listeners.size()) + " listeners: " + list + "\n" + this.listeners.toString()));
        }
        return ret;
    }

    public boolean removeSipProviderListener(Identifier key, Object listener) {
        boolean ret;
        this.event_log.debug((Object)("removing SipProviderListener Pair: " + key));
        if (!this.listeners.containsPair(key, listener)) {
            this.event_log.warn((Object)"trying to remove a missed SipProviderListener Pair.");
            ret = false;
        } else {
            this.listeners.removePair(key, listener);
            ret = true;
        }
        if (this.listeners != null && this.event_log.isDebugEnabled()) {
            String list = "";
            Enumeration e = this.listeners.keys();
            while (e.hasMoreElements()) {
                list = String.valueOf(list) + e.nextElement() + ", ";
            }
            this.event_log.debug((Object)(String.valueOf(this.listeners.size()) + " listeners: " + list + "\n" + this.listeners.toString()));
        }
        return ret;
    }

    public boolean addSipProviderExceptionListener(SipProviderExceptionListener e_listener) {
        this.event_log.debug((Object)"adding SipProviderExceptionListener");
        if (this.exception_listeners.contains(e_listener)) {
            this.event_log.warn((Object)"trying to add an already present SipProviderExceptionListener.");
            return false;
        }
        this.exception_listeners.add(e_listener);
        return true;
    }

    public boolean removeSipProviderExceptionListener(SipProviderExceptionListener e_listener) {
        this.event_log.debug((Object)"removing SipProviderExceptionListener");
        if (!this.exception_listeners.contains(e_listener)) {
            this.event_log.warn((Object)"trying to remove a missed SipProviderExceptionListener.");
            return false;
        }
        this.exception_listeners.remove(e_listener);
        return true;
    }

    public ConnectionIdentifier sendMessage(Message msg, String proto, String dest_addr, int dest_port, int ttl) {
        if (this.log_all_packets || msg.getLength() > 12) {
            this.event_log.debug((Object)("Resolving host address '" + dest_addr + "'"));
        }
        try {
            IpAddress dest_ipaddr = IpAddress.getByName(dest_addr);
            return this.sendMessage(msg, proto, dest_ipaddr, dest_port, ttl);
        }
        catch (Exception e) {
            this.event_log.error((Object)"error", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectionIdentifier sendMessage(Message msg, String proto, IpAddress dest_ipaddr, int dest_port, int ttl) {
        InetAddress destInet;
        if (this.stopProvider) {
            return null;
        }
        ConnectionIdentifier conn_id = new ConnectionIdentifier(proto, dest_ipaddr, dest_port);
        if (this.log_all_packets || msg.getLength() > 12) {
            this.event_log.debug((Object)("Sending message to " + conn_id));
        }
        if (this.enableNatTranslate && this.publicIP != null && !this.publicIP.equals(this.via_addr) && !this.isIPLocal(destInet = dest_ipaddr.getInetAddress()) && !this.publicIP.equals(destInet.getHostAddress())) {
            String safeVia = this.makeSafePattern(this.via_addr);
            String nMsg = msg.toString();
            if (this.enableNatTranslateVia) {
                nMsg = nMsg.replaceAll("(Via:[^\n\r]*)" + safeVia + ":" + this.host_port, "$1" + this.publicIP + ":" + this.host_port);
            }
            nMsg = nMsg.replaceAll("(Contact:[^\n\r]*)" + safeVia + ":" + this.host_port, "$1" + this.publicIP + ":" + this.host_port);
            nMsg = nMsg.replaceAll("(From:[^\n\r]*)" + safeVia + ":" + this.host_port, "$1" + this.publicIP + ":" + this.host_port);
            nMsg = nMsg.replaceAll("(To:[^\n\r]*)" + safeVia + ":" + this.host_port, "$1" + this.publicIP + ":" + this.host_port);
            if (!(nMsg = nMsg.replaceAll("(c=IN IP\\d [^\n\r]*)" + safeVia, "$1" + this.publicIP)).equals(msg.toString())) {
                this.std_log.debug((Object)"natTranslateTx");
                msg = new Message(nMsg);
            }
        }
        if (this.transport_udp && proto.equals(PROTO_UDP)) {
            conn_id = null;
            try {
                this.udp.sendMessage(msg, dest_ipaddr, dest_port);
            }
            catch (IOException e) {
                this.event_log.error((Object)"error", (Throwable)e);
                return null;
            }
        }
        if (this.transport_tcp && proto.equals(PROTO_TCP)) {
            ConnectedTransport conn;
            if (!this.connections.containsKey(conn_id)) {
                this.event_log.debug((Object)("no active connection found matching " + conn_id));
                this.event_log.debug((Object)("open " + proto + " connection to " + dest_ipaddr + ":" + dest_port));
                conn = null;
                try {
                    conn = new TcpTransport(dest_ipaddr, dest_port, this);
                }
                catch (Exception e) {
                    this.event_log.error((Object)"connection setup FAILED");
                    return null;
                }
                this.event_log.debug((Object)("connection " + conn + " opened"));
                this.addConnection(conn);
            } else {
                this.event_log.debug((Object)("active connection found matching " + conn_id));
            }
            conn = (ConnectedTransport)this.connections.get(conn_id);
            if (conn == null) {
                this.event_log.error((Object)("ERROR: conn " + conn_id + " not found: abort."));
                return null;
            }
            this.event_log.debug((Object)("sending data through conn " + conn));
            try {
                conn.sendMessage(msg);
                conn_id = new ConnectionIdentifier(conn);
            }
            catch (IOException e) {
                this.event_log.error((Object)"error", (Throwable)e);
                return null;
            }
        }
        this.event_log.warn((Object)("Unsupported protocol (" + proto + "): Message discarded"));
        return null;
        String dest_addr = dest_ipaddr.toString();
        if (this.msgLoggingEnabled) {
            this.printMessageLog(proto, dest_addr, dest_port, msg.getLength(), msg, "sent");
        }
        return conn_id;
    }

    public ConnectionIdentifier sendMessage(Message msg) {
        this.event_log.debug((Object)("Sending message:\r\n" + msg.toString()));
        ViaHeader via = msg.getViaHeader();
        String proto = via.getProtocol().toLowerCase();
        this.event_log.debug((Object)("using transport " + proto));
        String dest_addr = null;
        int dest_port = 0;
        int ttl = 0;
        if (msg.isRequest()) {
            if (this.outbound_proxy != null) {
                dest_addr = this.outbound_proxy.getAddress().toString();
                dest_port = this.outbound_proxy.getPort();
            } else if (msg.hasRouteHeader() && msg.getRouteHeader().getNameAddress().getAddress().hasLr()) {
                SipURL url = msg.getRouteHeader().getNameAddress().getAddress();
                dest_addr = url.getHost();
                dest_port = url.getPort();
            } else {
                SipURL url = msg.getRequestLine().getAddress();
                dest_addr = url.getHost();
                dest_port = url.getPort();
                if (url.hasMaddr()) {
                    dest_addr = url.getMaddr();
                    if (url.hasTtl()) {
                        ttl = url.getTtl();
                    }
                    via.setMaddr(dest_addr);
                    if (ttl > 0) {
                        via.setTtl(ttl);
                    }
                    msg.removeViaHeader();
                    msg.addViaHeader(via);
                }
            }
        } else if (this.outbound_proxy != null && this.sendResponseUsingOutboundProxy) {
            dest_addr = this.outbound_proxy.getAddress().toString();
            dest_port = this.outbound_proxy.getPort();
        } else {
            SipURL url = via.getSipURL();
            dest_addr = via.hasReceived() ? via.getReceived() : url.getHost();
            if (via.hasRport()) {
                dest_port = via.getRport();
            }
            if (dest_port <= 0) {
                dest_port = url.getPort();
            }
        }
        if (dest_port <= 0) {
            dest_port = SipStack.default_port;
        }
        return this.sendMessage(msg, proto, dest_addr, dest_port, ttl);
    }

    public ConnectionIdentifier sendMessage(Message msg, ConnectionIdentifier conn_id) {
        if (this.log_all_packets || msg.getLength() > 12) {
            this.event_log.debug((Object)("Sending message through conn " + conn_id));
        }
        this.event_log.debug((Object)("message:\r\n" + msg.toString()));
        if (conn_id != null && this.connections.containsKey(conn_id)) {
            this.event_log.debug((Object)("active connection found matching " + conn_id));
            ConnectedTransport conn = (ConnectedTransport)this.connections.get(conn_id);
            try {
                conn.sendMessage(msg);
                String proto = conn.getProtocol();
                String dest_addr = conn.getRemoteAddress().toString();
                int dest_port = conn.getRemotePort();
                if (this.msgLoggingEnabled) {
                    this.printMessageLog(proto, dest_addr, dest_port, msg.getLength(), msg, "sent");
                }
                return conn_id;
            }
            catch (Exception e) {
                this.event_log.error((Object)"error", (Throwable)e);
            }
        }
        this.event_log.debug((Object)("no active connection found matching " + conn_id));
        return this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void processReceivedMessage(Message msg) {
        block47: {
            try {
                if (this.msgLoggingEnabled) {
                    this.printMessageLog(msg.getTransportProtocol(), msg.getRemoteAddress(), msg.getRemotePort(), msg.getLength(), msg, "received");
                }
                if (msg.getLength() <= 2) {
                    if (this.log_all_packets) {
                        this.event_log.debug((Object)"message too short: discarded\r\n");
                    }
                    return;
                }
                first_line = msg.getFirstLine();
                if (first_line == null || first_line.toUpperCase().indexOf("SIP/2.0") < 0) {
                    if (this.log_all_packets) {
                        this.event_log.debug((Object)"NOT a SIP message: discarded\r\n");
                    }
                    return;
                }
                this.event_log.debug((Object)("received new SIP message:\r\n" + msg.toString()));
                if (this.enableNatTranslate && this.enableNatTranslateVia && this.publicIP != null && !this.publicIP.equals(this.via_addr)) {
                    remAddr = null;
                    try {
                        remAddr = InetAddress.getByName(msg.getRemoteAddress());
                    }
                    catch (Exception e) {
                        this.std_log.debug((Object)("Error on address:" + msg.getRemoteAddress()), (Throwable)e);
                    }
                    if (remAddr != null && !this.isIPLocal(remAddr) && (via = msg.getViaHeader()).getHost().equals(this.publicIP) && via.getPort() == this.host_port) {
                        this.std_log.debug((Object)"natTranslateRx");
                        msg.removeViaHeader();
                        strVia = via.getValue();
                        safePub = this.makeSafePattern(this.publicIP);
                        strVia = strVia.replaceAll(String.valueOf(safePub) + ":" + this.host_port, String.valueOf(this.via_addr) + ":" + this.host_port);
                        newVia = new ViaHeader(strVia);
                        msg.addViaHeader(newVia);
                    }
                }
                if (msg.isRequest()) {
                    vh = msg.getViaHeader();
                    via_changed = false;
                    src_addr = msg.getRemoteAddress();
                    src_port = msg.getRemotePort();
                    via_addr = vh.getHost();
                    via_port = vh.getPort();
                    if (via_port <= 0) {
                        via_port = SipStack.default_port;
                    }
                    if (!via_addr.equals(src_addr) && this.useViaReceived) {
                        vh.setReceived(src_addr);
                        via_changed = true;
                    }
                    if (this.useViaRport) {
                        if (vh.hasRport()) {
                            vh.setRport(src_port);
                            via_changed = true;
                        } else if (this.force_rport && via_port != src_port) {
                            vh.setRport(src_port);
                            via_changed = true;
                        }
                    }
                    if (via_changed) {
                        msg.removeViaHeader();
                        msg.addViaHeader(vh);
                    }
                }
                if (this.listeners == null || this.listeners.size() == 0) {
                    if (this.initComplete) {
                        this.event_log.error((Object)"no listener found: message discarded.");
                    }
                    return;
                }
                if (this.listeners.containsKey(SipProvider.PROMISQUE)) {
                    this.event_log.debug((Object)("message passed to uas: " + SipProvider.PROMISQUE));
                    ((SipProviderListener)this.listeners.get(SipProvider.PROMISQUE)).onReceivedMessage(this, msg);
                }
                if (!msg.isRequest() && !msg.isResponse()) {
                    this.event_log.error((Object)"No valid SIP message: message discarded.");
                    return;
                }
                if (msg.isRequest() && msg.isOption()) {
                    optStat = 486;
                    if (!this.optionHandlerReqInvKey || this.listeners.containsKey(SipProvider.INVITE)) {
                        if (this.optionHandler != null) {
                            optBody = this.optionHandler.onOptionMsgReceived();
                            if (optBody != null) {
                                optStat = 200;
                                this.event_log.debug((Object)("OPTION Request - response status=" + optStat));
                                ts = new TransactionServer(this, msg, null);
                                ts.respondWith(MessageFactory.createResponse(msg, optStat, SipResponses.reasonOf(optStat), null, null, "application/sdp", optBody));
                                return;
                            }
                        } else {
                            optStat = 200;
                        }
                    }
                    this.event_log.debug((Object)("OPTION Request - response status=" + optStat));
                    ts = new TransactionServer(this, msg, null);
                    ts.respondWith(MessageFactory.createResponse(msg, optStat, SipResponses.reasonOf(optStat), null));
                    return;
                }
                key /* !! */  = msg.getTransactionId();
                this.event_log.debug((Object)("transaction-id: " + key /* !! */ ));
                if (this.listeners.containsKey(key /* !! */ )) {
                    this.event_log.debug((Object)("message passed to transaction: " + key /* !! */ ));
                    ((SipProviderListener)this.listeners.get(key /* !! */ )).onReceivedMessage(this, msg);
                    return;
                }
                key /* !! */  = msg.getDialogId();
                this.event_log.debug((Object)("dialog-id: " + key /* !! */ ));
                if (this.listeners.containsKey(key /* !! */ )) {
                    this.event_log.debug((Object)("message passed to dialog: " + key /* !! */ ));
                    ((SipProviderListener)this.listeners.get(key /* !! */ )).onReceivedMessage(this, msg);
                    return;
                }
                key /* !! */  = msg.getMethodId();
                if (msg.isRequest() && msg.isInvite()) {
                    ts = this.inviteLock;
                    synchronized (ts) {
                        if (this.listeners.containsKey(key /* !! */ )) {
                            this.event_log.debug((Object)("message passed to uas: " + key /* !! */ ));
                            ((SipProviderListener)this.listeners.get(key /* !! */ )).onReceivedMessage(this, msg);
                            return;
                        }
                    }
                } else if (this.listeners.containsKey(key /* !! */ )) {
                    this.event_log.debug((Object)("message passed to uas: " + key /* !! */ ));
                    ((SipProviderListener)this.listeners.get(key /* !! */ )).onReceivedMessage(this, msg);
                    return;
                }
                if (msg.isRequest() && msg.isInvite()) {
                    if (this.sipBusyUrl != null) {
                        targetId = msg.getToHeader().getNameAddress().toString().replaceAll("(?i).*sip:<?([^@<]+)@.*", "$1");
                        redirect_Url = this.sipBusyUrl.replaceAll("calleeid", targetId);
                        this.event_log.info((Object)("Incoming SIP Call - Channel busy - Redirect to: " + redirect_Url));
                        resp = MessageFactory.createResponse(msg, 302, SipResponses.reasonOf(302), new NameAddress(redirect_Url));
                        ts = new InviteTransactionServer(this, msg, null);
                        ts.respondWith(resp);
                        return;
                    }
                    this.event_log.debug((Object)"Invite Request - Sending busy response (486)");
                    ts = new InviteTransactionServer(this, msg, null);
                    ts.respondWith(MessageFactory.createResponse(msg, 486, SipResponses.reasonOf(486), null));
                    return;
                }
                if (this.listeners.containsKey(SipProvider.ANY)) {
                    this.event_log.debug((Object)("message passed to uas: " + SipProvider.ANY));
                    ((SipProviderListener)this.listeners.get(SipProvider.ANY)).onReceivedMessage(this, msg);
                    return;
                }
                if (msg.isRequest() && (msg.isNotify() || msg.isSubscribe() || msg.isInfo() || msg.isMessage() || msg.isPublish() || msg.isRefer() || msg.isRegister())) {
                    if (msg.isRegister()) {
                        this.event_log.error((Object)("Unhandled REGISTER request received from: " + msg.getRemoteAddress() + ":" + msg.getRemotePort() + " -  message DISCARDED"));
                    }
                    this.event_log.debug((Object)"Notify Request - Sending unsupported response (405)");
                    ts = new TransactionServer(this, msg, null);
                    ts.respondWith(MessageFactory.createResponse(msg, 405, SipResponses.reasonOf(405), null));
                    return;
                }
                try {
                    this.event_log.error((Object)("No SipListener found matching message: " + msg.getMethodId() + " from: " + msg.getRemoteAddress() + ":" + msg.getRemotePort() + " - message DISCARDED"));
                }
                catch (Exception e) {
                    this.event_log.error((Object)("No SipListener found matching message: UNKNOWN from: " + msg.getRemoteAddress() + ":" + msg.getRemotePort() + " - message DISCARDED"));
                }
                this.event_log.debug((Object)("Pending SipProviderListeners= " + this.listeners.size()));
                break block47;
            }
            catch (Exception e) {
                this.event_log.error((Object)"Error handling a new incoming message", (Throwable)e);
                this.std_log.error((Object)"Error handling a new incoming message", (Throwable)e);
                if (this.exception_listeners == null || this.exception_listeners.size() <= 0) break block47;
                i = this.exception_listeners.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    ((SipProviderExceptionListener)i.next()).onMessageException(msg, e);
                }
                catch (Exception e2) {
                    this.event_log.error((Object)"Error handling the Exception", (Throwable)e2);
                }
                continue;
            }
        }
    }

    public void setOPTIONHandler(OptionHandler oh) {
        this.setOPTIONHandler(oh, true);
    }

    public void setOPTIONHandler(OptionHandler oh, boolean requireInviteKey) {
        this.optionHandler = oh;
        this.optionHandlerReqInvKey = requireInviteKey;
    }

    private void addConnection(ConnectedTransport conn) {
        ConnectionIdentifier conn_id = new ConnectionIdentifier(conn);
        if (this.connections.containsKey(conn_id)) {
            this.event_log.debug((Object)("trying to add the already established connection " + conn_id));
            this.event_log.debug((Object)("connection " + conn_id + " will be replaced"));
            ConnectedTransport old_conn = (ConnectedTransport)this.connections.get(conn_id);
            old_conn.halt();
            this.connections.remove(conn_id);
        } else if (this.connections.size() >= this.nmax_connections) {
            this.event_log.debug((Object)"reached the maximum number of connection: removing the older unused connection");
            long older_time = System.currentTimeMillis();
            ConnectionIdentifier older_id = null;
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                ConnectedTransport co = (ConnectedTransport)e.nextElement();
                if (co.getLastTimeMillis() >= older_time) continue;
                older_id = new ConnectionIdentifier(co);
            }
            if (older_id != null) {
                this.removeConnection(older_id);
            }
        }
        this.connections.put(conn_id, conn);
        conn_id = new ConnectionIdentifier(conn);
        conn = (ConnectedTransport)this.connections.get(conn_id);
        this.event_log.debug((Object)"active connenctions:");
        Enumeration e = this.connections.keys();
        while (e.hasMoreElements()) {
            ConnectionIdentifier id = (ConnectionIdentifier)e.nextElement();
            this.event_log.debug((Object)("conn-id=" + id + ": " + ((ConnectedTransport)this.connections.get(id)).toString()));
        }
    }

    private void removeConnection(ConnectionIdentifier conn_id) {
        if (this.connections.containsKey(conn_id)) {
            ConnectedTransport conn = (ConnectedTransport)this.connections.get(conn_id);
            conn.halt();
            this.connections.remove(conn_id);
            this.event_log.debug((Object)"active connenctions:");
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                ConnectedTransport co = (ConnectedTransport)e.nextElement();
                this.event_log.debug((Object)("conn " + co.toString()));
            }
        }
    }

    public void onReceivedMessage(Transport transport, Message msg) {
        this.processReceivedMessage(msg);
    }

    public void onTransportTerminated(Transport transport, Exception error) {
        this.event_log.debug((Object)("transport " + transport + " terminated"));
        if (transport.getProtocol().equals(PROTO_TCP)) {
            ConnectionIdentifier conn_id = new ConnectionIdentifier((ConnectedTransport)transport);
            this.removeConnection(conn_id);
        }
        if (error != null) {
            this.event_log.error((Object)"error", (Throwable)error);
        }
    }

    public void onIncomingConnection(TcpServer tcp_server, TcpSocket socket) {
        this.event_log.debug((Object)("incoming connection from " + socket.getAddress() + ":" + socket.getPort()));
        TcpTransport conn = new TcpTransport(socket, this);
        this.event_log.debug((Object)("tcp connection " + conn + " opened"));
        this.addConnection(conn);
    }

    public void onServerTerminated(TcpServer tcp_server, Exception error) {
        this.event_log.debug((Object)("tcp server " + tcp_server + " terminated"));
    }

    public static String pickBranch() {
        return "z9hG4bK" + Random.nextNumString(5) + breaker++ % 100000L;
    }

    public String pickBranch(Message msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(msg.getRequestLine().getAddress().toString());
        sb.append(String.valueOf(this.getViaAddress()) + this.getPort());
        ViaHeader top_via = msg.getViaHeader();
        if (top_via.hasBranch()) {
            sb.append(top_via.getBranch());
        } else {
            sb.append(String.valueOf(top_via.getHost()) + top_via.getPort());
            sb.append(msg.getCSeqHeader().getSequenceNumber());
            sb.append(msg.getCallIdHeader().getCallId());
            sb.append(msg.getFromHeader().getTag());
            sb.append(msg.getToHeader().getTag());
        }
        return "z9hG4bK" + new SimpleDigest(5, sb.toString()).asHex();
    }

    public static String pickTag() {
        return "z9hG4bK" + Random.nextNumString(8);
    }

    public static String pickTag(Message req) {
        return new SimpleDigest(8, req.toString()).asHex();
    }

    public String pickCallId() {
        return String.valueOf(Random.nextNumString(12)) + "@" + this.getViaAddress();
    }

    public static int pickInitialCSeq() {
        return 1;
    }

    public NameAddress completeNameAddress(String str) {
        if (str.indexOf("<sip:") >= 0) {
            return new NameAddress(str);
        }
        SipURL url = this.completeSipURL(str);
        return new NameAddress(url);
    }

    private SipURL completeSipURL(String str) {
        if (!str.startsWith("sip:") && str.indexOf("@") < 0 && str.indexOf(".") < 0 && str.indexOf(":") < 0) {
            String url = "sip:" + str + "@";
            if (this.outbound_proxy != null) {
                url = String.valueOf(url) + this.outbound_proxy.getAddress().toString();
                int port = this.outbound_proxy.getPort();
                if (port > 0 && port != SipStack.default_port) {
                    url = String.valueOf(url) + ":" + port;
                }
            } else {
                url = String.valueOf(url) + this.via_addr;
                if (this.host_port > 0 && this.host_port != SipStack.default_port) {
                    url = String.valueOf(url) + ":" + this.host_port;
                }
            }
            return new SipURL(url);
        }
        return new SipURL(str);
    }

    public String toString() {
        if (this.host_ipaddr == null) {
            return String.valueOf(this.host_port) + "/" + this.transportProtocolsToString();
        }
        return String.valueOf(this.host_ipaddr.toString()) + ":" + this.host_port + "/" + this.transportProtocolsToString();
    }

    private final void printMessageLog(String proto, String addr, int port, int len, Message msg, String str) {
        if (this.log_all_packets || len >= 12) {
            if (this.message_log.isDebugEnabled()) {
                this.message_log.debug((Object)("\r\n" + this.getPacketTimestamp(proto, addr, port, len, String.valueOf(str) + "\r\n" + msg.toString() + "-----End-of-message-----\r\n")));
            }
            if (this.event_log.isDebugEnabled()) {
                String first_line = msg.getFirstLine();
                first_line = first_line != null ? first_line.trim() : "NOT a SIP message";
                this.event_log.debug((Object)("\r\n" + this.getPacketTimestamp(proto, addr, port, len, String.valueOf(first_line) + ", " + str) + "\r\n"));
            }
        }
    }

    private String getPacketTimestamp(String proto, String remote_addr, int remote_port, int len, String message) {
        String str = String.valueOf(remote_addr) + ":" + remote_port + "/" + proto + " (" + len + " bytes)";
        if (message != null) {
            str = String.valueOf(str) + ": " + message;
        }
        return str;
    }

    public void setPublicIP(String pubIP) {
        if (!(pubIP == null || pubIP.length() <= 0 || this.publicIP != null && this.publicIP.equals(pubIP))) {
            this.publicIP = pubIP;
            this.std_log.info((Object)("PublicIP=" + this.publicIP));
        }
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    private void stunInit() {
        if (this.stunServer != null && this.stunServer.length() > 0) {
            String ip = this.via_addr;
            if (ip.startsWith("127.")) {
                ip = this.via_addr = IpAddress.getLocalHostAddress().toString();
            }
            this.stunClient = new StunClient(this.stunInterval, ip, 0, this.stunServer, this);
        } else if (this.publicIP != null) {
            this.std_log.info((Object)("PublicIP=" + this.publicIP));
        }
    }

    private String makeSafePattern(String srctext) {
        return srctext.replaceAll("\\x5c", "\\\\x5c").replaceAll("\\x28", "\\\\x28").replaceAll("\\x29", "\\\\x29").replaceAll("\\x2a", "\\\\x2a").replaceAll("\\x2e", "\\\\x2e").replaceAll("\\x2d", "\\\\x2d");
    }

    public boolean isIPLocal(InetAddress ip) {
        return ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.isAnyLocalAddress() || ip.isLinkLocalAddress();
    }
}

