/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import org.zoolu.tools.Configure;
import org.zoolu.tools.Parser;
import org.zoolu.tools.Timer;

public class SipStack
extends Configure {
    private static boolean is_init = false;
    public static final String release = "mjsip stack 1.6 sts";
    public static final String authors = "Luca Veltri - University of Parma (Italy)";
    public static int default_port = 5060;
    public static String[] default_transport_protocols = new String[]{"udp", "tcp"};
    public static int default_nmax_connections = 32;
    public static boolean use_rport = true;
    public static boolean force_rport = false;
    public static int max_forwards = 70;
    public static long retransmission_timeout = 500L;
    public static long max_retransmission_timeout = 4000L;
    public static long transaction_timeout = 32000L;
    public static long clearing_timeout = 5000L;
    public static boolean single_timer = false;
    public static boolean early_dialog = false;
    public static int default_expires = 3600;
    public static String ua_info = "mjsip stack 1.6 sts";
    public static String server_info = "mjsip stack 1.6 sts";

    protected void parseLine(String line) {
        Parser par;
        String attribute;
        int index = line.indexOf("=");
        if (index > 0) {
            attribute = line.substring(0, index).trim();
            par = new Parser(line, index + 1);
        } else {
            attribute = line;
            par = new Parser("");
        }
        char[] delim = new char[]{' ', ','};
        if (attribute.equals("default_port")) {
            default_port = par.getInt();
            return;
        }
        if (attribute.equals("default_transport_protocols")) {
            default_transport_protocols = par.getWordArray(delim);
            return;
        }
        if (attribute.equals("default_nmax_connections")) {
            default_nmax_connections = par.getInt();
            return;
        }
        if (attribute.equals("use_rport")) {
            use_rport = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("force_rport")) {
            force_rport = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("max_forwards")) {
            max_forwards = par.getInt();
            return;
        }
        if (attribute.equals("retransmission_timeout")) {
            retransmission_timeout = par.getInt();
            return;
        }
        if (attribute.equals("max_retransmission_timeout")) {
            max_retransmission_timeout = par.getInt();
            return;
        }
        if (attribute.equals("transaction_timeout")) {
            transaction_timeout = par.getInt();
            return;
        }
        if (attribute.equals("clearing_timeout")) {
            clearing_timeout = par.getInt();
            return;
        }
        if (attribute.equals("single_timer")) {
            single_timer = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("early_dialog")) {
            early_dialog = par.getString().toLowerCase().startsWith("y");
            return;
        }
        if (attribute.equals("default_expires")) {
            default_expires = par.getInt();
            return;
        }
        if (attribute.equals("ua_info")) {
            ua_info = par.getRemainingString().trim();
            return;
        }
        if (attribute.equals("server_info")) {
            server_info = par.getRemainingString().trim();
            return;
        }
        if (attribute.equals("host_addr")) {
            SipStack.printLog("WARNING: parameter 'host_addr' is no more supported; use 'via_addr' instead.");
        }
        if (attribute.equals("all_interfaces")) {
            SipStack.printLog("WARNING: parameter 'all_interfaces' is no more supported; use 'host_iaddr' for setting a specific interface or let it undefined.");
        }
        if (attribute.equals("use_outbound")) {
            SipStack.printLog("WARNING: parameter 'use_outbound' is no more supported; use 'outbound_addr' for setting an outbound proxy or let it undefined.");
        }
        if (attribute.equals("log_file")) {
            SipStack.printLog("WARNING: parameter 'log_file' is no more supported.");
        }
    }

    protected String toLines() {
        return "SipStack/mjsip stack 1.6 sts";
    }

    private SipStack() {
    }

    public static void init() {
        SipStack.init(null);
    }

    public static void init(String file) {
        new SipStack().loadFile(file);
        if (ua_info != null && (ua_info.length() == 0 || ua_info.equalsIgnoreCase(Configure.NONE) || ua_info.equalsIgnoreCase("NO-UA-INFO"))) {
            ua_info = null;
        }
        if (server_info != null && (server_info.length() == 0 || server_info.equalsIgnoreCase(Configure.NONE) || server_info.equalsIgnoreCase("NO-SERVER-INFO"))) {
            server_info = null;
        }
        Timer.SINGLE_THREAD = single_timer;
        is_init = true;
    }

    public static boolean isInit() {
        return is_init;
    }

    private static void printLog(String str) {
        System.out.println("SipStack: " + str);
    }
}

