/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpcHashtable
extends Hashtable<Object, Object> {
    static final long serialVersionUID = 2423442L;
    Hashtable dupeKeysList = null;

    SpcHashtable(Hashtable dupeKeys) {
        this.dupeKeysList = dupeKeys != null ? dupeKeys : new Hashtable();
    }

    @Override
    public synchronized Object put(Object key, Object val) {
        if (this.dupeKeysList.containsKey(key)) {
            Hashtable vect = null;
            if (this.containsKey(key)) {
                vect = (Hashtable)super.get(key);
                vect.put(val.hashCode(), val);
            } else {
                vect = new Hashtable();
                vect.put(val.hashCode(), val);
            }
            return super.put(key, vect);
        }
        return super.put(key, val);
    }

    @Override
    public synchronized Object get(Object key) {
        if (this.dupeKeysList.containsKey(key)) {
            Hashtable vect = (Hashtable)super.get(key);
            if (vect == null || vect.isEmpty()) {
                return null;
            }
            return vect.get(vect.keys().nextElement());
        }
        return super.get(key);
    }

    public synchronized Object get(Object key, Object val) {
        if (this.dupeKeysList.containsKey(key)) {
            Hashtable vect = (Hashtable)super.get(key);
            if (vect == null) {
                return null;
            }
            return vect.get(val.hashCode());
        }
        if (super.get(key) == val) {
            return super.get(key);
        }
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        if (this.dupeKeysList.containsKey(key)) {
            Hashtable vect = (Hashtable)super.get(key);
            if (vect == null || vect.isEmpty()) {
                return null;
            }
            Object retVal = vect.remove(vect.keys().nextElement());
            if (vect.size() == 0) {
                super.remove(key);
            }
            return retVal;
        }
        return super.remove(key);
    }

    public synchronized boolean containsPair(Object key, Object val) {
        Hashtable vect;
        return this.dupeKeysList.containsKey(key) ? (vect = (Hashtable)super.get(key)) != null && vect.containsKey(val.hashCode()) : super.containsKey(key) && super.get(key) == val;
    }

    public synchronized boolean removePair(Object key, Object val) {
        if (this.dupeKeysList.containsKey(key)) {
            Hashtable vect = (Hashtable)super.get(key);
            if (vect != null && vect.containsKey(val.hashCode())) {
                vect.remove(val.hashCode());
                if (vect.size() == 0) {
                    super.remove(key);
                }
                return true;
            }
        } else if (super.containsKey(key) && super.get(key) == val) {
            super.remove(key);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Hashtable<StringBuffer, String> dupeKeys = new Hashtable<StringBuffer, String>();
        StringBuffer dupeKey = new StringBuffer("DupeKey");
        StringBuffer regKey = new StringBuffer("RegKey");
        dupeKeys.put(dupeKey, "");
        SpcHashtable myHash = new SpcHashtable(dupeKeys);
        StringBuffer[] ps = new StringBuffer[5];
        int o = 0;
        while (o < 5) {
            ps[o] = new StringBuffer(String.valueOf(o) + ":dssfdfsd");
            ++o;
        }
        o = 0;
        while (o < ps.length) {
            myHash.put(dupeKey, ps[o]);
            ++o;
        }
        myHash.put(regKey, new StringBuffer("stuff"));
        System.out.println(myHash.toString());
        System.out.println("hashsize=" + myHash.size());
        System.out.println("hasdupekey=" + myHash.containsKey(dupeKey));
        System.out.println("hasregkey=" + myHash.containsKey(regKey));
        System.out.println("");
        StringBuffer gtps = (StringBuffer)myHash.get(dupeKey);
        System.out.println("gtps=" + gtps);
        System.out.println("");
        System.out.println("getPair3=" + myHash.get(dupeKey, ps[3]));
        System.out.println("removePair3=" + myHash.removePair(dupeKey, ps[3]));
        System.out.println("getPair3=" + myHash.get(dupeKey, ps[3]));
        System.out.println("");
        myHash.remove(dupeKey);
        System.out.println("removedAPair");
        System.out.println(myHash.toString());
        int o2 = 0;
        while (o2 < ps.length) {
            System.out.println("---------------");
            StringBuffer tps = (StringBuffer)myHash.get(dupeKey);
            System.out.println("ps=" + tps);
            System.out.println("removePair" + o2 + "=" + myHash.removePair(dupeKey, ps[o2]));
            System.out.println("hasdupekey=" + myHash.containsKey(dupeKey));
            ++o2;
        }
        System.out.println("");
        System.out.println(myHash.toString());
        System.out.println("hashsize=" + myHash.size());
        System.out.println("getRegKey=" + myHash.get(regKey).toString());
        System.out.println("hasregkey=" + myHash.containsKey(regKey));
    }
}

