/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.zoolu.sip.provider.SipProvider;

public class StunClient
extends Thread {
    private int intervalMinutes = 0;
    private static Logger log = null;
    private static boolean bigEndian = true;
    private static SipProvider sip_provider = null;
    private String localIp;
    private int localPort;
    private boolean stopNow = false;
    private String[] stunServers = null;

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"log.properties");
        StunClient sc = new StunClient(1, "192.168.0.4", 0, "stunserver.org:3478,stun01.sipphone.com:3478", null);
    }

    StunClient(int argIntervalMinutes, String argLocalIp, int argLocalPort, String arg_stun_server, SipProvider arg_sip_provider) {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.intervalMinutes = argIntervalMinutes;
        this.localIp = argLocalIp;
        this.localPort = argLocalPort;
        this.stunServers = arg_stun_server.split(",");
        sip_provider = arg_sip_provider;
        log = Logger.getLogger((String)this.getName());
        this.start();
    }

    public void halt() {
        this.stopNow = true;
    }

    public void run() {
        try {
            while (!this.stopNow) {
                int s = 0;
                while (s < this.stunServers.length) {
                    log.debug((Object)("STUN: Server: " + this.stunServers[s]));
                    String[] stunParms = this.stunServers[s].split(":");
                    String stun_server = stunParms[0].trim();
                    int stun_port = stunParms.length > 1 ? Integer.parseInt(stunParms[1].trim()) : 3478;
                    String pubIp = this.getPubIp(this.localIp, this.localPort, stun_server, stun_port);
                    if (pubIp != null && pubIp.length() > 0) {
                        if (sip_provider == null) break;
                        sip_provider.setPublicIP(pubIp);
                        break;
                    }
                    ++s;
                }
                if (this.intervalMinutes > 0) {
                    int cnt = 0;
                    while (!StunClient.interrupted() && cnt < this.intervalMinutes) {
                        if (this.stopNow) {
                            return;
                        }
                        StunClient.sleep(60000L);
                        ++cnt;
                    }
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String getPubIp(String iaddress, int localPort, String stunServer, int stun_port) {
        String retvar = "";
        int timeSinceFirstTransmission = 0;
        int timeout = 300;
        DatagramSocket stunSocket = null;
        InetAddress stunInet = null;
        try {
            stunInet = InetAddress.getByName(stunServer);
        }
        catch (UnknownHostException eh) {
            log.info((Object)("STUN: Error - Unknown Host: " + stunServer));
            return "";
        }
        catch (Exception e) {
            log.info((Object)"STUN: Error", (Throwable)e);
            return "";
        }
        while (true) {
            try {
                stunSocket = new DatagramSocket(new InetSocketAddress(iaddress, localPort));
                stunSocket.setReuseAddress(true);
                stunSocket.connect(stunInet, stun_port);
                stunSocket.setSoTimeout(timeout);
                int reqlen = 28;
                byte[] msgHdr = new byte[reqlen];
                msgHdr[1] = 1;
                msgHdr[3] = 8;
                byte[] transId = this.genTransId();
                int x = 0;
                while (x < transId.length) {
                    msgHdr[x + 4] = transId[x];
                    ++x;
                }
                byte[] byArray = new byte[8];
                byArray[1] = 3;
                byArray[3] = 4;
                byte[] chgreq = byArray;
                int x2 = 0;
                while (x2 < chgreq.length) {
                    msgHdr[x2 + 20] = chgreq[x2];
                    ++x2;
                }
                DatagramPacket send = new DatagramPacket(msgHdr, msgHdr.length);
                stunSocket.send(send);
                log.debug((Object)"STUN: Bind request sent");
                byte[] rx = new byte[200];
                int wait = 0;
                boolean gotResponse = false;
                while (wait++ < 10) {
                    DatagramPacket receive = new DatagramPacket(rx, 200);
                    stunSocket.receive(receive);
                    if (StunClient.getInt(rx, 0) != 257 || !this.testTransID(rx, transId)) continue;
                    gotResponse = true;
                    log.debug((Object)"STUN: Bind response received");
                    break;
                }
                stunSocket.close();
                if (!gotResponse) break;
                retvar = this.extractIP(rx);
            }
            catch (SocketTimeoutException ste) {
                int timeoutAddValue22;
                if (timeSinceFirstTransmission < 7900) {
                    log.debug((Object)"STUN: timeout while receiving the response.");
                    timeoutAddValue22 = (timeSinceFirstTransmission += timeout) * 2;
                    if (timeoutAddValue22 > 1600) {
                        timeoutAddValue22 = 1600;
                    }
                } else {
                    log.error((Object)"STUN: No Response.");
                    break;
                }
                timeout = timeoutAddValue22;
                try {
                    if (stunSocket == null) continue;
                    stunSocket.close();
                }
                catch (Exception timeoutAddValue22) {}
                continue;
            }
            catch (BindException be) {
                if (be.getMessage().contains("Address already in use")) {
                    if (timeSinceFirstTransmission < 7900) {
                        try {
                            StunClient.sleep(timeout);
                        }
                        catch (Exception timeoutAddValue22) {
                            // empty catch block
                        }
                        int timeoutAddValue = (timeSinceFirstTransmission += timeout) * 2;
                        if (timeoutAddValue > 1600) {
                            timeoutAddValue = 1600;
                        }
                        timeout = timeoutAddValue;
                        log.debug((Object)"error:", (Throwable)be);
                        continue;
                    }
                    log.error((Object)"STUN: No Response.");
                    break;
                }
                log.error((Object)"error:", (Throwable)be);
                continue;
            }
            catch (Exception e) {
                log.error((Object)"error:", (Throwable)e);
                continue;
            }
            break;
        }
        return retvar;
    }

    private boolean testTransID(byte[] id, byte[] idHdrTransId) {
        int x = 0;
        while (x < 16) {
            if (id[x + 4] != idHdrTransId[x]) {
                return false;
            }
            ++x;
        }
        return true;
    }

    private byte[] genTransId() {
        byte[] id = new byte[16];
        int x = 0;
        while (x < 16) {
            id[x] = (byte)(Math.random() * 255.0);
            ++x;
        }
        return id;
    }

    private String extractIP(byte[] msg) {
        String retvar = null;
        int offset = 20;
        int msgLen = StunClient.getInt(msg, offset) & 0xFFFF;
        while (msgLen > 0) {
            int type = StunClient.getInt(msg, offset) & 0xFFFF;
            int attribLen = StunClient.getInt(msg, offset + 2) & 0xFFFF;
            if (type == 1) {
                byte family = msg[offset + 5];
                if (family == 1) {
                    int port = StunClient.getInt(msg, offset + 6) & 0xFFFF;
                    int firstOctet = msg[offset + 8] & 0xFF;
                    int secondOctet = msg[offset + 9] & 0xFF;
                    int thirdOctet = msg[offset + 10] & 0xFF;
                    int fourthOctet = msg[offset + 11] & 0xFF;
                    retvar = String.valueOf(firstOctet) + "." + secondOctet + "." + thirdOctet + "." + fourthOctet;
                    log.debug((Object)("addr=" + retvar + ":" + port));
                    break;
                }
                log.debug((Object)"STUN: Unsupported Address family");
                break;
            }
            msgLen -= attribLen;
            offset += attribLen;
        }
        return retvar;
    }

    private static int getInt(byte[] buffer, int byteOffset) {
        return bigEndian ? buffer[byteOffset] << 8 | buffer[byteOffset + 1] & 0xFF : buffer[byteOffset + 1] << 8 | buffer[byteOffset] & 0xFF;
    }
}

