/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import java.io.IOException;
import org.zoolu.net.IpAddress;
import org.zoolu.net.TcpConnection;
import org.zoolu.net.TcpConnectionListener;
import org.zoolu.net.TcpSocket;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.ConnectedTransport;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.SipParser;
import org.zoolu.sip.provider.TransportListener;

class TcpTransport
implements ConnectedTransport,
TcpConnectionListener {
    public static final String PROTO_TCP = "tcp";
    TcpConnection tcp_conn;
    ConnectionIdentifier connection_id;
    long last_time;
    String text;
    TransportListener listener;

    public TcpTransport(IpAddress remote_ipaddr, int remote_port, TransportListener listener) throws IOException {
        this.listener = listener;
        TcpSocket socket = new TcpSocket(remote_ipaddr, remote_port);
        this.tcp_conn = new TcpConnection(socket, this);
        this.connection_id = new ConnectionIdentifier(this);
        this.last_time = System.currentTimeMillis();
        this.text = "";
    }

    public TcpTransport(TcpSocket socket, TransportListener listener) {
        this.listener = listener;
        this.tcp_conn = new TcpConnection(socket, this);
        this.connection_id = null;
        this.last_time = System.currentTimeMillis();
        this.text = "";
    }

    public String getProtocol() {
        return PROTO_TCP;
    }

    public IpAddress getRemoteAddress() {
        if (this.tcp_conn != null) {
            return this.tcp_conn.getRemoteAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.tcp_conn != null) {
            return this.tcp_conn.getRemotePort();
        }
        return 0;
    }

    public long getLastTimeMillis() {
        return this.last_time;
    }

    public void sendMessage(Message msg, IpAddress dest_ipaddr, int dest_port) throws IOException {
        this.sendMessage(msg);
    }

    public void sendMessage(Message msg) throws IOException {
        if (this.tcp_conn != null) {
            this.last_time = System.currentTimeMillis();
            byte[] data = msg.toString().getBytes();
            this.tcp_conn.send(data);
        }
    }

    public void halt() {
        if (this.tcp_conn != null) {
            this.tcp_conn.halt();
        }
    }

    public String toString() {
        if (this.tcp_conn != null) {
            return this.tcp_conn.toString();
        }
        return null;
    }

    public void onReceivedData(TcpConnection tcp_conn, byte[] data, int len) {
        this.last_time = System.currentTimeMillis();
        this.text = String.valueOf(this.text) + new String(data, 0, len);
        SipParser par = new SipParser(this.text);
        Message msg = par.getSipMessage();
        while (msg != null) {
            msg.setRemoteAddress(tcp_conn.getRemoteAddress().toString());
            msg.setRemotePort(tcp_conn.getRemotePort());
            msg.setTransport(PROTO_TCP);
            msg.setConnectionId(this.connection_id);
            if (this.listener != null) {
                this.listener.onReceivedMessage(this, msg);
            }
            this.text = par.getRemainingString();
            par = new SipParser(this.text);
            msg = par.getSipMessage();
        }
    }

    public void onConnectionTerminated(TcpConnection tcp_conn, Exception error) {
        TcpSocket socket;
        if (this.listener != null) {
            this.listener.onTransportTerminated(this, error);
        }
        if ((socket = tcp_conn.getSocket()) != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tcp_conn = null;
        this.listener = null;
    }
}

