/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.provider;

import java.io.IOException;
import org.zoolu.net.IpAddress;
import org.zoolu.net.UdpPacket;
import org.zoolu.net.UdpProvider;
import org.zoolu.net.UdpProviderListener;
import org.zoolu.net.UdpSocket;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.Transport;
import org.zoolu.sip.provider.TransportListener;

class UdpTransport
implements Transport,
UdpProviderListener {
    public static final String PROTO_UDP = "udp";
    UdpProvider udp_provider;
    String proto;
    TransportListener listener;

    public UdpTransport(int port, TransportListener listener) throws IOException {
        this.listener = listener;
        UdpSocket socket = new UdpSocket(port);
        this.udp_provider = new UdpProvider(socket, this);
    }

    public UdpTransport(int port, IpAddress ipaddr, TransportListener listener) throws IOException {
        this.listener = listener;
        UdpSocket socket = new UdpSocket(port, ipaddr);
        this.udp_provider = new UdpProvider(socket, this);
    }

    public UdpTransport(UdpSocket socket, TransportListener listener) {
        this.listener = listener;
        this.udp_provider = new UdpProvider(socket, this);
    }

    public String getProtocol() {
        return PROTO_UDP;
    }

    public void sendMessage(Message msg, IpAddress dest_ipaddr, int dest_port) throws IOException {
        if (this.udp_provider != null) {
            byte[] data = msg.toString().getBytes();
            UdpPacket packet = new UdpPacket(data, data.length);
            packet.setIpAddress(dest_ipaddr);
            packet.setPort(dest_port);
            this.udp_provider.send(packet);
        }
    }

    public void halt() {
        if (this.udp_provider != null) {
            this.udp_provider.halt();
        }
    }

    public String toString() {
        if (this.udp_provider != null) {
            return this.udp_provider.toString();
        }
        return null;
    }

    public void onReceivedPacket(UdpProvider udp, UdpPacket packet) {
        Message msg = new Message(packet);
        msg.setRemoteAddress(packet.getIpAddress().toString());
        msg.setRemotePort(packet.getPort());
        msg.setTransport(PROTO_UDP);
        if (this.listener != null) {
            this.listener.onReceivedMessage(this, msg);
        }
    }

    public void onServiceTerminated(UdpProvider udp, Exception error) {
        UdpSocket socket;
        if (this.listener != null) {
            this.listener.onTransportTerminated(this, error);
        }
        if ((socket = udp.getUdpSocket()) != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.udp_provider = null;
        this.listener = null;
    }
}

