/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.transaction;

import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;
import org.zoolu.sip.provider.TransactionIdentifier;
import org.zoolu.sip.transaction.AckTransactionServerListener;
import org.zoolu.sip.transaction.Transaction;
import org.zoolu.tools.Timer;

public class AckTransactionServer
extends Transaction {
    AckTransactionServerListener transaction_listener;
    Message response;
    Timer retransmission_to;
    Timer transaction_to;

    public AckTransactionServer(SipProvider sip_provider, Message resp, AckTransactionServerListener listener) {
        super(sip_provider);
        this.response = resp;
        this.init(listener, new TransactionIdentifier("ACK"), null);
    }

    public AckTransactionServer(SipProvider sip_provider, ConnectionIdentifier connection_id, Message resp, AckTransactionServerListener listener) {
        super(sip_provider);
        this.response = resp;
        this.init(listener, new TransactionIdentifier("ACK"), connection_id);
    }

    void init(AckTransactionServerListener listener, TransactionIdentifier transaction_id, ConnectionIdentifier connaction_id) {
        this.transaction_listener = listener;
        this.transaction_id = transaction_id;
        this.connection_id = this.connection_id;
        this.transaction_to = new Timer(SipStack.transaction_timeout, "Transaction", this);
        this.retransmission_to = new Timer(SipStack.retransmission_timeout, "Retransmission", this);
        this.log.debug((Object)("id: " + String.valueOf(transaction_id)));
        this.log.debug((Object)"created");
    }

    public void respond() {
        this.log.debug((Object)"start");
        this.changeStatus(3);
        this.transaction_to.start();
        if (this.connection_id == null) {
            this.retransmission_to.start();
        }
        this.sip_provider.sendMessage(this.response, this.connection_id);
    }

    public void onTimeout(Timer to) {
        try {
            if (to.equals(this.retransmission_to) && this.statusIs(3)) {
                this.log.debug((Object)"Retransmission timeout expired");
                long timeout = 2L * this.retransmission_to.getTime();
                if (timeout > SipStack.max_retransmission_timeout) {
                    timeout = SipStack.max_retransmission_timeout;
                }
                this.retransmission_to = new Timer(timeout, this.retransmission_to.getLabel(), this);
                this.retransmission_to.start();
                this.sip_provider.sendMessage(this.response, this.connection_id);
            }
            if (to.equals(this.transaction_to) && this.statusIs(3)) {
                this.log.debug((Object)"Transaction timeout expired");
                this.changeStatus(7);
                if (this.transaction_listener != null) {
                    this.transaction_listener.onTransAckTimeout(this);
                }
                this.transaction_listener = null;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"error", (Throwable)e);
        }
    }

    public void terminate() {
        this.retransmission_to.halt();
        this.transaction_to.halt();
        this.changeStatus(7);
        this.transaction_listener = null;
    }
}

