/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.transaction;

import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.MessageFactory;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.Identifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;
import org.zoolu.sip.provider.TransactionIdentifier;
import org.zoolu.sip.transaction.InviteTransactionServerListener;
import org.zoolu.sip.transaction.TransactionServer;
import org.zoolu.tools.Timer;

public class InviteTransactionServer
extends TransactionServer {
    public static boolean AUTO_TRYING = true;
    InviteTransactionServerListener transaction_listener;
    Timer retransmission_to;
    Timer end_to;
    boolean auto_trying;

    public InviteTransactionServer(SipProvider sip_provider, InviteTransactionServerListener listener) {
        super(sip_provider);
        this.init(listener, new TransactionIdentifier("INVITE"), null);
    }

    public InviteTransactionServer(SipProvider sip_provider, Message invite, InviteTransactionServerListener listener) {
        super(sip_provider);
        this.request = new Message(invite);
        this.init(listener, this.request.getTransactionId(), this.request.getConnectionId());
        this.changeStatus(2);
        sip_provider.addSipProviderListener(this.transaction_id, this);
        if (this.auto_trying) {
            Message trying100 = MessageFactory.createResponse(this.request, 100, SipResponses.reasonOf(100), null);
            this.respondWith(trying100);
        }
    }

    public InviteTransactionServer(SipProvider sip_provider, Message invite, boolean auto_trying, InviteTransactionServerListener listener) {
        super(sip_provider);
        this.request = new Message(invite);
        this.init(listener, this.request.getTransactionId(), this.request.getConnectionId());
        this.auto_trying = auto_trying;
        this.changeStatus(2);
        sip_provider.addSipProviderListener(this.transaction_id, this);
        if (auto_trying) {
            Message trying100 = MessageFactory.createResponse(this.request, 100, SipResponses.reasonOf(100), null);
            this.respondWith(trying100);
        }
    }

    void init(InviteTransactionServerListener listener, TransactionIdentifier transaction_id, ConnectionIdentifier connaction_id) {
        this.transaction_listener = listener;
        this.transaction_id = transaction_id;
        this.connection_id = this.connection_id;
        this.auto_trying = AUTO_TRYING;
        this.retransmission_to = new Timer(SipStack.retransmission_timeout, "Retransmission", this);
        this.end_to = new Timer(SipStack.transaction_timeout, "End", this);
        this.clearing_to = new Timer(SipStack.clearing_timeout, "Clearing", this);
        this.log.debug((Object)("id: " + String.valueOf(transaction_id)));
        this.log.debug((Object)"created");
    }

    public void setAutoTrying(boolean auto_trying) {
        this.auto_trying = auto_trying;
    }

    public void listen() {
        this.log.debug((Object)"start");
        if (this.statusIs(0)) {
            this.changeStatus(1);
            this.sip_provider.addSipProviderListener(new TransactionIdentifier("INVITE"), this);
        }
    }

    public void respondWith(Message resp) {
        this.response = resp;
        int code = this.response.getStatusLine().getCode();
        if (this.statusIs(2) || this.statusIs(3)) {
            this.sip_provider.sendMessage(this.response, this.connection_id);
        }
        if (code >= 100 && code < 200 && this.statusIs(2)) {
            this.changeStatus(3);
            return;
        }
        if (code >= 200 && code < 300 && (this.statusIs(2) || this.statusIs(3))) {
            this.sip_provider.removeSipProviderListener(this.transaction_id);
            this.changeStatus(7);
            this.transaction_listener = null;
            return;
        }
        if (code >= 300 && code < 700 && (this.statusIs(2) || this.statusIs(3))) {
            this.changeStatus(4);
            if (this.connection_id == null) {
                this.retransmission_to.start();
                this.end_to.start();
            } else {
                this.log.debug((Object)("No retransmissions for reliable transport (" + this.connection_id + ")"));
                this.onTimeout(this.end_to);
            }
        }
    }

    public void onReceivedMessage(SipProvider provider, Message msg) {
        if (msg.isRequest()) {
            String req_method = msg.getRequestLine().getMethod();
            if (req_method.equals("INVITE")) {
                if (this.statusIs(1)) {
                    this.request = new Message(msg);
                    this.connection_id = this.request.getConnectionId();
                    this.transaction_id = this.request.getTransactionId();
                    this.sip_provider.addSipProviderListener(this.transaction_id, this);
                    this.sip_provider.removeSipProviderListener(new Identifier("INVITE"), this);
                    this.changeStatus(2);
                    if (this.auto_trying) {
                        Message trying100 = MessageFactory.createResponse(this.request, 100, SipResponses.reasonOf(100), null);
                        this.respondWith(trying100);
                    }
                    if (this.transaction_listener != null) {
                        this.transaction_listener.onTransRequest(this, msg);
                    }
                    return;
                }
                if (this.statusIs(3) || this.statusIs(4)) {
                    this.sip_provider.sendMessage(this.response, this.connection_id);
                    return;
                }
            }
            if (req_method.equals("ACK") && this.statusIs(4)) {
                this.retransmission_to.halt();
                this.end_to.halt();
                this.changeStatus(5);
                if (this.transaction_listener != null) {
                    this.transaction_listener.onTransFailureAck(this, msg);
                }
                this.clearing_to.start();
                return;
            }
        }
    }

    public void onTimeout(Timer to) {
        try {
            if (to.equals(this.retransmission_to) && this.statusIs(4)) {
                this.log.debug((Object)"Retransmission timeout expired");
                long timeout = 2L * this.retransmission_to.getTime();
                if (timeout > SipStack.max_retransmission_timeout) {
                    timeout = SipStack.max_retransmission_timeout;
                }
                this.retransmission_to = new Timer(timeout, this.retransmission_to.getLabel(), this);
                this.retransmission_to.start();
                this.sip_provider.sendMessage(this.response, this.connection_id);
            }
            if (to.equals(this.end_to) && this.statusIs(4)) {
                this.log.debug((Object)"End timeout expired");
                this.retransmission_to.halt();
                this.sip_provider.removeSipProviderListener(this.transaction_id);
                this.changeStatus(7);
                this.transaction_listener = null;
            }
            if (to.equals(this.clearing_to) && this.statusIs(5)) {
                this.log.debug((Object)"Clearing timeout expired");
                this.sip_provider.removeSipProviderListener(this.transaction_id);
                this.changeStatus(7);
                this.transaction_listener = null;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"error", (Throwable)e);
        }
    }

    public void terminate() {
        this.retransmission_to.halt();
        this.clearing_to.halt();
        this.end_to.halt();
        if (this.statusIs(2)) {
            this.sip_provider.removeSipProviderListener(new TransactionIdentifier("INVITE"));
        } else {
            this.sip_provider.removeSipProviderListener(this.transaction_id);
        }
        this.changeStatus(7);
        this.transaction_listener = null;
    }
}

