/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.transaction;

import org.apache.log4j.Logger;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipProviderListener;
import org.zoolu.sip.provider.TransactionIdentifier;
import org.zoolu.tools.Timer;
import org.zoolu.tools.TimerListener;

public abstract class Transaction
implements SipProviderListener,
TimerListener {
    protected static int transaction_counter = 0;
    static final int STATE_IDLE = 0;
    static final int STATE_WAITING = 1;
    static final int STATE_TRYING = 2;
    static final int STATE_PROCEEDING = 3;
    static final int STATE_COMPLETED = 4;
    static final int STATE_CONFIRMED = 5;
    static final int STATE_TERMINATED = 7;
    int transaction_sqn;
    Logger log = Logger.getLogger(this.getClass());
    SipProvider sip_provider;
    int status;
    Message request;
    TransactionIdentifier transaction_id;
    ConnectionIdentifier connection_id;

    static String getStatus(int st) {
        switch (st) {
            case 0: {
                return "T_Idle";
            }
            case 1: {
                return "T_Waiting";
            }
            case 2: {
                return "T_Trying";
            }
            case 3: {
                return "T_Proceeding";
            }
            case 4: {
                return "T_Completed";
            }
            case 5: {
                return "T_Confirmed";
            }
            case 7: {
                return "T_Terminated";
            }
        }
        return null;
    }

    protected Transaction(SipProvider sip_provider) {
        this.sip_provider = sip_provider;
        this.transaction_id = null;
        this.request = null;
        this.connection_id = null;
        this.transaction_sqn = transaction_counter++;
        this.status = 0;
    }

    void changeStatus(int newstatus) {
        this.status = newstatus;
        this.log.debug((Object)("changed transaction state: " + this.getStatus()));
    }

    boolean statusIs(int st) {
        return this.status == st;
    }

    String getStatus() {
        return Transaction.getStatus(this.status);
    }

    public SipProvider getSipProvider() {
        return this.sip_provider;
    }

    public Message getRequestMessage() {
        return this.request;
    }

    public String getTransactionMethod() {
        return this.request.getTransactionMethod();
    }

    public TransactionIdentifier getTransactionId() {
        return this.transaction_id;
    }

    public ConnectionIdentifier getConnectionId() {
        return this.connection_id;
    }

    public void onReceivedMessage(SipProvider provider, Message msg) {
    }

    public void onTimeout(Timer to) {
    }

    public abstract void terminate();
}

