/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.transaction;

import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;
import org.zoolu.sip.provider.TransactionIdentifier;
import org.zoolu.sip.transaction.Transaction;
import org.zoolu.sip.transaction.TransactionClientListener;
import org.zoolu.tools.Timer;

public class TransactionClient
extends Transaction {
    TransactionClientListener transaction_listener;
    Timer retransmission_to;
    Timer transaction_to;
    Timer clearing_to;

    protected TransactionClient(SipProvider sip_provider) {
        super(sip_provider);
        this.transaction_listener = null;
    }

    public TransactionClient(SipProvider sip_provider, Message req, TransactionClientListener listener) {
        super(sip_provider);
        this.request = new Message(req);
        this.init(listener, this.request.getTransactionId());
    }

    void init(TransactionClientListener listener, TransactionIdentifier transaction_id) {
        this.transaction_listener = listener;
        this.transaction_id = transaction_id;
        this.retransmission_to = new Timer(SipStack.retransmission_timeout, "Retransmission", this);
        this.transaction_to = new Timer(SipStack.transaction_timeout, "Transaction", this);
        this.clearing_to = new Timer(SipStack.clearing_timeout, "Clearing", this);
        this.log.debug((Object)("id: " + String.valueOf(transaction_id)));
        this.log.debug((Object)"created");
    }

    public void request() {
        this.log.debug((Object)"start");
        this.changeStatus(2);
        this.retransmission_to.start();
        this.transaction_to.start();
        this.sip_provider.addSipProviderListener(this.transaction_id, this);
        this.connection_id = this.sip_provider.sendMessage(this.request);
    }

    public void onReceivedMessage(SipProvider provider, Message msg) {
        if (msg.isResponse()) {
            int code = msg.getStatusLine().getCode();
            if (code >= 100 && code < 200 && (this.statusIs(2) || this.statusIs(3))) {
                if (this.statusIs(2)) {
                    this.changeStatus(3);
                }
                if (this.transaction_listener != null) {
                    this.transaction_listener.onTransProvisionalResponse(this, msg);
                }
                return;
            }
            if (code >= 200 && code < 700 && (this.statusIs(2) || this.statusIs(3))) {
                this.retransmission_to.halt();
                this.transaction_to.halt();
                this.changeStatus(4);
                if (code < 300) {
                    if (this.transaction_listener != null) {
                        this.transaction_listener.onTransSuccessResponse(this, msg);
                    }
                } else if (this.transaction_listener != null) {
                    this.transaction_listener.onTransFailureResponse(this, msg);
                }
                this.transaction_listener = null;
                if (this.connection_id == null) {
                    this.clearing_to.start();
                } else {
                    this.log.debug((Object)"clearing_to=0 for reliable transport");
                    this.onTimeout(this.clearing_to);
                }
                return;
            }
        }
    }

    public void onTimeout(Timer to) {
        try {
            if (to.equals(this.retransmission_to) && (this.statusIs(2) || this.statusIs(3))) {
                this.log.debug((Object)"Retransmission timeout expired");
                if (this.connection_id == null) {
                    this.sip_provider.sendMessage(this.request);
                    long timeout = 2L * this.retransmission_to.getTime();
                    if (timeout > SipStack.max_retransmission_timeout || this.statusIs(3)) {
                        timeout = SipStack.max_retransmission_timeout;
                    }
                    this.retransmission_to = new Timer(timeout, this.retransmission_to.getLabel(), this);
                    this.retransmission_to.start();
                } else {
                    this.log.debug((Object)("No retransmissions for reliable transport (" + this.connection_id + ")"));
                }
            }
            if (to.equals(this.transaction_to)) {
                this.log.debug((Object)"Transaction timeout expired");
                this.retransmission_to.halt();
                this.clearing_to.halt();
                this.sip_provider.removeSipProviderListener(this.transaction_id);
                this.changeStatus(7);
                if (this.transaction_listener != null) {
                    this.transaction_listener.onTransTimeout(this);
                }
                this.transaction_listener = null;
            }
            if (to.equals(this.clearing_to)) {
                this.log.debug((Object)"Clearing timeout expired");
                this.retransmission_to.halt();
                this.transaction_to.halt();
                this.sip_provider.removeSipProviderListener(this.transaction_id);
                this.changeStatus(7);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"error", (Throwable)e);
        }
    }

    public void terminate() {
        if (!this.statusIs(7)) {
            this.retransmission_to.halt();
            this.transaction_to.halt();
            this.clearing_to.halt();
            this.sip_provider.removeSipProviderListener(this.transaction_id);
            this.changeStatus(7);
            this.transaction_listener = null;
        }
    }
}

