/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.transaction;

import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;
import org.zoolu.sip.provider.TransactionIdentifier;
import org.zoolu.sip.transaction.Transaction;
import org.zoolu.sip.transaction.TransactionServerListener;
import org.zoolu.tools.Timer;

public class TransactionServer
extends Transaction {
    TransactionServerListener transaction_listener;
    Message response;
    Timer clearing_to;

    protected TransactionServer(SipProvider sip_provider) {
        super(sip_provider);
        this.transaction_listener = null;
        this.response = null;
    }

    public TransactionServer(SipProvider sip_provider, String method, TransactionServerListener listener) {
        super(sip_provider);
        this.init(listener, new TransactionIdentifier(method), null);
    }

    public TransactionServer(SipProvider provider, Message req, TransactionServerListener listener) {
        super(provider);
        this.request = new Message(req);
        this.init(listener, this.request.getTransactionId(), this.request.getConnectionId());
        this.log.debug((Object)"start");
        this.changeStatus(2);
        this.sip_provider.addSipProviderListener(this.transaction_id, this);
    }

    void init(TransactionServerListener listener, TransactionIdentifier transaction_id, ConnectionIdentifier connaction_id) {
        this.transaction_listener = listener;
        this.transaction_id = transaction_id;
        this.connection_id = this.connection_id;
        this.response = null;
        this.clearing_to = new Timer(SipStack.transaction_timeout, "Clearing", this);
        this.log.debug((Object)("id: " + String.valueOf(transaction_id)));
        this.log.debug((Object)"created");
    }

    public void listen() {
        if (this.statusIs(0)) {
            this.log.debug((Object)"start");
            this.changeStatus(1);
            this.sip_provider.addSipProviderListener(this.transaction_id, this);
        }
    }

    public void respondWith(Message resp) {
        this.response = resp;
        if (this.statusIs(2) || this.statusIs(3)) {
            this.sip_provider.sendMessage(this.response, this.connection_id);
            int code = this.response.getStatusLine().getCode();
            if (code >= 100 && code < 200 && this.statusIs(2)) {
                this.changeStatus(3);
            }
            if (code >= 200 && code < 700) {
                this.changeStatus(4);
                if (this.connection_id == null) {
                    this.clearing_to.start();
                } else {
                    this.log.debug((Object)"clearing_to=0 for reliable transport");
                    this.onTimeout(this.clearing_to);
                }
            }
        }
    }

    public void onReceivedMessage(SipProvider provider, Message msg) {
        if (msg.isRequest()) {
            if (this.statusIs(1)) {
                this.request = new Message(msg);
                this.connection_id = msg.getConnectionId();
                this.sip_provider.removeSipProviderListener(this.transaction_id);
                this.transaction_id = this.request.getTransactionId();
                this.sip_provider.addSipProviderListener(this.transaction_id, this);
                this.changeStatus(2);
                if (this.transaction_listener != null) {
                    this.transaction_listener.onTransRequest(this, msg);
                }
                return;
            }
            if (this.statusIs(3) || this.statusIs(4)) {
                this.log.debug((Object)"response retransmission");
                this.sip_provider.sendMessage(this.response, this.connection_id);
                return;
            }
        }
    }

    public void onTimeout(Timer to) {
        try {
            if (to.equals(this.clearing_to)) {
                this.log.debug((Object)"Clearing timeout expired");
                this.sip_provider.removeSipProviderListener(this.transaction_id);
                this.changeStatus(7);
                this.transaction_listener = null;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"error", (Throwable)e);
        }
    }

    public void terminate() {
        if (!this.statusIs(7)) {
            this.clearing_to.halt();
            this.sip_provider.removeSipProviderListener(this.transaction_id);
            this.changeStatus(7);
            this.transaction_listener = null;
        }
    }
}

