/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.tools;

import java.util.Calendar;
import java.util.Date;
import org.zoolu.tools.Parser;

public class DateFormat {
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] WEEKDAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    public static String formatHHMMSS(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String weekday = WEEKDAYS[cal.get(7) - 1];
        String month = MONTHS[cal.get(2)];
        String year = Integer.toString(cal.get(1));
        String day = Integer.toString(cal.get(5));
        String hour = Integer.toString(cal.get(11));
        String min = Integer.toString(cal.get(12));
        String sec = Integer.toString(cal.get(13));
        String millisec = Integer.toString(cal.get(14));
        if (day.length() == 1) {
            day = "0" + day;
        }
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        if (millisec.length() == 1) {
            millisec = "00" + millisec;
        } else if (millisec.length() == 2) {
            millisec = "0" + millisec;
        }
        return String.valueOf(hour) + ":" + min + ":" + sec + "." + millisec + " " + weekday + " " + day + " " + month + " " + year;
    }

    public static String formatYYYYMMDD(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String weekday = WEEKDAYS[cal.get(7) - 1];
        String year = Integer.toString(cal.get(1));
        String day = Integer.toString(cal.get(5));
        String hour = Integer.toString(cal.get(11));
        String min = Integer.toString(cal.get(12));
        String sec = Integer.toString(cal.get(13));
        String millisec = Integer.toString(cal.get(14));
        if (day.length() == 1) {
            day = "0" + day;
        }
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        if (millisec.length() == 1) {
            millisec = "00" + millisec;
        } else if (millisec.length() == 2) {
            millisec = "0" + millisec;
        }
        String month = Integer.toString(cal.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        return String.valueOf(year) + "-" + month + "-" + day + " " + hour + ":" + min + ":" + sec + "." + millisec;
    }

    public static String formatEEEddMMM(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String weekday = WEEKDAYS[cal.get(7) - 1];
        String month = MONTHS[cal.get(2)];
        String year = Integer.toString(cal.get(1));
        String day = Integer.toString(cal.get(5));
        String hour = Integer.toString(cal.get(11));
        String min = Integer.toString(cal.get(12));
        String sec = Integer.toString(cal.get(13));
        if (day.length() == 1) {
            day = "0" + day;
        }
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if (min.length() == 1) {
            min = "0" + min;
        }
        if (sec.length() == 1) {
            sec = "0" + sec;
        }
        return String.valueOf(weekday) + ", " + day + " " + month + " " + year + " " + hour + ":" + min + ":" + sec + " GMT";
    }

    public static Date parseEEEddMMM(String str, int index) {
        Calendar cal = Calendar.getInstance();
        char[] delim = new char[]{' ', ',', ':'};
        Parser par = new Parser(str, index);
        String EEE = par.getString();
        int day = par.getInt();
        String MMM = par.getString();
        int month = 0;
        while (month < 12) {
            if (MMM.equalsIgnoreCase(MONTHS[month])) break;
            ++month;
        }
        if (month == 12) {
            return null;
        }
        int year = par.getInt();
        int hour = Integer.parseInt(par.getWord(delim));
        int min = Integer.parseInt(par.getWord(delim));
        int sec = Integer.parseInt(par.getWord(delim));
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return cal.getTime();
    }
}

