/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.tools;

import org.zoolu.tools.MessageDigest;

public class MD5
extends MessageDigest {
    byte[] message_digest;
    long count;
    int[] state;
    byte[] block;
    int block_offset;
    static byte[] zeropadding;

    static {
        byte[] byArray = new byte[64];
        byArray[0] = -128;
        zeropadding = byArray;
    }

    public MD5() {
        this.init();
    }

    public MD5(byte[] buffer) {
        this.init();
        this.update(buffer);
    }

    public MD5(byte[] buffer, int offset, int len) {
        this.init();
        this.update(buffer, offset, len);
    }

    public MD5(String str) {
        this.init();
        this.update(str);
    }

    private void init() {
        this.count = 0L;
        this.block = new byte[64];
        this.block_offset = 0;
        this.state = new int[4];
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.message_digest = null;
    }

    public MessageDigest update(byte[] buffer, int offset, int len) {
        int i;
        if (this.message_digest != null) {
            return this;
        }
        this.count += (long)len;
        int size = this.block.length - this.block_offset;
        while (len >= size) {
            i = 0;
            while (i < size) {
                this.block[this.block_offset + i] = buffer[offset + i];
                ++i;
            }
            MD5.transform(this.state, this.block);
            offset += size;
            len -= size;
            this.block_offset = 0;
            size = this.block.length - this.block_offset;
        }
        i = 0;
        while (i < len) {
            this.block[this.block_offset + i] = buffer[offset + i];
            ++i;
        }
        this.block_offset += len;
        return this;
    }

    public byte[] doFinal() {
        if (this.message_digest != null) {
            return this.message_digest;
        }
        int npad = 64 - (this.block_offset + 8) % 64;
        long len = this.count * 8L;
        byte[] len_field = new byte[8];
        int i = 0;
        while (i < 8) {
            len_field[i] = (byte)(len % 256L);
            len >>= 8;
            ++i;
        }
        this.update(zeropadding, 0, npad);
        this.update(len_field, 0, 8);
        this.message_digest = new byte[16];
        int k = 0;
        int i2 = 0;
        while (i2 < 4) {
            this.message_digest[k++] = (byte)(this.state[i2] & 0xFF);
            this.message_digest[k++] = (byte)(this.state[i2] >>> 8 & 0xFF);
            this.message_digest[k++] = (byte)(this.state[i2] >>> 16 & 0xFF);
            this.message_digest[k++] = (byte)(this.state[i2] >>> 24 & 0xFF);
            ++i2;
        }
        return this.message_digest;
    }

    private static void transform(int[] state, byte[] block) {
        int a = state[0];
        int b = state[1];
        int c = state[2];
        int d = state[3];
        int[] x = new int[]{block[0] & 0xFF | (block[1] & 0xFF) << 8 | (block[2] & 0xFF) << 16 | block[3] << 24, block[4] & 0xFF | (block[5] & 0xFF) << 8 | (block[6] & 0xFF) << 16 | block[7] << 24, block[8] & 0xFF | (block[9] & 0xFF) << 8 | (block[10] & 0xFF) << 16 | block[11] << 24, block[12] & 0xFF | (block[13] & 0xFF) << 8 | (block[14] & 0xFF) << 16 | block[15] << 24, block[16] & 0xFF | (block[17] & 0xFF) << 8 | (block[18] & 0xFF) << 16 | block[19] << 24, block[20] & 0xFF | (block[21] & 0xFF) << 8 | (block[22] & 0xFF) << 16 | block[23] << 24, block[24] & 0xFF | (block[25] & 0xFF) << 8 | (block[26] & 0xFF) << 16 | block[27] << 24, block[28] & 0xFF | (block[29] & 0xFF) << 8 | (block[30] & 0xFF) << 16 | block[31] << 24, block[32] & 0xFF | (block[33] & 0xFF) << 8 | (block[34] & 0xFF) << 16 | block[35] << 24, block[36] & 0xFF | (block[37] & 0xFF) << 8 | (block[38] & 0xFF) << 16 | block[39] << 24, block[40] & 0xFF | (block[41] & 0xFF) << 8 | (block[42] & 0xFF) << 16 | block[43] << 24, block[44] & 0xFF | (block[45] & 0xFF) << 8 | (block[46] & 0xFF) << 16 | block[47] << 24, block[48] & 0xFF | (block[49] & 0xFF) << 8 | (block[50] & 0xFF) << 16 | block[51] << 24, block[52] & 0xFF | (block[53] & 0xFF) << 8 | (block[54] & 0xFF) << 16 | block[55] << 24, block[56] & 0xFF | (block[57] & 0xFF) << 8 | (block[58] & 0xFF) << 16 | block[59] << 24, block[60] & 0xFF | (block[61] & 0xFF) << 8 | (block[62] & 0xFF) << 16 | block[63] << 24};
        a += (b & c | ~b & d) + x[0] + -680876936;
        a = (a << 7 | a >>> 25) + b;
        d += (a & b | ~a & c) + x[1] + -389564586;
        d = (d << 12 | d >>> 20) + a;
        c += (d & a | ~d & b) + x[2] + 606105819;
        c = (c << 17 | c >>> 15) + d;
        b += (c & d | ~c & a) + x[3] + -1044525330;
        b = (b << 22 | b >>> 10) + c;
        a += (b & c | ~b & d) + x[4] + -176418897;
        a = (a << 7 | a >>> 25) + b;
        d += (a & b | ~a & c) + x[5] + 1200080426;
        d = (d << 12 | d >>> 20) + a;
        c += (d & a | ~d & b) + x[6] + -1473231341;
        c = (c << 17 | c >>> 15) + d;
        b += (c & d | ~c & a) + x[7] + -45705983;
        b = (b << 22 | b >>> 10) + c;
        a += (b & c | ~b & d) + x[8] + 1770035416;
        a = (a << 7 | a >>> 25) + b;
        d += (a & b | ~a & c) + x[9] + -1958414417;
        d = (d << 12 | d >>> 20) + a;
        c += (d & a | ~d & b) + x[10] + -42063;
        c = (c << 17 | c >>> 15) + d;
        b += (c & d | ~c & a) + x[11] + -1990404162;
        b = (b << 22 | b >>> 10) + c;
        a += (b & c | ~b & d) + x[12] + 1804603682;
        a = (a << 7 | a >>> 25) + b;
        d += (a & b | ~a & c) + x[13] + -40341101;
        d = (d << 12 | d >>> 20) + a;
        c += (d & a | ~d & b) + x[14] + -1502002290;
        c = (c << 17 | c >>> 15) + d;
        b += (c & d | ~c & a) + x[15] + 1236535329;
        b = (b << 22 | b >>> 10) + c;
        a += (b & d | c & ~d) + x[1] + -165796510;
        a = (a << 5 | a >>> 27) + b;
        d += (a & c | b & ~c) + x[6] + -1069501632;
        d = (d << 9 | d >>> 23) + a;
        c += (d & b | a & ~b) + x[11] + 643717713;
        c = (c << 14 | c >>> 18) + d;
        b += (c & a | d & ~a) + x[0] + -373897302;
        b = (b << 20 | b >>> 12) + c;
        a += (b & d | c & ~d) + x[5] + -701558691;
        a = (a << 5 | a >>> 27) + b;
        d += (a & c | b & ~c) + x[10] + 38016083;
        d = (d << 9 | d >>> 23) + a;
        c += (d & b | a & ~b) + x[15] + -660478335;
        c = (c << 14 | c >>> 18) + d;
        b += (c & a | d & ~a) + x[4] + -405537848;
        b = (b << 20 | b >>> 12) + c;
        a += (b & d | c & ~d) + x[9] + 568446438;
        a = (a << 5 | a >>> 27) + b;
        d += (a & c | b & ~c) + x[14] + -1019803690;
        d = (d << 9 | d >>> 23) + a;
        c += (d & b | a & ~b) + x[3] + -187363961;
        c = (c << 14 | c >>> 18) + d;
        b += (c & a | d & ~a) + x[8] + 1163531501;
        b = (b << 20 | b >>> 12) + c;
        a += (b & d | c & ~d) + x[13] + -1444681467;
        a = (a << 5 | a >>> 27) + b;
        d += (a & c | b & ~c) + x[2] + -51403784;
        d = (d << 9 | d >>> 23) + a;
        c += (d & b | a & ~b) + x[7] + 1735328473;
        c = (c << 14 | c >>> 18) + d;
        b += (c & a | d & ~a) + x[12] + -1926607734;
        b = (b << 20 | b >>> 12) + c;
        a += (b ^ c ^ d) + x[5] + -378558;
        a = (a << 4 | a >>> 28) + b;
        d += (a ^ b ^ c) + x[8] + -2022574463;
        d = (d << 11 | d >>> 21) + a;
        c += (d ^ a ^ b) + x[11] + 1839030562;
        c = (c << 16 | c >>> 16) + d;
        b += (c ^ d ^ a) + x[14] + -35309556;
        b = (b << 23 | b >>> 9) + c;
        a += (b ^ c ^ d) + x[1] + -1530992060;
        a = (a << 4 | a >>> 28) + b;
        d += (a ^ b ^ c) + x[4] + 1272893353;
        d = (d << 11 | d >>> 21) + a;
        c += (d ^ a ^ b) + x[7] + -155497632;
        c = (c << 16 | c >>> 16) + d;
        b += (c ^ d ^ a) + x[10] + -1094730640;
        b = (b << 23 | b >>> 9) + c;
        a += (b ^ c ^ d) + x[13] + 681279174;
        a = (a << 4 | a >>> 28) + b;
        d += (a ^ b ^ c) + x[0] + -358537222;
        d = (d << 11 | d >>> 21) + a;
        c += (d ^ a ^ b) + x[3] + -722521979;
        c = (c << 16 | c >>> 16) + d;
        b += (c ^ d ^ a) + x[6] + 76029189;
        b = (b << 23 | b >>> 9) + c;
        a += (b ^ c ^ d) + x[9] + -640364487;
        a = (a << 4 | a >>> 28) + b;
        d += (a ^ b ^ c) + x[12] + -421815835;
        d = (d << 11 | d >>> 21) + a;
        c += (d ^ a ^ b) + x[15] + 530742520;
        c = (c << 16 | c >>> 16) + d;
        b += (c ^ d ^ a) + x[2] + -995338651;
        b = (b << 23 | b >>> 9) + c;
        a += (c ^ (b | ~d)) + x[0] + -198630844;
        a = (a << 6 | a >>> 26) + b;
        d += (b ^ (a | ~c)) + x[7] + 1126891415;
        d = (d << 10 | d >>> 22) + a;
        c += (a ^ (d | ~b)) + x[14] + -1416354905;
        c = (c << 15 | c >>> 17) + d;
        b += (d ^ (c | ~a)) + x[5] + -57434055;
        b = (b << 21 | b >>> 11) + c;
        a += (c ^ (b | ~d)) + x[12] + 1700485571;
        a = (a << 6 | a >>> 26) + b;
        d += (b ^ (a | ~c)) + x[3] + -1894986606;
        d = (d << 10 | d >>> 22) + a;
        c += (a ^ (d | ~b)) + x[10] + -1051523;
        c = (c << 15 | c >>> 17) + d;
        b += (d ^ (c | ~a)) + x[1] + -2054922799;
        b = (b << 21 | b >>> 11) + c;
        a += (c ^ (b | ~d)) + x[8] + 1873313359;
        a = (a << 6 | a >>> 26) + b;
        d += (b ^ (a | ~c)) + x[15] + -30611744;
        d = (d << 10 | d >>> 22) + a;
        c += (a ^ (d | ~b)) + x[6] + -1560198380;
        c = (c << 15 | c >>> 17) + d;
        b += (d ^ (c | ~a)) + x[13] + 1309151649;
        b = (b << 21 | b >>> 11) + c;
        a += (c ^ (b | ~d)) + x[4] + -145523070;
        a = (a << 6 | a >>> 26) + b;
        d += (b ^ (a | ~c)) + x[11] + -1120210379;
        d = (d << 10 | d >>> 22) + a;
        c += (a ^ (d | ~b)) + x[2] + 718787259;
        c = (c << 15 | c >>> 17) + d;
        b += (d ^ (c | ~a)) + x[9] + -343485551;
        b = (b << 21 | b >>> 11) + c;
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
    }

    public static byte[] digest(byte[] buffer, int offset, int len) {
        MD5 md5 = new MD5(buffer, offset, len);
        return md5.doFinal();
    }

    public static byte[] digest(byte[] buffer) {
        return MD5.digest(buffer, 0, buffer.length);
    }

    public static byte[] digest(String str) {
        MD5 md5 = new MD5(str);
        return md5.doFinal();
    }
}

