/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.zoolu.tools.MD5;

public class MD5OTP {
    static int size;
    byte[] skey;
    byte[] h;
    int index;

    public MD5OTP(byte[] skey, byte[] iv) {
        this.init(16, skey, iv);
    }

    public MD5OTP(byte[] skey) {
        this.init(16, skey, null);
    }

    private void init(int size, byte[] skey, byte[] iv) {
        MD5OTP.size = size;
        if (iv == null) {
            iv = new byte[size];
            int i = 0;
            while (i < size) {
                iv[i] = 0;
                ++i;
            }
        }
        this.skey = skey;
        this.h = MD5OTP.clone(iv);
        this.index = size - 1;
    }

    private static byte[] clone(byte[] bb) {
        byte[] cc = new byte[bb.length];
        int i = 0;
        while (i < bb.length) {
            cc[i] = bb[i];
            ++i;
        }
        return cc;
    }

    private static byte[] cat(byte[] aa, byte[] bb) {
        byte[] cc = new byte[aa.length + bb.length];
        int i = 0;
        while (i < aa.length) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bb.length) {
            cc[i + aa.length] = bb[i];
            ++i;
        }
        return cc;
    }

    private static byte[] sub(byte[] bb, int begin, int end) {
        byte[] cc = new byte[end - begin];
        int i = begin;
        while (i < end) {
            cc[i - begin] = bb[i];
            ++i;
        }
        return cc;
    }

    private static byte[] hash(byte[] bb) {
        return MD5.digest(bb);
    }

    public byte[] update(byte[] m) {
        byte[] c = new byte[m.length];
        int i = 0;
        while (i < m.length) {
            ++this.index;
            if (this.index == size) {
                this.h = MD5OTP.hash(MD5OTP.cat(this.skey, this.h));
                this.index = 0;
            }
            c[i] = (byte)(m[i] ^ this.h[this.index]);
            ++i;
        }
        return c;
    }

    public void update(InputStream in, OutputStream out) {
        byte[] buff = new byte[2048];
        try {
            int len;
            while ((len = in.read(buff)) > 0) {
                out.write(this.update(MD5OTP.sub(buff, 0, len)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] encrypt(byte[] m, byte[] key) {
        byte[] iv = MD5.digest(Long.toString(new Random().nextLong()));
        byte[] c = new MD5OTP(key, iv).update(m);
        return MD5OTP.cat(iv, c);
    }

    public static byte[] decrypt(byte[] c, byte[] key) {
        byte[] iv = MD5OTP.sub(c, 0, 16);
        byte[] buf = MD5OTP.sub(c, 16, c.length);
        return new MD5OTP(key, iv).update(buf);
    }

    private static String asHex(byte[] bb) {
        StringBuffer buf = new StringBuffer(bb.length * 2);
        int i = 0;
        while (i < bb.length) {
            if ((bb[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(bb[i] & 0xFF));
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage:\n\n   java MD5OTP <message> <pass_phrase> [<iv>]");
            System.exit(0);
        }
        byte[] msg = args[0].getBytes();
        byte[] key = args[1].getBytes();
        byte[] iv = null;
        if (args.length > 2) {
            iv = args[2].getBytes();
        }
        System.out.println("m= " + MD5OTP.asHex(msg) + " (" + new String(msg) + ")");
        byte[] cip = new MD5OTP(key, iv).update(msg);
        System.out.println("c= " + MD5OTP.asHex(cip));
        cip = new MD5OTP(key, iv).update(cip);
        System.out.println("m= " + MD5OTP.asHex(cip) + " (" + new String(cip) + ")");
    }
}

