/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.tools;

public class Mangle {
    public static boolean compare(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] initBytes(byte[] b, int value) {
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)value;
            ++i;
        }
        return b;
    }

    public static short uByte(byte b) {
        return (short)(((short)b + 256) % 256);
    }

    public static long uWord(int n) {
        long wmask = 65536L;
        wmask *= wmask;
        return ((long)n + wmask) % wmask;
    }

    private static int rotateLeft(int w, int n) {
        return w << n | w >>> 32 - n;
    }

    private static int rotateRight(int w, int n) {
        return w >>> n | w << 32 - n;
    }

    private static int[] rotateLeft(int[] w) {
        int len = w.length;
        int w1 = w[len - 1];
        int i = len - 1;
        while (i > 1) {
            w[i] = w[i - 1];
            --i;
        }
        w[0] = w1;
        return w;
    }

    private static int[] rotateRight(int[] w) {
        int len = w.length;
        int w0 = w[0];
        int i = 1;
        while (i < len) {
            w[i - 1] = w[i];
            ++i;
        }
        w[len - 1] = w0;
        return w;
    }

    private static byte[] rotateLeft(byte[] b) {
        int len = b.length;
        byte b1 = b[len - 1];
        int i = len - 1;
        while (i > 1) {
            b[i] = b[i - 1];
            --i;
        }
        b[0] = b1;
        return b;
    }

    private static byte[] rotateRight(byte[] b) {
        int len = b.length;
        byte b0 = b[0];
        int i = 1;
        while (i < len) {
            b[i - 1] = b[i];
            ++i;
        }
        b[len - 1] = b0;
        return b;
    }

    public static byte[] clone(byte[] b) {
        return Mangle.getBytes(b, 0, b.length);
    }

    public static byte[] getBytes(byte[] b, int offset, int len) {
        byte[] bb = new byte[len];
        int k = 0;
        while (k < len) {
            bb[k] = b[offset + k];
            ++k;
        }
        return bb;
    }

    public static byte[] twoBytes(byte[] b, int offset) {
        return Mangle.getBytes(b, offset, 2);
    }

    public static byte[] fourBytes(byte[] b, int offset) {
        return Mangle.getBytes(b, offset, 4);
    }

    public static void copyBytes(byte[] src, byte[] dst, int offset) {
        int k = 0;
        while (k < src.length) {
            dst[offset + k] = src[k];
            ++k;
        }
    }

    public static void copyBytes(byte[] src, byte[] dst, int offset, int len) {
        int k = 0;
        while (k < len) {
            dst[offset + k] = src[k];
            ++k;
        }
    }

    public static void copyTwoBytes(byte[] src, byte[] dst, int offset) {
        Mangle.copyBytes(src, dst, offset, 2);
    }

    public static void copyFourBytes(byte[] src, byte[] dst, int offset) {
        Mangle.copyBytes(src, dst, offset, 4);
    }

    public static String bytesToHexString(byte[] b, int len) {
        String s = new String();
        int i = 0;
        while (i < len) {
            s = String.valueOf(s) + Integer.toHexString((b[i] + 256) % 256 / 16 % 16);
            s = String.valueOf(s) + Integer.toHexString((b[i] + 256) % 256 % 16);
            ++i;
        }
        return s;
    }

    public static String bytesToHexString(byte[] b) {
        return Mangle.bytesToHexString(b, b.length);
    }

    public static byte[] hexStringToBytes(String str, int len) {
        if (str.indexOf(":") >= 0) {
            String aux = "";
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c != ':') {
                    aux = String.valueOf(aux) + c;
                }
                ++i;
            }
            str = aux;
        }
        if (len < 0) {
            len = str.length() / 2;
        }
        byte[] b = new byte[len];
        int i = 0;
        while (i < len) {
            b[i] = len < str.length() / 2 ? (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16) : (byte)0;
            ++i;
        }
        return b;
    }

    public static byte[] hexStringToBytes(String str) {
        return Mangle.hexStringToBytes(str, -1);
    }

    public static String bytesToAddress(byte[] b) {
        return String.valueOf(Integer.toString(Mangle.uByte(b[0]))) + "." + Integer.toString(Mangle.uByte(b[1])) + "." + Integer.toString(Mangle.uByte(b[2])) + "." + Integer.toString(Mangle.uByte(b[3]));
    }

    public static byte[] addressToBytes(String addr) {
        int begin = 0;
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            if (i < 3) {
                int end = addr.indexOf(46, begin);
                b[i] = (byte)Integer.parseInt(addr.substring(begin, end));
                begin = end + 1;
            } else {
                b[3] = (byte)Integer.parseInt(addr.substring(begin));
            }
            ++i;
        }
        return b;
    }

    public static long bytesToInt(byte[] b) {
        return ((((long)Mangle.uByte(b[0]) << 8) + (long)Mangle.uByte(b[1]) << 8) + (long)Mangle.uByte(b[2]) << 8) + (long)Mangle.uByte(b[3]);
    }

    public static byte[] intToBytes(long n) {
        byte[] b = new byte[]{(byte)(n >> 24), (byte)((n >> 16) % 256L), (byte)((n >> 8) % 256L), (byte)(n % 256L)};
        return b;
    }

    public static long bytesToWord(byte[] b, int offset) {
        return ((((long)Mangle.uByte(b[offset + 3]) << 8) + (long)Mangle.uByte(b[offset + 2]) << 8) + (long)Mangle.uByte(b[offset + 1]) << 8) + (long)Mangle.uByte(b[offset + 0]);
    }

    public static long bytesToWord(byte[] b) {
        return ((((long)Mangle.uByte(b[3]) << 8) + (long)Mangle.uByte(b[2]) << 8) + (long)Mangle.uByte(b[1]) << 8) + (long)Mangle.uByte(b[0]);
    }

    public static byte[] wordToBytes(long n) {
        byte[] b = new byte[4];
        b[3] = (byte)(n >> 24);
        b[2] = (byte)((n >> 16) % 256L);
        b[1] = (byte)((n >> 8) % 256L);
        b[0] = (byte)(n % 256L);
        return b;
    }

    private static void print(String str) {
        System.out.println(str);
    }

    private static void decode(byte[] buffer, int[] out) {
        int offset = 0;
        int len = 64;
        int i = 0;
        while (offset < len) {
            out[i] = buffer[offset] & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | buffer[offset + 3] << 24;
            ++i;
            offset += 4;
        }
    }

    public static void main(String[] args) {
        byte[] buff = new byte[64];
        int i = 0;
        while (i < 64) {
            buff[i] = (byte)i;
            ++i;
        }
        int[] x = new int[16];
        int i2 = 0;
        while (i2 < 16) {
            x[i2] = (int)Mangle.bytesToWord(buff, i2 * 4);
            ++i2;
        }
        i2 = 0;
        while (i2 < 16) {
            Mangle.print("x[" + i2 + "]: " + Mangle.bytesToHexString(Mangle.wordToBytes(x[i2])));
            ++i2;
        }
        Mangle.decode(buff, x);
        i2 = 0;
        while (i2 < 16) {
            Mangle.print("x[" + i2 + "]: " + Mangle.bytesToHexString(Mangle.wordToBytes(x[i2])));
            ++i2;
        }
    }
}

