/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.tools;

import org.zoolu.tools.MessageDigest;

public class SimpleDigest
extends MessageDigest {
    byte[] message_digest;
    boolean is_done;
    int index;
    byte add_term;

    public SimpleDigest(int size) {
        this.init(size);
    }

    public SimpleDigest(int size, byte[] buffer) {
        this.init(size);
        this.update(buffer);
    }

    public SimpleDigest(int size, byte[] buffer, int offset, int len) {
        this.init(size);
        this.update(buffer, offset, len);
    }

    public SimpleDigest(int size, String str) {
        this.init(size);
        this.update(str);
    }

    private void init(int size) {
        this.is_done = false;
        this.message_digest = new byte[size];
        int i = 0;
        while (i < size) {
            this.message_digest[i] = (byte)i;
            ++i;
        }
        this.index = 0;
        this.add_term = 0;
    }

    public MessageDigest update(byte[] buffer, int offset, int len) {
        if (this.is_done) {
            return this;
        }
        int i = 0;
        while (i < len) {
            if (this.index == this.message_digest.length) {
                this.index = 0;
            }
            this.add_term = (byte)(this.add_term + buffer[offset + i]);
            this.message_digest[this.index] = (byte)(this.message_digest[this.index] ^ this.add_term);
            ++this.index;
            ++i;
        }
        return this;
    }

    public byte[] doFinal() {
        if (this.is_done) {
            return this.message_digest;
        }
        int k = this.message_digest.length - this.index;
        while (this.index < this.message_digest.length) {
            this.message_digest[this.index] = (byte)(this.message_digest[this.index] ^ k);
            ++this.index;
            ++k;
        }
        int i = 0;
        while (i < this.message_digest.length) {
            this.message_digest[i] = (byte)(this.message_digest[i] ^ this.add_term);
            ++i;
        }
        return this.message_digest;
    }

    public static byte[] digest(int size, byte[] buffer, int offset, int len) {
        SimpleDigest md = new SimpleDigest(size, buffer, offset, len);
        return ((MessageDigest)md).doFinal();
    }

    public static byte[] digest(int size, byte[] buffer) {
        return SimpleDigest.digest(size, buffer, 0, buffer.length);
    }

    public static byte[] digest(int size, String str) {
        SimpleDigest md = new SimpleDigest(size, str);
        return ((MessageDigest)md).doFinal();
    }
}

