/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.tools;

import org.zoolu.tools.InnerTimer;
import org.zoolu.tools.InnerTimerListener;
import org.zoolu.tools.InnerTimerST;
import org.zoolu.tools.TimerListener;

public class Timer
implements InnerTimerListener {
    public static boolean SINGLE_THREAD = false;
    TimerListener listener;
    long time;
    String label;
    boolean active;

    void init(long t_msec, String t_label, TimerListener t_listener) {
        this.listener = t_listener;
        this.time = t_msec;
        this.label = t_label;
        this.active = false;
    }

    public Timer(long t_msec, TimerListener t_listener) {
        this.init(t_msec, null, t_listener);
    }

    public Timer(long t_msec, String t_label, TimerListener t_listener) {
        this.init(t_msec, t_label, t_listener);
    }

    public String getLabel() {
        return this.label;
    }

    public long getTime() {
        return this.time;
    }

    public void halt() {
        this.active = false;
        this.listener = null;
    }

    public void start() {
        this.active = true;
        if (SINGLE_THREAD) {
            new InnerTimerST(this.time, this);
        } else {
            new InnerTimer(this.time, this);
        }
    }

    public void onInnerTimeout() {
        if (this.active && this.listener != null) {
            this.listener.onTimeout(this);
        }
        this.listener = null;
        this.active = false;
    }
}

