/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ChatMessage;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Chat
extends SkypeObject {
    private static final Map<String, Chat> chats = new HashMap<String, Chat>();
    private final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Chat getInstance(String string) {
        Map<String, Chat> map = chats;
        synchronized (map) {
            if (!chats.containsKey(string)) {
                chats.put(string, new Chat(string));
            }
            return chats.get(string);
        }
    }

    private Chat(String string) {
        assert (string != null);
        this.id = string;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Chat) {
            return this.getId().equals(((Chat)object).getId());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setTopic(String string) throws SkypeException {
        try {
            String string2 = "ALTER CHAT " + this.getId() + " SETTOPIC " + string;
            String string3 = "ALTER CHAT SETTOPIC";
            String string4 = Connector.getInstance().execute(string2, string3);
            Utils.checkError(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public void addUser(User user) throws SkypeException {
        Utils.checkNotNull("addedUser", user);
        this.addUsers(new User[]{user});
    }

    public void addUsers(User[] userArray) throws SkypeException {
        Utils.checkNotNull("addedUsers", userArray);
        try {
            String string = "ALTER CHAT " + this.getId() + " ADDMEMBERS " + Chat.toCommaSeparatedString(userArray);
            String string2 = "ALTER CHAT ADDMEMBERS";
            String string3 = Connector.getInstance().execute(string, string2);
            Utils.checkError(string3);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    private static String toCommaSeparatedString(User[] userArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < userArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(userArray[i].getId());
        }
        return stringBuilder.toString();
    }

    public void leave() throws SkypeException {
        try {
            String string = "ALTER CHAT " + this.getId() + " LEAVE";
            String string2 = "ALTER CHAT LEAVE";
            String string3 = Connector.getInstance().execute(string, string2);
            Utils.checkError(string3);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public ChatMessage[] getAllChatMessages() throws SkypeException {
        try {
            String string = "GET CHAT " + this.getId() + " CHATMESSAGES";
            String string2 = "CHAT " + this.getId() + " CHATMESSAGES ";
            String string3 = Connector.getInstance().execute(string, string2);
            String string4 = string3.substring(string2.length());
            String[] stringArray = Utils.convertToArray(string4);
            ChatMessage[] chatMessageArray = new ChatMessage[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                chatMessageArray[i] = ChatMessage.getInstance(stringArray[i]);
            }
            return chatMessageArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public ChatMessage[] getRecentChatMessages() throws SkypeException {
        try {
            String string = "GET CHAT " + this.getId() + " RECENTCHATMESSAGES";
            String string2 = "CHAT " + this.getId() + " RECENTCHATMESSAGES ";
            String string3 = Connector.getInstance().execute(string, string2);
            String string4 = string3.substring(string2.length());
            String[] stringArray = Utils.convertToArray(string4);
            ChatMessage[] chatMessageArray = new ChatMessage[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                chatMessageArray[i] = ChatMessage.getInstance(stringArray[i]);
            }
            return chatMessageArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public ChatMessage send(String string) throws SkypeException {
        try {
            String string2 = "CHATMESSAGE ";
            String string3 = Connector.getInstance().executeWithId("CHATMESSAGE " + this.getId() + " " + string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length(), string3.indexOf(" STATUS "));
            return ChatMessage.getInstance(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public Date getTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getAdder() throws SkypeException {
        String string = this.getProperty("ADDER");
        if ("".equals(string)) {
            return null;
        }
        return User.getInstance(string);
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CHAT", this.getId(), "STATUS"));
    }

    public String getWindowTitle() throws SkypeException {
        return this.getProperty("FRIENDLYNAME");
    }

    public User[] getAllPosters() throws SkypeException {
        return this.getUsersProperty("POSTERS");
    }

    public User[] getAllMembers() throws SkypeException {
        return this.getUsersProperty("MEMBERS");
    }

    public User[] getAllActiveMembers() throws SkypeException {
        return this.getUsersProperty("ACTIVEMEMBERS");
    }

    private User[] getUsersProperty(String string) throws SkypeException {
        try {
            String string2 = "GET CHAT " + this.getId() + " " + string;
            String string3 = "CHAT " + this.id + " " + string + " ";
            String string4 = Connector.getInstance().execute(string2, string3);
            String string5 = string4.substring(string3.length());
            if ("".equals(string5)) {
                return new User[0];
            }
            String[] stringArray = string5.split(" ");
            User[] userArray = new User[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                userArray[i] = User.getInstance(stringArray[i]);
            }
            return userArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public boolean isBookmarked() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("BOOKMARKED"));
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("CHAT", this.getId(), string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DIALOG,
        LEGACY_DIALOG,
        MULTI_SUBSCRIBED,
        UNSUBSCRIBED;

    }
}

