/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Call;
import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.VoiceMail;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class User
extends SkypeObject {
    private static final Map<String, User> users = new HashMap<String, User>();
    private static Object propertyChangeListenerMutex = new Object();
    private static ConnectorListener propertyChangeListener;
    public static final String STATUS_PROPERTY = "status";
    public static final String MOOD_TEXT_PROPERTY = "moodText";
    private String id;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getInstance(String string) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(string)) {
                users.put(string, new User(string));
            }
            return users.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Friend getFriendInstance(String string) {
        Map<String, User> map = users;
        synchronized (map) {
            if (!users.containsKey(string)) {
                Friend friend = new Friend(string);
                users.put(string, friend);
                return friend;
            }
            User user = users.get(string);
            if (user instanceof Friend) {
                return (Friend)user;
            }
            Friend friend = new Friend(string);
            friend.copyFrom(user);
            users.put(string, friend);
            return friend;
        }
    }

    User(String string) {
        this.id = string;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof User) {
            User user = (User)object;
            return this.getId().equals(user.getId());
        }
        return false;
    }

    public final String toString() {
        return this.getId();
    }

    public final String getId() {
        return this.id;
    }

    public final String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public final Date getBirthDay() throws SkypeException {
        String string = this.getProperty("BIRTHDAY");
        if ("0".equals(string)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("library developer should check Skype specification.");
        }
    }

    public final Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    @Deprecated
    public final Status getOnlineStatus() throws SkypeException {
        return this.getStatus();
    }

    public final Status getStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("ONLINESTATUS"));
    }

    public Date getLastOnlineTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("LASTONLINETIMESTAMP"));
    }

    @Deprecated
    public final String getLauguage() throws SkypeException {
        return this.getLanguage();
    }

    public final String getLanguage() throws SkypeException {
        String string = this.getProperty("LANGUAGE");
        if ("".equals(string)) {
            return "";
        }
        return string.substring(string.indexOf(32) + 1);
    }

    public final String getLanguageByISOCode() throws SkypeException {
        String string = this.getProperty("LANGUAGE");
        if ("".equals(string)) {
            return "";
        }
        return string.substring(0, string.indexOf(32));
    }

    public final String getCountry() throws SkypeException {
        String string = this.getProperty("COUNTRY");
        if ("".equals(string)) {
            return "";
        }
        return string.substring(string.indexOf(32) + 1);
    }

    public final String getCountryByISOCode() throws SkypeException {
        String string = this.getProperty("COUNTRY");
        if ("".equals(string)) {
            return "";
        }
        return string.substring(0, string.indexOf(32));
    }

    public final String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public final String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    @Deprecated
    public final String getHomePhone() throws SkypeException {
        return this.getHomePhoneNumber();
    }

    public final String getHomePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    @Deprecated
    public final String getOfficePhone() throws SkypeException {
        return this.getOfficePhoneNumber();
    }

    public final String getOfficePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    @Deprecated
    public final String getMobilePhone() throws SkypeException {
        return this.getMobilePhoneNumber();
    }

    public final String getMobilePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public final String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    @Deprecated
    public final String getAbout() throws SkypeException {
        return this.getIntroduction();
    }

    public final String getIntroduction() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public String getSpeedDial() throws SkypeException {
        return this.getProperty("SPEEDDIAL");
    }

    public void getSpeedDial(String string) throws SkypeException {
        this.setProperty("SPEEDDIAL", string);
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProperty("TIMEZONE"));
    }

    public final String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public final boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public final BuddyStatus getBuddyStatus() throws SkypeException {
        return BuddyStatus.values()[Integer.parseInt(this.getProperty("BUDDYSTATUS"))];
    }

    final void askForAuthorization(String string) throws SkypeException {
        try {
            String string2 = "SET USER " + this.getId() + " " + "BUDDYSTATUS" + " " + BuddyStatus.PENDING.ordinal() + " " + string;
            String string3 = "USER " + this.getId() + " " + "BUDDYSTATUS";
            String string4 = Connector.getInstance().execute(string2, string3);
            Utils.checkError(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    final void removeFromContactList() throws SkypeException {
        this.setProperty("BUDDYSTATUS", "" + BuddyStatus.DELETED.ordinal());
    }

    public final boolean isAuthorized() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISAUTHORIZED"));
    }

    public final void setAuthorized(boolean bl) throws SkypeException {
        this.setProperty("ISAUTHORIZED", bl);
    }

    public final boolean isBlocked() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISBLOCKED"));
    }

    public final boolean canLeaveVoiceMail() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("CAN_LEAVE_VM"));
    }

    public final boolean isForwardingCalls() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_CF_ACTIVE"));
    }

    public final void setBlocked(boolean bl) throws SkypeException {
        this.setProperty("ISBLOCKED", bl);
    }

    public BufferedImage getAvatar() throws SkypeException {
        try {
            File file = Utils.createTempraryFile("get_avator_", "jpg");
            String string = "GET USER " + this.getId() + " AVATAR 1 " + file.getAbsolutePath();
            String string2 = "USER " + this.getId() + " AVATAR 1 ";
            String string3 = Connector.getInstance().execute(string, string2);
            Utils.checkError(string3);
            BufferedImage bufferedImage = ImageIO.read(file);
            file.delete();
            return bufferedImage;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("USER", this.getId(), string);
    }

    private void setProperty(String string, boolean bl) throws SkypeException {
        this.setProperty(string, ("" + bl).toUpperCase());
    }

    private void setProperty(String string, String string2) throws SkypeException {
        Utils.setProperty("USER", this.getId(), string, string2);
    }

    public final Call call() throws SkypeException {
        return Skype.call(this.getId());
    }

    public final Chat chat() throws SkypeException {
        return Skype.chat(this.getId());
    }

    public final ChatMessage send(String string) throws SkypeException {
        return Skype.chat(this.getId()).send(string);
    }

    public final VoiceMail voiceMail() throws SkypeException {
        return Skype.voiceMail(this.getId());
    }

    public final void setDisplayName(String string) throws SkypeException {
        Utils.setProperty("USER", this.getId(), "DISPLAYNAME", string);
    }

    public final ChatMessage[] getAllChatMessages() throws SkypeException {
        String[] stringArray = this.getHistory("CHATMESSAGES");
        ChatMessage[] chatMessageArray = new ChatMessage[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            chatMessageArray[i] = ChatMessage.getInstance(stringArray[i]);
        }
        List<ChatMessage> list = Arrays.asList(chatMessageArray);
        Collections.reverse(list);
        return list.toArray(new ChatMessage[0]);
    }

    public final Call[] getAllCalls() throws SkypeException {
        String[] stringArray = this.getHistory("CALLS");
        Call[] callArray = new Call[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            callArray[i] = Call.getInstance(stringArray[i]);
        }
        return callArray;
    }

    private String[] getHistory(String string) throws SkypeException {
        try {
            String string2 = string + " ";
            String string3 = Connector.getInstance().execute("SEARCH " + string + " " + this.getId(), string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length());
            return Utils.convertToArray(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    final void dispose() {
        users.remove(this.getId());
    }

    private void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SkypeException {
        Object object = propertyChangeListenerMutex;
        synchronized (object) {
            if (User.propertyChangeListener == null) {
                AbstractConnectorListener abstractConnectorListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.startsWith("USER ")) {
                            String string2 = string.substring("USER ".length());
                            String string3 = string2.substring(0, string2.indexOf(32));
                            string2 = string2.substring(string2.indexOf(32) + 1);
                            String string4 = string2.substring(0, string2.indexOf(32));
                            String string5 = string2.substring(string2.indexOf(32) + 1);
                            if (string4.equals("ONLINESTATUS")) {
                                User.getInstance(string3).firePropertyChanged(User.STATUS_PROPERTY, null, (Object)Status.valueOf(string5));
                            } else if (string4.equals("MOOD_TEXT")) {
                                User.getInstance(string3).firePropertyChanged(User.MOOD_TEXT_PROPERTY, null, string5);
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(abstractConnectorListener);
                    User.propertyChangeListener = abstractConnectorListener;
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuddyStatus {
        NEVER_BEEN,
        DELETED,
        PENDING,
        ADDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        OFFLINE,
        ONLINE,
        AWAY,
        NA,
        DND,
        SKYPEOUT,
        SKYPEME;

    }
}

