/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector;

import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import com.skype.connector.ConnectorStatusEvent;
import com.skype.connector.ConnectorUtils;
import com.skype.connector.MessageProcessor;
import com.skype.connector.NotAttachedException;
import com.skype.connector.NotificationChecker;
import com.skype.connector.win32.Win32Connector;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connector {
    private static boolean _useJNIConnector;
    private static Connector _instance;
    private static String bindSkypeId;
    private final Object _debugListenerMutex = new Object();
    private ConnectorListener _debugListener;
    private volatile PrintWriter _debugOut = new PrintWriter(System.out, true);
    private volatile String _applicationName = "Skype4Java";
    private volatile Status _status = Status.NOT_RUNNING;
    private volatile int _connectTimeout = 10000;
    private volatile int _commandTimeout = 10000;
    private final Object _isInitializedMutex = new Object();
    private boolean _isInitialized;
    private ExecutorService _asyncSender;
    private ExecutorService _syncSender;
    private final List<ConnectorListener> _asyncListeners = new CopyOnWriteArrayList<ConnectorListener>();
    private final List<ConnectorListener> _syncListeners = new CopyOnWriteArrayList<ConnectorListener>();
    private final AtomicInteger _commandCount = new AtomicInteger();
    private ExecutorService _commandExecutor;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public static synchronized void useJNIConnector(boolean bl) {
        if (_instance != null) {
            throw new IllegalStateException("You should call Connector#useJNIConnector(boolean) before calling Connector#getInstance().");
        }
        _useJNIConnector = bl;
    }

    public static Connector getInstance() {
        return Connector.getInstance(null);
    }

    public static synchronized Connector getInstance(String string) {
        if (_instance == null) {
            if (string != null) {
                bindSkypeId = string;
            }
            String string2 = null;
            String string3 = System.getProperty("os.name");
            if (string3.startsWith("Windows")) {
                if (!Connector.isSWTAvailable()) {
                    _useJNIConnector = true;
                }
                string2 = _useJNIConnector ? "com.skype.connector.win32.Win32Connector" : "com.skype.connector.windows.WindowsConnector";
            } else if (string3.startsWith("Linux") || string3.startsWith("LINUX")) {
                string2 = "com.skype.connector.linux.LinuxConnector";
            } else if (string3.startsWith("Mac OS X")) {
                string2 = "com.skype.connector.osx.OSXConnector";
            }
            if (string2 == null) {
                throw new IllegalStateException("This platform is not supported by Skype4Java.");
            }
            try {
                Class<?> clazz = Class.forName(string2);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                _instance = string3.startsWith("Windows") ? Win32Connector.getInstance(bindSkypeId) : (Connector)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                throw new IllegalStateException("The connector couldn't be initialized.", exception);
            }
        }
        return _instance;
    }

    private static boolean isSWTAvailable() {
        try {
            Class.forName("org.eclipse.swt.SWT");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    protected static synchronized void setInstance(Connector connector) throws ConnectorException {
        if (_instance != null) {
            _instance.dispose();
        }
        _instance = connector;
    }

    protected Connector() {
    }

    public String getInstalledPath() {
        return "skype";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDebug(boolean bl) throws ConnectorException {
        Object object = this._debugListenerMutex;
        synchronized (object) {
            if (bl) {
                if (this._debugListener == null) {
                    this._debugListener = new AbstractConnectorListener(){

                        public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                            Connector.this.getDebugOut().println("<- " + connectorMessageEvent.getMessage());
                        }

                        public void messageSent(ConnectorMessageEvent connectorMessageEvent) {
                            Connector.this.getDebugOut().println("-> " + connectorMessageEvent.getMessage());
                        }

                        public void statusChanged(ConnectorStatusEvent connectorStatusEvent) {
                            Connector.this.getDebugOut().println("<- " + (Object)((Object)connectorStatusEvent.getStatus()));
                        }
                    };
                    this.addConnectorListener(this._debugListener, true, true);
                }
            } else if (this._debugListener != null) {
                this.removeConnectorListener(this._debugListener);
                this._debugListener = null;
            }
        }
    }

    public final void setDebugOut(PrintWriter printWriter) {
        ConnectorUtils.checkNotNull("debugOut", printWriter);
        this._debugOut = printWriter;
    }

    public final void setDebugOut(PrintStream printStream) {
        ConnectorUtils.checkNotNull("debugOut", printStream);
        this.setDebugOut(new PrintWriter(printStream, true));
    }

    public final PrintWriter getDebugOut() {
        return this._debugOut;
    }

    public final void setApplicationName(String string) {
        ConnectorUtils.checkNotNull("applicationName", string);
        this._applicationName = string;
    }

    public final String getApplicationName() {
        return this._applicationName;
    }

    protected final void setStatus(Status status) {
        ConnectorUtils.checkNotNull("status", (Object)status);
        this._status = status;
        this.fireStatusChanged(status);
    }

    private void fireStatusChanged(final Status status) {
        this._syncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireStatusChanged(Connector.this.toConnectorListenerArray(Connector.this._syncListeners), status);
            }
        });
        this._asyncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireStatusChanged(Connector.this.toConnectorListenerArray(Connector.this._asyncListeners), status);
            }
        });
    }

    private ConnectorListener[] toConnectorListenerArray(List<ConnectorListener> list) {
        return list.toArray(new ConnectorListener[0]);
    }

    private void fireStatusChanged(ConnectorListener[] connectorListenerArray, Status status) {
        ConnectorStatusEvent connectorStatusEvent = new ConnectorStatusEvent(this, status);
        for (int i = connectorListenerArray.length - 1; 0 <= i; --i) {
            connectorListenerArray[i].statusChanged(connectorStatusEvent);
        }
    }

    public final Status getStatus() {
        return this._status;
    }

    public final void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The connect timeout must be more than 0.");
        }
        this._connectTimeout = n;
    }

    public final int getConnectTimeout() {
        return this._connectTimeout;
    }

    public final void setCommandTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The connect timeout must be more than 0.");
        }
        this._commandTimeout = n;
    }

    public final int getCommandTimeout() {
        return this._commandTimeout;
    }

    public final Status connect() throws ConnectorException {
        this.initialize();
        Status status = this.connect(this.getConnectTimeout());
        if (status == Status.ATTACHED) {
            this.sendApplicationName(this.getApplicationName());
            this.sendProtocol();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialize() throws ConnectorException {
        Object object = this._isInitializedMutex;
        synchronized (object) {
            if (!this._isInitialized) {
                this._asyncSender = Executors.newCachedThreadPool(new ThreadFactory(){
                    private final AtomicInteger threadNumber = new AtomicInteger();

                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, "AsyncSkypeMessageSender-" + this.threadNumber.getAndIncrement());
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this._syncSender = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, "SyncSkypeMessageSender");
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this._commandExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
                    private final AtomicInteger threadNumber = new AtomicInteger();

                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, "CommandExecutor-" + this.threadNumber.getAndIncrement());
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                this.initializeImpl();
                this._isInitialized = true;
            }
        }
    }

    protected abstract void initializeImpl() throws ConnectorException;

    protected abstract Status connect(int var1) throws ConnectorException;

    protected void sendApplicationName(String string) throws ConnectorException {
    }

    protected void sendProtocol() throws ConnectorException {
        this.execute("PROTOCOL 9999", new String[]{"PROTOCOL "}, false);
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() throws ConnectorException {
        Object object = this._isInitializedMutex;
        synchronized (object) {
            if (!this._isInitialized) {
                return;
            }
            this.disposeImpl();
            this.setStatus(Status.NOT_RUNNING);
            this._commandExecutor.shutdown();
            this._syncSender.shutdown();
            this._asyncSender.shutdown();
            this._syncListeners.clear();
            this._asyncListeners.clear();
            Object object2 = this._debugListenerMutex;
            synchronized (object2) {
                if (this._debugListener != null) {
                    this.addConnectorListener(this._debugListener, false, true);
                }
            }
            this._isInitialized = false;
        }
    }

    protected abstract void disposeImpl() throws ConnectorException;

    public boolean isRunning() throws ConnectorException {
        try {
            this.assureAttached();
            return true;
        }
        catch (ConnectorException connectorException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void execute(String string, final MessageProcessor messageProcessor) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("processor", messageProcessor);
        this.assureAttached();
        Object object = new Object();
        AbstractConnectorListener abstractConnectorListener = new AbstractConnectorListener(){

            public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                messageProcessor.messageReceived(connectorMessageEvent.getMessage());
            }
        };
        messageProcessor.init(object, abstractConnectorListener);
        this.addConnectorListener(abstractConnectorListener, false);
        Object object2 = object;
        synchronized (object2) {
            try {
                this.fireMessageSent(string);
                this.sendCommand(string);
                long l = System.currentTimeMillis();
                long l2 = this.getCommandTimeout();
                object.wait(l2);
                if (l2 <= System.currentTimeMillis() - l) {
                    this.setStatus(Status.NOT_RUNNING);
                    throw new NotAttachedException(Status.NOT_RUNNING);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new ConnectorException("The '" + string + "' command was interrupted.", interruptedException);
            }
            finally {
                this.removeConnectorListener(abstractConnectorListener);
            }
        }
    }

    public final String execute(String string) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        return this.execute(string, string);
    }

    public final String executeWithId(String string, String string2) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("responseHeader", string2);
        String string3 = "#" + this._commandCount.getAndIncrement() + " ";
        String string4 = this.execute(string3 + string, new String[]{string3 + string2, string3 + "ERROR "}, true);
        return string4.substring(string3.length());
    }

    public final Future waitForEndWithId(String string, String string2, final NotificationChecker notificationChecker) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("responseHeader", string2);
        ConnectorUtils.checkNotNull("responseHeader", notificationChecker);
        final String string3 = "#" + this._commandCount.getAndIncrement() + " ";
        NotificationChecker notificationChecker2 = new NotificationChecker(){

            public boolean isTarget(String string) {
                if (notificationChecker.isTarget(string)) {
                    return true;
                }
                return string.startsWith(string3 + "ERROR ");
            }
        };
        final Future<String> future = this.execute(string3 + string, notificationChecker2, true, false);
        return new Future<String>(){

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public String get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.removeId((String)future.get(l, timeUnit));
            }

            @Override
            public String get() throws InterruptedException, ExecutionException {
                return this.removeId((String)future.get());
            }

            private String removeId(String string) {
                if (string.startsWith(string3)) {
                    return string.substring(string3.length());
                }
                return string;
            }

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }
        };
    }

    public final String executeWithoutTimeout(String string, String string2) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("responseHeader", string2);
        return this.execute(string, new String[]{string2, "ERROR "}, true, true);
    }

    public final String execute(String string, String string2) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("responseHeader", string2);
        return this.execute(string, new String[]{string2, "ERROR "}, true);
    }

    public final String execute(String string, String[] stringArray) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("responseHeaders", stringArray);
        return this.execute(string, stringArray, true);
    }

    protected final String execute(String string, String[] stringArray, boolean bl) throws ConnectorException {
        return this.execute(string, stringArray, bl, false);
    }

    private String execute(String string, final String[] stringArray, boolean bl, boolean bl2) throws ConnectorException {
        NotificationChecker notificationChecker = new NotificationChecker(){

            public boolean isTarget(String string) {
                for (String string2 : stringArray) {
                    if (!string.startsWith(string2)) continue;
                    return true;
                }
                return false;
            }
        };
        try {
            return this.execute(string, notificationChecker, bl, bl2).get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ConnectorException("The '" + string + "' command was interrupted.", interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotAttachedException) {
                NotAttachedException notAttachedException = (NotAttachedException)executionException.getCause();
                throw new NotAttachedException(notAttachedException.getStatus(), (Throwable)notAttachedException);
            }
            if (executionException.getCause() instanceof ConnectorException) {
                ConnectorException connectorException = (ConnectorException)executionException.getCause();
                throw new ConnectorException(connectorException.getMessage(), connectorException);
            }
            throw new ConnectorException("The '" + string + "' command execution failed.", executionException);
        }
    }

    private Future<String> execute(final String string, final NotificationChecker notificationChecker, boolean bl, boolean bl2) throws ConnectorException {
        ConnectorUtils.checkNotNull("command", string);
        ConnectorUtils.checkNotNull("responseChecker", notificationChecker);
        if (bl) {
            this.assureAttached();
        }
        return this._commandExecutor.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                final LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
                AbstractConnectorListener abstractConnectorListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (notificationChecker.isTarget(string) || string.startsWith("PONG")) {
                            linkedBlockingQueue.add(string);
                        }
                    }
                };
                Connector.this.addConnectorListener(abstractConnectorListener, false);
                Connector.this.fireMessageSent(string);
                Connector.this.sendCommand(string);
                try {
                    String string3;
                    boolean bl = false;
                    int n = 0;
                    while (true) {
                        if ((string3 = (String)linkedBlockingQueue.poll(Connector.this.getCommandTimeout(), TimeUnit.MILLISECONDS)) == null) {
                            if (bl) {
                                Connector.this.setStatus(Status.NOT_RUNNING);
                                throw new NotAttachedException(Status.NOT_RUNNING);
                            }
                            if (++n > 2 && string.startsWith("GET ") || n > 8) {
                                Connector.this.setStatus(Status.NOT_AVAILABLE);
                                throw new NotAttachedException(Status.NOT_AVAILABLE);
                            }
                            Connector.this.fireMessageSent("PING");
                            Connector.this.sendCommand("PING");
                            bl = true;
                            continue;
                        }
                        if (!string3.startsWith("PONG")) break;
                        bl = false;
                    }
                    String string2 = string3;
                    return string2;
                }
                finally {
                    Connector.this.removeConnectorListener(abstractConnectorListener);
                }
            }
        });
    }

    private void fireMessageSent(String string) {
        this.fireMessageEvent(string, false);
    }

    protected abstract void sendCommand(String var1);

    private void assureAttached() throws ConnectorException {
        Status status = this.getStatus();
        if (status != Status.ATTACHED && (status = this.connect()) != Status.ATTACHED) {
            throw new NotAttachedException(status);
        }
    }

    public final void addConnectorListener(ConnectorListener connectorListener) throws ConnectorException {
        this.addConnectorListener(connectorListener, true);
    }

    public final void addConnectorListener(ConnectorListener connectorListener, boolean bl) throws ConnectorException {
        this.addConnectorListener(connectorListener, bl, false);
    }

    public final void addConnectorListener(ConnectorListener connectorListener, boolean bl, boolean bl2) throws ConnectorException {
        ConnectorUtils.checkNotNull("listener", connectorListener);
        if (bl2) {
            this._syncListeners.add(connectorListener);
        } else {
            this._asyncListeners.add(connectorListener);
        }
        if (bl) {
            this.assureAttached();
        }
    }

    public final void removeConnectorListener(ConnectorListener connectorListener) {
        ConnectorUtils.checkNotNull("listener", connectorListener);
        this._syncListeners.remove(connectorListener);
        this._asyncListeners.remove(connectorListener);
    }

    protected final void fireMessageReceived(String string) {
        this.fireMessageEvent(string, true);
    }

    private void fireMessageEvent(final String string, final boolean bl) {
        ConnectorUtils.checkNotNull("message", string);
        this._syncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireMessageEvent(Connector.this.toConnectorListenerArray(Connector.this._syncListeners), string, bl);
            }
        });
        this._asyncSender.execute(new Runnable(){

            public void run() {
                Connector.this.fireMessageEvent(Connector.this.toConnectorListenerArray(Connector.this._asyncListeners), string, bl);
            }
        });
    }

    private void fireMessageEvent(ConnectorListener[] connectorListenerArray, String string, boolean bl) {
        ConnectorMessageEvent connectorMessageEvent = new ConnectorMessageEvent(this, string);
        for (int i = connectorListenerArray.length - 1; 0 <= i; --i) {
            if (bl) {
                connectorListenerArray[i].messageReceived(connectorMessageEvent);
                continue;
            }
            connectorListenerArray[i].messageSent(connectorMessageEvent);
        }
    }

    public final void setStringProperty(String string, String string2) {
        ConnectorUtils.checkNotNull("name", string);
        if (string2 != null) {
            this.properties.put(string, string2);
        } else {
            this.properties.remove(string);
        }
    }

    public final String getStringProperty(String string) {
        ConnectorUtils.checkNotNull("name", string);
        return this.properties.get(string);
    }

    static {
        bindSkypeId = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PENDING_AUTHORIZATION,
        ATTACHED,
        REFUSED,
        NOT_AVAILABLE,
        API_AVAILABLE,
        NOT_RUNNING;

    }
}

