/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.win32;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorUtils;
import java.io.File;

public final class Win32Connector
extends Connector {
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int ATTACH_API_AVAILABLE = 32769;
    private static final String LIBFILENAME = "skype.dll";
    private static Win32Connector instance = null;
    private String bindSkypeId = null;
    private Thread eventDispatcher = null;

    public static synchronized Connector getInstance(String string) {
        if (instance == null) {
            instance = new Win32Connector(string);
        }
        return instance;
    }

    private Win32Connector(String string) {
        this.bindSkypeId = string;
    }

    public String getInstalledPath() {
        return this.jni_getInstalledPath();
    }

    protected void initializeImpl() {
        block3: {
            try {
                System.loadLibrary("skype");
            }
            catch (Throwable throwable) {
                if (ConnectorUtils.checkLibraryInPath(LIBFILENAME)) break block3;
                ConnectorUtils.extractFromJarToTemp(LIBFILENAME);
                String string = System.getProperty("java.io.tmpdir");
                if (!string.endsWith("" + File.separatorChar)) {
                    string = string + File.separatorChar;
                }
                System.load(string + LIBFILENAME);
            }
        }
        this.jni_init();
        this.eventDispatcher = new Thread(new Runnable(){

            public void run() {
                Win32Connector.this.jni_windowProc();
            }
        }, "SkypeBridge WindowProc Thread");
        this.eventDispatcher.setDaemon(true);
        this.eventDispatcher.start();
    }

    protected Connector.Status connect(int n) throws ConnectorException {
        try {
            Connector.Status status = Connector.Status.NOT_RUNNING;
            this.setStatus(status);
            int n2 = n / 1000;
            for (int i = 0; i < n2; ++i) {
                this.jni_connect(this.bindSkypeId);
                Thread.sleep(500L);
                status = this.getStatus();
                if (status != Connector.Status.PENDING_AUTHORIZATION && status != Connector.Status.NOT_RUNNING) {
                    return status;
                }
                Thread.sleep(500L);
            }
            return status;
        }
        catch (InterruptedException interruptedException) {
            throw new ConnectorException("Trying to connect was interrupted.", interruptedException);
        }
    }

    protected void sendApplicationName(String string) throws ConnectorException {
        String string2 = "NAME " + string;
        this.execute(string2, new String[]{string2}, false);
    }

    public void jni_onAttach(int n) {
        switch (n) {
            case 1: {
                this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                break;
            }
            case 0: {
                this.setStatus(Connector.Status.ATTACHED);
                break;
            }
            case 2: {
                this.setStatus(Connector.Status.REFUSED);
                break;
            }
            case 3: {
                this.setStatus(Connector.Status.NOT_AVAILABLE);
                break;
            }
            case 32769: {
                this.setStatus(Connector.Status.API_AVAILABLE);
                break;
            }
            default: {
                this.setStatus(Connector.Status.NOT_RUNNING);
            }
        }
    }

    public void jni_onSkypeMessage(String string) {
        this.fireMessageReceived(string);
    }

    protected void disposeImpl() {
        throw new UnsupportedOperationException("WindowsConnector#disposeImpl() is not implemented yet.");
    }

    protected void sendCommand(String string) {
        this.jni_sendMessage(string);
    }

    private native void jni_init();

    private native void jni_windowProc();

    private native void jni_sendMessage(String var1);

    private native void jni_connect(String var1);

    private native String jni_getInstalledPath();
}

