/*
 * Copyright (C) 2008 Greg Dorfuss - mhspot.com
 * 
 * This source code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 * This class removes hava 1.6 requirement
 */

package local.media;

import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.IOException;



public class PipedInputStreamSizable extends PipedInputStream 
{
    // default buffer size
    protected static int THIS_PIPE_SIZE=1024;
    
    public PipedInputStreamSizable() 
    {  
       super(); 
       makeBuffer(THIS_PIPE_SIZE); 
    } 

    public PipedInputStreamSizable(int bufSize) 
    {  
       super(); 
       makeBuffer(bufSize);	
    } 
    
    public PipedInputStreamSizable(PipedOutputStream src) throws IOException 
    {  
       super(src); 
       makeBuffer(THIS_PIPE_SIZE); 
    } 

    public PipedInputStreamSizable(PipedOutputStream src,int bufSize) throws IOException 
    {  
       super(src); 
       makeBuffer(bufSize);	
    } 

    protected void makeBuffer(int bufSize)
    {
    	THIS_PIPE_SIZE=bufSize;	
        buffer=new byte[THIS_PIPE_SIZE]; 
    }
    
}
