package local.ua;


import local.media.JMediaSender;
import local.media.JVisualReceiver;

import org.apache.log4j.Logger;

/** Video launcher */
public class JMFVideoLauncher implements MediaLauncher
{
   /** Event logger. */
	private Logger log = Logger.getLogger(this.getClass());
   
   /** Runtime media process */
   Process media_process=null;
   
   int localport;
   int remoteport;
   String remoteaddr;
   
   int dir; // duplex= 0, recv-only= -1, send-only= +1; 

   JMediaSender sender=null;
   JVisualReceiver receiver=null;
   
   /** Costructs the video launcher */
   public JMFVideoLauncher(int local_port, String remote_addr, int remote_port, int direction)
   {  
      localport=local_port;
      remoteport=remote_port;
      remoteaddr=remote_addr;
      dir=direction;
      // Patch for working with JMF with local streams
      if (remote_addr.startsWith("127."))
      {  log.info("Patch for JMF: replaced local destination address "+remote_addr+" with 255.255.255.255");
         remote_addr="255.255.255.255";
      }
      if (dir>=0) sender=new JMediaSender("video",null,remote_addr,remote_port);
      //if (dir>=0) sender=new JMediaSender("video","file://C:\\users\\mp3\\__video\\cartoons\\ufo_robot.mpg",remote_addr,remote_port);
      if (dir<=0) receiver=new JVisualReceiver("video",local_port);
   }

   /** Starts media application */
   public boolean startMedia()
   {  log.info("launching JMF-Video...");
      String err1=null, err2=null;

      if (sender!=null) err1=sender.start();
      if (err1!=null) log.error("Error trying to send video stream: "+err1);    

      if (receiver!=null) err2=receiver.start();
      if (err2!=null) log.error("Error trying to receive video stream: "+err2);    

      return (err1==null && err2==null);      
   }

   /** Stops media application */
   public boolean stopMedia()
   {  String err1=null, err2=null;

      if (sender!=null) err1=sender.stop();      
      if (err1!=null) log.error("Error stopping video sender: "+err1);    

      if (receiver!=null) err2=receiver.stop();      
      if (err2!=null) log.error("Error stopping video receiver: "+err2);    

      return (err1==null && err2==null);      
   }


}