package local.ua;


import local.net.UdpRelay;

import org.apache.log4j.Logger;


/** RAT launcher */
public class RATLauncher implements MediaLauncher
{
   /** Event logger. */
	private Logger log = Logger.getLogger(this.getClass());

   /** Runtime media process (RAT application) */
   Process media_process=null;
   
   int localport;
   int remoteport;
   String remoteaddr;
   
   /** Media application command */
   String command;

   /** Costructs the RAT launcher 
     * <p> <i>attributes</i> is a Vector of the sdp media attributes */
   public  RATLauncher(String rat_comm, int local_port, String remote_addr, int remote_port)
   {  
      command=rat_comm;
      localport=local_port;
      remoteport=remote_port;
      remoteaddr=remote_addr;
   }

   /** Starts media application */
   public boolean startMedia()
   {  // udp flow adaptation for RAT application
      if (localport!=remoteport) 
      {  log.info("UDP local relay: src_port="+localport+", dest_port="+remoteport);
      log.info("UDP local relay: src_port="+(localport+1)+", dest_port="+(remoteport+1));
         new UdpRelay(localport,"127.0.0.1",remoteport,null);
         new UdpRelay(localport+1,"127.0.0.1",remoteport+1,null);  
      }
      else
      {  log.info("local_port==remote_port --> no UDP relay is needed");
      }

      //debug...
      log.info("launching RAT-Audio...");

      String cmds[] = {"","",""};
      cmds[0] = command;
      cmds[1] = remoteaddr+"/"+remoteport;

      // try to start the RAT
      try
      {  media_process=Runtime.getRuntime().exec(cmds);
         return true;
      }
      catch (Exception e)
      {  e.printStackTrace();
         return false;
      }          
   }

   /** Stops media application */
   public boolean stopMedia()
   {  if (media_process!=null) media_process.destroy();
      return true;
   }

}