package local.ua;


import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.message.Message;

/** Listener of UserAgent */
public interface UserAgentListener
{
   /** When a new call is incoming */
   public void onUaCallIncoming(UserAgent ua, NameAddress callee, NameAddress caller,Message invite);
   
   /** When an incoming call is cancelled */
   public void onUaCallCancelled(UserAgent ua);

   /** When an inciming call has been confirmed */
   public void onUaCallConfirmed(UserAgent ua);
   
   /** When an outgoing call is remotly ringing */
   public void onUaCallRinging(UserAgent ua);
   
   /** When an outgoing call has been accepted */
   public void onUaCallAccepted(UserAgent ua);
   
   /** When a call has been trasferred */
   public void onUaCallTrasferred(UserAgent ua);

   /** When an ougoing call has been refused or timeout */
   public void onUaCallFailed(UserAgent ua);

   /** When a call has been locally or remotly closed */
   public void onUaCallClosed(UserAgent ua);
   
   /** When a digit is received */
   public void onDtmfReceived(UserAgent ua, int digit,boolean isOther);
}