/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Author(s):
 * Greg Dorfuss
 */



package local.ua;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class BasicInstaller
{
	   private String configFiles="siptosis.cfg,SipToSkypeAuth.props,SkypeToSipAuth.props,SkypeOutDialingRules.props,SipOutDialingRules.props";
	   private String configSrcFiles="siptosis.cfg,SipToSkypeAuth.props,SkypeToSipAuth.props,SkypeOutDialingRules.props,SipOutDialingRules.props";
	   private String fileSrcSizes="-1,-1,-1,-1,-1";

	   BufferedWriter logStream=null;
	   
	   BasicInstaller(int bitSize)
	   {
		    //System.getProperties().list(System.out);
		    
		    String osName=System.getProperty("os.name").toLowerCase();
		    String arch=System.getProperty("os.arch").toLowerCase();
		    
			if (osName.indexOf("windows")>=0)
			{	
				configFiles+=",skype.dll";
				if (bitSize==64)
				{	
				   configSrcFiles+=",skype_x64.dll";
				   fileSrcSizes+=","+new File("samples/skype_x64.dll").length();
				}  
				else
				{	
					configSrcFiles+=",skype.dll";
					fileSrcSizes+=","+new File("samples/skype.dll").length();
				}	
			}	
			else if (osName.indexOf("linux")>=0)
			{	
				configFiles+=",libskype.so";
				if (bitSize==64)
				{
					if (arch.startsWith("amd"))
					{	
						configSrcFiles+=",libskype_x64.so";
						fileSrcSizes+=",-1";
					}
					else
					{	
						configSrcFiles+=",libskype_x64.so"; // need 64bit intel lib here
						fileSrcSizes+=",-1";
					}
				}
				else
				{	
					configSrcFiles+=",libskype.so";
					fileSrcSizes+=",-1";
				}
			}	
			else if (osName.indexOf("mac os x")>=0)
			{	
				configFiles+=",libskype.jnilib";
				configSrcFiles+=",libskype.jnilib";
				fileSrcSizes+=",-1";
			}	
			else
			{
				log("Unsupported platform: "+osName);
				System.exit(1);
			}
		   
		    if (!installed())
			{	 
		    	log("Performing basic installation for: "+osName+" "+bitSize+" bit system.");	
		    	if (osName.indexOf("mac os x")>=0)
		    		doCommand("cp -r -u samples/osx_framework/Skype.framework /Skype.framework");
			   if (!doInstall())
				  System.exit(SkypeUA.ExitCode.STARTERROR.code());
			}
		   
		    closeLog();
	   }
	   
		
		private boolean installed()
		{
			
			String[] checkList=configFiles.split(",");
			String[] srcSizeList=fileSrcSizes.split(",");
			for (int i=0;i<checkList.length;i++)
			{	
				File file = new File(checkList[i]);
				int chkSize=Integer.parseInt(srcSizeList[i]);
				if (!file.exists() || (chkSize>0 && file.length()!=chkSize) )
					return false;
			}
				
			return true;
		}
		
		private boolean doInstall()
		{
			String[] checkList=configFiles.split(",");
			String[] srcList=configSrcFiles.split(",");
			String[] srcSizeList=fileSrcSizes.split(",");
			for (int i=0;i<checkList.length;i++)
			{	
				File file = new File(checkList[i]);
				int chkSize=Integer.parseInt(srcSizeList[i]);
				if (!file.exists() || (chkSize>0 && file.length()!=chkSize) )
				{	
					if (!copyFile("samples/"+srcList[i],"./"+checkList[i]))
						log("Failed to copy: samples/"+srcList[i]+ " to: ./"+checkList[i]);
					else
						log("Copied: samples/"+srcList[i]+ " to: ./"+checkList[i]);
				}
			}
			
			return true;
		}
		

		  private boolean copyFile(String srcFile,String destFile)
		  {
			  try 
			  { 
			 	  File sourceFile=new File(srcFile); // source
			 	  BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile), 4096);
			      File targetFile = new File(destFile); // destination
			      BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(targetFile), 4096);
			      int theChar;
			      while ((theChar = bis.read()) != -1) 
			      {
			         bos.write(theChar);
			      }
			       bos.close();
			       bis.close();
			 }
			 catch (Exception ex) 
			 {
				 	ex.printStackTrace();
				 	return false;
			 }  
			 return true;
		  }
		  
		  private void log(String msg)
		  {
			 System.out.println(msg);
			 try
			 {
				  if (logStream==null)
				  {
					  logStream=new BufferedWriter(new FileWriter("install.log"));
					  logStream.write(new Date().toString()+"\r\n");
				  }
				  
				  logStream.write(msg+"\r\n");
			 }
			 catch (Exception e)
			 {
				 System.exit(SkypeUA.ExitCode.FATALERROR.code());
			 }
		  }
		  
		  private void closeLog()
		  {
			  try
			  {
			    if (logStream!=null)
			    	logStream.close();
			  }
			  catch(Exception e)
			  {}
		  }
		  
			private boolean doCommand(String strCmd)
			{
					
					BufferedReader br = null;
					try 
					{
						String myArgs[]=strCmd.split(" ");

						ProcessBuilder processB = new ProcessBuilder(myArgs);
						processB.redirectErrorStream(true);
						Process process=processB.start();
				        InputStream is = process.getInputStream();
					    InputStreamReader isr = new InputStreamReader(is);
					    br = new BufferedReader(isr);
					    
					    StringBuffer lineBuf=new StringBuffer();
					    String line;
				        while ((line = br.readLine()) != null) 
					    {
				        	if (lineBuf.length()>0)
				        		lineBuf.append("\r\n");
				        	lineBuf.append(line);
				        	
				        	//print(line);
					    }
				        
				        if (lineBuf.length()>0)
				        {	
					        if (lineBuf.toString().contains("An unexpected error"))
					        	log("An unexpected error occurred");
					        else	
					        	log(lineBuf.toString());
				        }
				        
				        br.close();
					    process.waitFor();
					    if (process.exitValue()==0)
					    	return true;

					}
				    catch (Exception err) 
				    {
				    	try {br.close();} catch (Exception e){}
				    	err.printStackTrace();
				    	log("Error running command");
				    }
			    	return false;

			}		  
}
