/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import com.skype.Call;
import java.util.Date;
import java.text.SimpleDateFormat;

public class CallHistoryEntry
{
	Call.Type callType;
	String callId;
	String callTo;
	String callFrom;
	Date startTime;
	long durationSeconds=0;
	String callCost;
	
	CallHistoryEntry()
	{
	}
			
	CallHistoryEntry(CallHistoryEntry src)
	{
		callType=src.callType;
		callId=src.callId;
		callFrom=src.callFrom;
		callTo=src.callTo;
		startTime=src.startTime;
		durationSeconds=src.durationSeconds;
		callCost=src.callCost;
	}
	
	CallHistoryEntry(Call.Type argCallType,String argCallId,String argCallFrom,String argCallTo,Date argStartTime,int argDurationSeconds,String argCallCost)
	{
		callType=argCallType;
		callId=argCallId;
		callFrom=argCallFrom;
		callTo=argCallTo;
		startTime=argStartTime;
		durationSeconds=argDurationSeconds;
		callCost=argCallCost;
	}

	CallHistoryEntry(String csvEntry) throws Exception
	{
		String tmp=csvEntry+" ";
		String[] entry=tmp.split(",");
		
		callType=Call.Type.valueOf(entry[0]);
		callId=entry[1];
		callFrom=entry[2];
		callTo=entry[3];
		startTime=new SimpleDateFormat("yyyyMMdd HH:mm:ss").parse(entry[4]);
		durationSeconds=Long.parseLong(entry[5]);
		callCost=entry[6].trim();
	}
	
	public String toString()
	{
	   String tmpTime="";
	   if (startTime!=null)
		   tmpTime=new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(startTime);
	  return callType.toString()+","+callId+","+callFrom.replaceAll(",", "")+","+callTo.replaceAll(",", "")+","+tmpTime+","+durationSeconds+","+callCost;
	}
	
}
