/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

public class CallTimer extends Thread
{
	private int maxCallMinutes=0;
	private int warnMinutes=0;
	private CallTimerInterface callInt=null;
	private boolean stopTimer=false;
	
	CallTimer(int argMaxCallMinutes,int argWarnMinutes, CallTimerInterface argInt) 
	{
		this.setName(this.getClass().getName()+".T"+this.getName().replaceAll("Thread-", ""));
		this.maxCallMinutes=argMaxCallMinutes;
		this.warnMinutes=argWarnMinutes;
	    this.callInt=argInt;
	}

	
	public void stopTimer()
	{
		this.stopTimer=true;
		this.interrupt();
	}
	
	public void run() 
	{
		int cnt=0;
		
		try
		{
			while (!interrupted() && !stopTimer && cnt<this.maxCallMinutes)
			{	
				if (this.warnMinutes>0 && cnt==this.maxCallMinutes-this.warnMinutes)
					callInt.onCallTimeoutWarning();
				
				sleep(1000*60);
				cnt++;
			}
		}
		catch(Exception e)
		{}
		if (!stopTimer)
			callInt.onCallTimeout();
	}
}
