/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import java.io.PrintWriter;
import java.io.ByteArrayOutputStream;

import org.apache.log4j.Logger;

public class ConnectorDebugWriter extends PrintWriter
{
	private Logger log= null;
	public ConnectorDebugWriter()
	{
		super(new ByteArrayOutputStream(4)); // buffer not actually used here
		log= Logger.getLogger(this.getClass().getName());
	}
	
	public void println(String x) 
	{
		log.info(x);
	}
	public void flush()
	{
	}
}
