/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */


package local.ua;

import java.net.DatagramSocket;

import local.ua.sscodecs.SSCodec;

import org.apache.log4j.Logger;

/** Audio launcher based on javax.sound  */
public class JSkypeAudioLauncher implements MediaLauncher
{  
   /** Event logger. */
   private Logger log = Logger.getLogger(this.getClass());
	
   private DatagramSocket socket=null; 
   
   private SkypeRtpSender skypeaudio_output=null;
   private SkypeRtpReceiver skypeaudio_input=null;
   
   /** Constructs the audio launcher */
   public JSkypeAudioLauncher(DatagramSocket argSocket,SSCodec sscodec,String remote_addr, int remote_port, int direction,SkypeRtpReceiver skypeAudioIn,SkypeRtpSender skypeAudioOut)
   {
      try
      {  
          socket=argSocket;
          
         int dir=direction;
         
         // send from skype to sip
         if (dir>=0)
         {  
        	skypeaudio_output=skypeAudioOut;
        	skypeAudioOut.initRtp(sscodec,socket,remote_addr,remote_port);
         }
         
         // receive from sip and send to skype
         if (dir<=0)
         {  
        	skypeaudio_input=skypeAudioIn;
        	skypeAudioIn.initRtp(sscodec,socket);
         }
      }
      catch (Exception e) {  log.error("launchError",e);  }
   }

   
   /** Starts media application */
   public boolean startMedia()
   {  
	  log.debug("starting skype/sip audio bridge..");

      if (skypeaudio_output!=null) skypeaudio_output.startMedia();
      if (skypeaudio_input!=null) skypeaudio_input.startMedia();
      
      return true;      
   }


   /** Stops media application */
   public boolean stopMedia()
   {  
	  log.debug("halting skype/sip audio bridge..");    
     
      if (skypeaudio_input!=null)
      {  
    	  skypeaudio_input.stopMedia(); skypeaudio_input=null;
      }      

      if (skypeaudio_output!=null)
      {  
    	  skypeaudio_output.stopMedia(); skypeaudio_output=null;
      }
      
      try { Thread.sleep(150); } catch (Exception e) {}
      return true;
   }



}