/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.log4j.Logger;



public class MailerThread extends Thread
{
	private String msgSubject;
	private String msgBodyText;
	private String mailHost;
	private int mailPort;
	private String userName;
	private String password;
	private String recipients;
	private String fromAddress;
	private static Logger log=null;
	
	private MailerThread()
	{
	}
	
	MailerThread(String argmsgSubject,String argmsgBodyText,String argmailHost,int argmailPort,String arguserName,String argpassword,String argrecipients,String argfromAddress)
	{
		//this.setName(this.getClass().getName()+".T"+this.getName().replaceAll("Thread-", ""));
		log=Logger.getLogger(this.getClass().getName());
		
		this.msgSubject=argmsgSubject;
		this.msgBodyText=argmsgBodyText;
		this.mailHost=argmailHost;
		this.mailPort=argmailPort;
		this.userName=arguserName;
		this.password=argpassword;
		this.recipients=argrecipients;
		this.fromAddress=argfromAddress;
		
		start();
	}

	
	public void run() 
	{
        log.info("Sending Mail.");

		if (sendMail(this.msgSubject, this.msgBodyText, this.mailHost, this.mailPort, this.userName, this.password, this.recipients, this.fromAddress))
            log.info("Mail sent.");
	}		


	   public static boolean sendMail(String msgSubject,String msgBodyText,String mailHost,int mailPort,String userName,String password,String recipients,String fromAddress)
	    {
	    	boolean emailSent=false;
	    	int maxAttempts=3;
	    	if (mailPort<0)
	    		mailPort=25;

	    	String[] recipientList=recipients.split(";");
	        Properties props = new Properties();
	        props.put("mail.smtp.host", mailHost);
	        props.put("mail.smtp.port", mailPort);
	        props.put("mail.transport.protocol", "smtp");
	        props.put("mail.smtp.connectiontimeout", "4000"); // milliseconds
	        props.put("mail.smtp.timeout", "10000");// milliseconds
	        
	        Session session = null;

	        if (password!=null && password.length()>0 && userName!=null && userName.length()>0)
	        {	
	            Authenticator auth = new SMTPAuthenticator(userName,password);
	        	props.put("mail.smtp.user", userName);
	            props.put("mail.smtp.auth", "true");
	            session=Session.getDefaultInstance(props, auth);
	        }
	        else
	        {	
	            props.put("mail.smtp.auth", "false");
	            session=Session.getDefaultInstance(props);
	        }
	        	
	        session.setDebug(false);
	        
	        try
	        {
	            	InternetAddress[] actualTo =new InternetAddress[recipientList.length];
	                for (int x=0;x<recipientList.length;x++)
	                {
	                	actualTo[x]=new InternetAddress(recipientList[x]);
	                }
	                
	                InternetAddress from = new InternetAddress(fromAddress);
	                
	                // make text version

	                try 
	                {
	                    //create a message
	                    MimeMessage msg = new MimeMessage(session);
	                    msg.setFrom(from);
	                    msg.setRecipients(Message.RecipientType.TO, actualTo);
	                    
	                    msg.setSubject(msgSubject);
	                    msg.setSentDate(new Date());
	                    msg.setHeader("X-Mailer", "SipToSis Notifier");
	                    
	                    //create and fill the text only part
	                    MimeBodyPart mbpText = new MimeBodyPart();
	                    mbpText.setContent(msgBodyText,"text/plain");

	                    //create the Multipart and its parts to it
	                    Multipart mp = new MimeMultipart("alternative"); 
	                    mp.addBodyPart(mbpText);
	                    
	                    //add the Multipart to the message
	                    msg.setContent(mp);

	                    int retryCnt=0;
	                    while (retryCnt<maxAttempts && !emailSent)
	                    {    
	                        retryCnt++;
	                        try{
	                            //send the message
	                            log.debug("sendMail - transport.send - attempt# "+retryCnt+" start");
	                            Transport.send(msg);
	                            emailSent=true;
	                        } 
	                        catch (MessagingException mex) 
	                        {
	                            log.debug("sendMail - transport.send - attempt# "+retryCnt +" failed " + mex.getMessage());
	                            
	                            
	                            if (mex.getMessage().toLowerCase().indexOf("could not connect")>=0)
	                                Thread.sleep(3000);
	                            else
	                            {
	                                int errorCode=0;
	                                Matcher errorMatcher = Pattern.compile("[0-9]{3}").matcher(mex.getMessage());
	                                if (errorMatcher.find(0))
	                                {
	                                   errorCode=Integer.parseInt(mex.getMessage().substring(errorMatcher.start(),errorMatcher.end()));
	                                }
	                                
	                                if (errorCode>=400 && errorCode<500)
	                                    Thread.sleep(3000);
	                                else
	                                {    
	                                    log.error("sendMail - Error",mex);
	                                    Exception ex = null;
	                                    if ((ex = mex.getNextException()) != null) 
	                                    {
	                                        log.error("sendMail - Error",ex);
	                                    }
	                                    retryCnt=9999; // hard failure
	                                }
	                            }
	                        }
	                    }
	                    
	                } 
	                catch (MessagingException mex) 
	                {
	                    log.error("sendMail Error",mex);
	                    Exception ex = null;
	                    if ((ex = mex.getNextException()) != null) 
	                    {
	                        ex.printStackTrace();
	                        log.error("sendMail Error",ex);
	                    }
	                }
	        
	        }
	        catch (Exception ex)
	        {
	            log.error("sendMail Error",ex);
	        }        

	        return emailSent;
	    }
	    
}


class SMTPAuthenticator extends javax.mail.Authenticator
{
	String userName;
	String password;
	
	public SMTPAuthenticator(String userName,String password)
	{
		this.userName=userName;
		this.password=password;
	}

    public PasswordAuthentication getPasswordAuthentication()
    {
        return new PasswordAuthentication(userName, password);
    }
}



