/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */


package local.ua;

import java.io.IOException;
import java.io.PipedOutputStream;
import local.media.PipedInputStreamSizable;

public class PipedInputStreamPCM extends PipedInputStreamSizable
{
	public PipedInputStreamPCM() 
    {  
       super(); 
       makeBuffer(THIS_PIPE_SIZE); 
    } 

    public PipedInputStreamPCM(int bufSize) 
    {  
       super(); 
       makeBuffer(bufSize);	
    } 
    
    public PipedInputStreamPCM(PipedOutputStream src) throws IOException 
    {  
       super(src); 
       makeBuffer(THIS_PIPE_SIZE); 
    } 

    public PipedInputStreamPCM(PipedOutputStream src,int bufSize) throws IOException 
    {  
       super(src); 
       makeBuffer(bufSize);	
    } 
	
   public void chopBuffer(int targetBytes) throws IOException
   {
   	   skip(available()-targetBytes); // throw away some audio
   }
	       
    public void clearBuffer() throws IOException
    {
    	skip(available());
    }
 
}
