/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

public class SipCallRingTimer extends Thread
{
	private long timeout=0;
	private SipCallRingTimerInterface sdtInt=null;
	private boolean stopTimer=false;
	
	SipCallRingTimer(long argTimeoutSeconds, SipCallRingTimerInterface argInt) 
	{
	    this.timeout=argTimeoutSeconds;
	    this.sdtInt=argInt;
	    start();
	}

	
	public void stopTimer()
	{
		this.sdtInt=null;
		this.stopTimer=true;
	}
	
	public void run() 
	{
		try
		{
		  if (!interrupted() && !stopTimer)
		  {	  
			  sleep(this.timeout*1000);
	 		  if (this.sdtInt!=null)
	 			  this.sdtInt.onSipCallRingTimeout();
		  }
		}
		catch(Exception e)
		{}
	}
}
