/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * runs a command sequence defined in SipToSkypeAuth.props
 */
public class SipCommandRunner extends Thread
{
	private Vector<QueueCmd> queueList=new Vector<QueueCmd>();
	private SSCallChannel skypeua=null;
	private boolean stop=false;
	private Logger log = null;
	
	SipCommandRunner(String cmdData,SSCallChannel argUa) 
	{
		this.setName(this.getClass().getName()+".T"+this.getName().replaceAll("Thread-", ""));
		log = Logger.getLogger(this.getName());
		
	    this.skypeua=argUa;
	    
		//	parse cmdlist
		String[] cmdList=cmdData.split(";");
		for (int c=0;c<cmdList.length;c++)
		{
			String[] curCmd=cmdList[c].split(":");
			if (curCmd.length==2)
				queueList.add(new QueueCmd(curCmd[0].toLowerCase(),curCmd[1]));
			else if (curCmd.length==1)
				queueList.add(new QueueCmd(curCmd[0].toLowerCase(),""));
			else
			{	
				log.error("Invalid command sequence:"+cmdData);
				this.queueList.clear();
				skypeua.listen();
				break;
			}
		}
	}

	public void run() 
	{
		
		while (queueList.size()>0 && !stop)
		{
			QueueCmd thisCmd=queueList.get(0);
			queueList.remove(0);
			
			log.info(thisCmd.attrib+":"+thisCmd.value);
			
			if (thisCmd.attrib.equals("pause"))
			{
				try 
				{
					sleep(Long.parseLong(thisCmd.value)*1000);
				}
				catch (Exception e)
				{
					log.error("error",e);
				}
			}
			else if (thisCmd.attrib.equals("dtmf"))
			{
				this.skypeua.ua.queueSipDtmfDigits(thisCmd.value);
			}
			else if (thisCmd.attrib.equals("pin"))
			{
				this.skypeua.startSipAuthSequence(thisCmd.value);
			}
			else if (thisCmd.attrib.equals("calleeid"))
			{
				this.skypeua.setPinCalleeDial();
			}
			else if (thisCmd.attrib.equals("play"))
			{
				this.skypeua.ua.queueSipClip(thisCmd.value);
				this.skypeua.waitForSipClipsComplete();
				if (queueList.size()==0)
				{
					this.skypeua.ua.hangup();
				}
			}
			else
			{
				log.error("Unknown command:"+thisCmd.attrib+":"+thisCmd.value);
			}
			
		}
		
		if (!this.stop)
			this.skypeua.clearSipCommandRunner();
	}
	public void stopCommands()
	{
		this.stop=true;
	}
}
