/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.net.*;
import java.io.BufferedInputStream;

import org.apache.log4j.Logger;


/*
 * Receives Skype Audio from skype client
 */

public class SkypeAudioReceiverServer extends Thread implements SSInBandDtmfInterface
{
    private boolean stopnow=false;
    
    private Logger log = null;
    
    private boolean sipSending=false;
    
    private PipedOutputStream skypeOutputStream=new PipedOutputStream();
    
    private SkypeUserAgent ua=null;
    
    private boolean haltNow=false;
	private ServerSocket listener;
	private long neededSkypeBytes=0;
	private int skypeSleepIntervalMs=0;
	private static final int SkypeBytesPerMs=32;
	

	private boolean inbandDtmfActive=false;
    
	public SkypeAudioReceiverServer(SkypeUserAgent argUa) throws Exception
	{
		this.setName(this.getClass().getName()+".T"+this.getName().replaceAll("Thread-", ""));
		log = Logger.getLogger(this.getName());
		
		this.ua=argUa;

	}
	
	public PipedOutputStream getPipedOutputStream()
	{
		return skypeOutputStream;
	}

	
	public void stopMedia()
	{
		stopnow=true;
	}
	
	public void gotDtmfDigit(int digit)
	{
		this.ua.gotSkypeDtmfDigit(digit);
	}
	
	public void setSipSending(boolean state,long argNeededSkypeBytes)
	{
		sipSending=state;
		neededSkypeBytes=argNeededSkypeBytes;
		skypeSleepIntervalMs=(int) (neededSkypeBytes/SkypeBytesPerMs/2)+1; // check half the needed interval
		if (!this.ua.skype_profile.inbandFullTimeDtmfDetection && state)
			inbandDtmfActive=false;
	}
	
	
	public void halt()
	{
		haltNow=true;
		
		try
		{
		listener.close();
		}
		catch (Exception e)
		{}
	}
	
	
	public void interrupt()
	{
		stopnow=true;
		super.interrupt();
	}
	
	
	public void run() 
	{
	  	try 
	  	{
	      
	      listener = new ServerSocket(this.ua.skypeOutPort);
	      Socket server;
	      while (!haltNow)
	      {	
	    	  		 inbandDtmfActive=this.ua.skype_profile.enableSkypeDtmfDetector;
	    	  		 neededSkypeBytes=SkypeBytesPerMs*10;
	    	  		 skypeSleepIntervalMs=(int) (neededSkypeBytes/SkypeBytesPerMs/2)+1;
	    	  		 server = listener.accept();
	             	 handleConnection(server);
					 server.close();
	      }
	      
	    } catch (IOException ioe) 
	    {
	      if (!haltNow)	
	    	  log.error("IOException: ", ioe);
	    }
	}
	
	
	public void handleConnection(Socket server)
	{
				if (ua.skype_profile.audioPriorityIncrease>0)
				{
					try
					{
					this.setPriority(Thread.NORM_PRIORITY+ua.skype_profile.audioPriorityIncrease);
					}
					catch (Exception e)
					{
						log.warn("setPriority Error. ",e);
					}
				}

		
	            stopnow=false;
			    try
			    {
					server.setSoLinger(false, 500);
					//server.setTcpNoDelay(true);
					server.setKeepAlive(false);
					server.setSoTimeout(80);
        		}
        		catch (IOException e)
        		{
        			log.fatal("socket error",e);
        			this.ua.hangup();
        			stopnow=true;
        		}
        		
        		if (this.ua.skype_profile.TcpRxBufferSize>0)
        		{
        			try
        			{
		        		server.setReceiveBufferSize(this.ua.skype_profile.TcpRxBufferSize);
						int tstRx=server.getReceiveBufferSize();
						if (tstRx!=this.ua.skype_profile.TcpRxBufferSize)
						{
							log.warn("error setting TCPReceiveBufferSize");
						}
	    			}
	    			catch (SocketException e)
	    			{
						log.warn("error setting TCPReceiveBufferSize",e);
	    			}
        		}
        		
	            int BUFFER_SIZE=8192; // 128 ms
	            int numRead=0;
	            long skypePacketCnt=0;
	            long ioErrorCnt=0;
	            long underRuns=0;
	            int availBytes;
	            int noDataCount=0;
	            
	            
	            //boolean writePcmFile=true;
	            //WavWriter filePcmOut=null;

	            //if (writePcmFile)
	            //{	
	            //	filePcmOut=new WavWriter("testingclips/test_pcm_out.wav");
	            //}
			  

	            
				byte[] inpcm=new byte[BUFFER_SIZE];
	            BufferedInputStream sockin = null;
	            SSInBandDtmfDetector dtmfDetecter=null;
	            PipedOutputStream skypeDtmfDectorStream=null;
	            
			    try
			    {
		            sockin = new BufferedInputStream(server.getInputStream(),BUFFER_SIZE);
		            
		            if (ua.skype_profile.enableSkypeDtmfDetector)
		            {	
		              dtmfDetecter=new SSInBandDtmfDetector(this,16000,2,ua.skype_profile.SkypeDtmfDetectorHitThreshold,ua.skype_profile.SkypeDtmfDetectorSilenceThreshold);
		              skypeDtmfDectorStream=new PipedOutputStream(dtmfDetecter.getPipedInputStream());
		            }
        		}
        		catch (IOException e)
        		{
        			log.fatal("error",e);
        			this.ua.hangup();
        			stopnow=true;
        		}
		            
	            log.debug("+++ skypeAudioReceiver Connected on port:"+ua.skypeOutPort);
				
				while (!stopnow)
				{
				    try
				    {
				    	availBytes=sockin.available();
				    }	
					catch(Exception e)
					{
				    	  if (!stopnow)
					    	  ioErrorCnt++;
				    	  availBytes=-999;
					}


					if (availBytes>=neededSkypeBytes)
			        {	
						
						if (availBytes>BUFFER_SIZE)
							availBytes=BUFFER_SIZE;
						
						noDataCount=0;
					    try
					    {
							numRead=sockin.read(inpcm,0,availBytes);
					    }	
						catch(Exception e)
						{
					    	  if (!stopnow)
						    	  ioErrorCnt++;
					    	  numRead=-999;
						}
						
			        	skypePacketCnt++;
			        	if (sipSending)
			        	{	
			        		
			        		try
			        		{
				        		skypeOutputStream.write(inpcm,0, numRead);
			        		}
			        		catch (IOException e)
			        		{
			        			log.error("pipe write error");
			        		}
			        		
			        		if (this.ua.skype_profile.jitterLevel==0) // don't do this if using jitter buffer
			        			this.ua.skypeRtpSender.skypeSentData();
			        	}
			        	
			            
			        	//if (writePcmFile)
			            //	filePcmOut.write(inpcm,numRead);
			            

		        		try
		        		{
		        			if (inbandDtmfActive)
		        				skypeDtmfDectorStream.write(inpcm,0,numRead); // send wav data to detector
		        		}
		        		catch (IOException e)
		        		{
		        			log.error("dtmf pipe write error");
		        		}
			        }
			        else if (availBytes!=-999 && !stopnow && sipSending)
			        {	 
		        		noDataCount++;
		        		if (noDataCount>5)
		        			underRuns++;
			        }
	        	    try{sleep(skypeSleepIntervalMs);}catch(Exception e){}
		        	
				}
				
        		try
        		{
        			sockin.close();

        			if (ua.skype_profile.enableSkypeDtmfDetector)
    					skypeDtmfDectorStream.close();
    				
				}
				catch (IOException e)
				{
					log.error("dtmf pipe write error");
				}
				
	           
				//if (writePcmFile)
	            //	filePcmOut.close();
	           

				if (ua.skype_profile.audioPriorityIncrease>0)
				{
					try
					{
					this.setPriority(Thread.NORM_PRIORITY);
					}
					catch (Exception e)
					{
						log.warn("resetPriority Error. ",e);
					}
				}

				
				setSipSending(false,neededSkypeBytes);
				String stats="SkypeAudioReceiver stats - packets:"+skypePacketCnt;
				if (ioErrorCnt>0)
					stats+=" timeOuts:"+ioErrorCnt;
				if (underRuns>0)
					stats+=" underRuns="+underRuns;
				log.info(stats);

	}
	
}
